/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.misc.util;

import com.gemstone.gemfire.internal.ClassPathLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class ClassFinder {
    public static Class[] getClasses(String packageName) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        Enumeration<URL> resources = classLoader.getResources(path);
        ArrayList<File> dirs = new ArrayList<File>();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            dirs.add(new File(resource.getFile()));
        }
        ArrayList classes = new ArrayList();
        for (File directory : dirs) {
            classes.addAll(ClassFinder.findClasses(directory, packageName));
        }
        return classes.toArray(new Class[classes.size()]);
    }

    public static List findClasses(File directory, String packageName) throws ClassNotFoundException {
        ArrayList classes = new ArrayList();
        if (!directory.exists()) {
            return classes;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                classes.addAll(ClassFinder.findClasses(file, packageName + "." + file.getName()));
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            classes.add(Class.forName(packageName + '.' + file.getName().substring(0, file.getName().length() - 6)));
        }
        return classes;
    }

    public static Class[] getClasses(String jarPath, String packageName) throws ClassNotFoundException, IOException {
        String[] classNames = ClassFinder.getClassNames(jarPath, packageName);
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            classes[i] = Class.forName(className);
        }
        return classes;
    }

    public static String[] getClassNames(String jarPath, String packageName) throws IOException {
        JarEntry jarEntry;
        File file;
        if (jarPath == null) {
            return new String[0];
        }
        if (jarPath.startsWith("/") || jarPath.indexOf(58) >= 0) {
            file = new File(jarPath);
        } else {
            String workingDir = System.getProperty("user.dir");
            file = new File(workingDir + "/" + jarPath);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        packageName = packageName.replaceAll("\\.", "/");
        JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            String name = jarEntry.getName();
            if (!name.startsWith(packageName) || !name.endsWith(".class")) continue;
            int endIndex = name.length() - 6;
            name = name.replaceAll("/", "\\.");
            name = name.substring(0, endIndex);
            arrayList.add(name);
        }
        jarFile.close();
        return arrayList.toArray(new String[0]);
    }

    public static Class[] getAllClasses(String jarPath) throws ClassNotFoundException, IOException {
        String[] classNames = ClassFinder.getAllClassNames(jarPath);
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            String className = classNames[i];
            classes[i] = ClassPathLoader.getLatest().forName(className);
        }
        return classes;
    }

    public static String[] getAllClassNames(String jarPath) throws IOException {
        JarEntry jarEntry;
        File file;
        if (jarPath == null) {
            return new String[0];
        }
        if ((jarPath = jarPath.trim()).length() == 0) {
            return new String[0];
        }
        if (jarPath.startsWith("/") || jarPath.indexOf(58) >= 0) {
            file = new File(jarPath);
        } else {
            String workingDir = System.getProperty("user.dir");
            file = new File(workingDir + "/" + jarPath);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        JarInputStream jarFile = new JarInputStream(new FileInputStream(file));
        while ((jarEntry = jarFile.getNextJarEntry()) != null) {
            String name = jarEntry.getName();
            if (!name.endsWith(".class")) continue;
            int endIndex = name.length() - 6;
            name = name.replaceAll("/", "\\.");
            name = name.substring(0, endIndex);
            arrayList.add(name);
        }
        jarFile.close();
        return arrayList.toArray(new String[0]);
    }
}

