/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.misc.util;

import com.gemstone.gemfire.DataSerializer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public abstract class DataSerializerEx
extends DataSerializer {
    public static void writeByteArray(byte[] array, byte[] buffer, Deflater compressor, DataOutput output) throws IOException {
        compressor.setInput(array);
        compressor.finish();
        int compressedDataLength = compressor.deflate(buffer);
        DataSerializer.writeByteArray(buffer, compressedDataLength, output);
    }

    public static byte[] readByteArray(byte[] buffer, Inflater decompressor, DataInput input) throws IOException {
        byte[] compressedBuffer = DataSerializer.readByteArray(input);
        decompressor.setInput(compressedBuffer, 0, compressedBuffer.length);
        byte[] retval = null;
        try {
            int resultLength = decompressor.inflate(buffer);
            retval = new byte[resultLength];
            System.arraycopy(compressedBuffer, 0, retval, 0, resultLength);
        }
        catch (DataFormatException e) {
            throw new IOException("Unable to decompress the byte array due to a data format error. " + e.getMessage());
        }
        return retval;
    }

    public static String readUTF(DataInput input) throws IOException {
        byte header = input.readByte();
        if (header == 69) {
            return null;
        }
        return input.readUTF();
    }

    public static void writeUTF(String value2, DataOutput output) throws IOException {
        if (value2 == null) {
            output.writeByte(69);
        } else {
            output.writeByte(42);
            output.writeUTF(value2);
        }
    }
}

