/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.misc.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class ReflectionUtil {
    public static String toStringPublicMembers(Object object) {
        if (object == null) {
            return null;
        }
        String retval = "";
        Class<?> cls = object.getClass();
        Field[] fields = cls.getFields();
        try {
            for (int i = 0; i < fields.length; ++i) {
                String name = fields[i].getName();
                Object value2 = fields[i].get(object);
                if (value2 instanceof byte[]) {
                    value2 = new String((byte[])value2);
                } else if (value2 instanceof Byte) {
                    value2 = ((Byte)value2).toString();
                }
                retval = retval + name + " = " + value2 + ", ";
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        if (retval.length() > 0) {
            retval = retval.substring(0, retval.length() - 2);
        }
        return retval;
    }

    public static String toStringGetters(Object object) {
        if (object == null) {
            return null;
        }
        String retval = "";
        Class<?> cls = object.getClass();
        Method[] methods = cls.getMethods();
        try {
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || (method.getModifiers() & 8) > 0 || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value2 = method.invoke(object, (Object[])null);
                    if (value2 instanceof byte[]) {
                        value2 = new String((byte[])value2);
                    } else if (value2 instanceof Byte) {
                        value2 = ((Byte)value2).toString();
                    }
                    retval = retval + name.substring(3) + " = " + value2 + ", ";
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (retval.length() > 0) {
            retval = retval.substring(0, retval.length() - 2);
        }
        return retval;
    }

    public static String toStringGettersAnd(Object object) {
        if (object == null) {
            return null;
        }
        String retval = "";
        Class<?> cls = object.getClass();
        Method[] methods = cls.getMethods();
        try {
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || (method.getModifiers() & 8) > 0 || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value2 = method.invoke(object, (Object[])null);
                    if (value2 instanceof byte[]) {
                        value2 = new String((byte[])value2);
                    } else if (value2 instanceof Byte) {
                        value2 = ((Byte)value2).toString();
                    }
                    if (value2 instanceof String) {
                        retval = retval + name.substring(3) + "='" + value2 + "' and ";
                        continue;
                    }
                    retval = retval + name.substring(3) + "=" + value2 + " and ";
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (retval.length() > 0) {
            retval = retval.substring(0, retval.length() - 5);
        }
        return retval;
    }

    public static String toStringSetters(Object object) {
        if (object == null) {
            return null;
        }
        String retval = "";
        Class<?> cls = object.getClass();
        Method[] methods = cls.getMethods();
        try {
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("set")) continue;
                retval = retval + name + ", ";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (retval.length() > 0) {
            retval = retval.substring(0, retval.length() - 2);
        }
        return retval;
    }

    public static Method[] getAllSetters(Class cls) {
        Map map = ReflectionUtil.getAllSettersMap(cls);
        if (map == null) {
            return null;
        }
        Collection col = map.values();
        return col.toArray(new Method[0]);
    }

    public static Map getAllSettersMap(Class cls) {
        if (cls == null) {
            return null;
        }
        Method[] methods = cls.getMethods();
        TreeMap<String, Method> map = new TreeMap<String, Method>();
        try {
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("set") || method.getParameterTypes().length != 1) continue;
                map.put(method.getName(), method);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static Method[] getAllGetters(Class cls) {
        Map map = ReflectionUtil.getAllGettersMap(cls);
        if (map == null) {
            return null;
        }
        Collection col = map.values();
        return col.toArray(new Method[0]);
    }

    public static Map getAllGettersMap(Class cls) {
        if (cls == null) {
            return null;
        }
        Method[] methods = cls.getMethods();
        TreeMap<String, Method> map = new TreeMap<String, Method>();
        try {
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || (method.getModifiers() & 8) > 0 || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE || method.getParameterTypes().length != 0) continue;
                map.put(name, method);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }

    public static Map getSetterMap(Class cls) {
        TreeMap<String, Method> map = new TreeMap<String, Method>();
        Method[] methods = ReflectionUtil.getAllSetters(cls);
        for (int i = 0; i < methods.length; ++i) {
            String memberName = methods[i].getName();
            memberName = memberName.substring(3);
            map.put(memberName, methods[i]);
        }
        return map;
    }
}

