/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.pogo;

import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyType;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class KeyTypeManager {
    private static ConcurrentHashMap<UUID, Map<Integer, KeyType>> uuidMap = new ConcurrentHashMap();

    public static void registerKeyType(KeyType keyType) {
        if (keyType == null) {
            return;
        }
        KeyTypeManager.registerSingleKeyType(keyType);
        Package pkg = keyType.getClass().getPackage();
        String keyTypeName = pkg == null ? "pogo." + keyType.getClass().getSimpleName() : pkg.getName() + ".pogo." + keyType.getClass().getSimpleName();
        int version = keyType.getVersion();
        while (true) {
            block4: {
                try {
                    Class<?> cls = Class.forName(keyTypeName + "_v" + version);
                    if (!cls.isEnum()) break;
                    ?[] consts = cls.getEnumConstants();
                    if (consts == null || consts.length <= 0 || !(consts[0] instanceof KeyType)) break block4;
                    KeyType ft = (KeyType)consts[0];
                    KeyTypeManager.registerSingleKeyType(ft);
                }
                catch (ClassNotFoundException e) {
                    break;
                }
            }
            --version;
        }
    }

    public static void registerSingleKeyType(KeyType keyType) {
        if (keyType == null) {
            return;
        }
        Map<Integer, KeyType> map = uuidMap.get(keyType.getId());
        if (map == null) {
            map = new TreeMap<Integer, KeyType>();
            uuidMap.put((UUID)keyType.getId(), map);
        }
        map.put(keyType.getVersion(), keyType);
    }

    public static boolean isRegistered(KeyType keyType) {
        if (keyType == null) {
            return false;
        }
        Map<Integer, KeyType> map = uuidMap.get(keyType.getId());
        if (map == null) {
            return false;
        }
        return map.get(keyType.getVersion()) != null;
    }

    private static void loadKeyType(KeyType keyType) {
        KeyTypeManager.registerKeyType(keyType);
        Package pkg = keyType.getClass().getPackage();
        String keyTypeName = pkg.getName() + keyType.getClass().getSimpleName();
        try {
            Class<?> cls = Class.forName(keyTypeName);
            Field field = cls.getField("VERSION");
            field.setInt(field, keyType.getVersion());
        }
        catch (ClassNotFoundException e) {
            return;
        }
        catch (NoSuchFieldException e) {
            return;
        }
        catch (IllegalAccessException e) {
            return;
        }
    }

    public static KeyType getKeyType(long uuidMostSigBits, long uuidLeastSigBits, int version) {
        return KeyTypeManager.getKeyType(new UUID(uuidMostSigBits, uuidLeastSigBits), version);
    }

    public static KeyType getKeyType(UUID uuid, int version) {
        Map<Integer, KeyType> map = uuidMap.get(uuid);
        if (map == null) {
            return null;
        }
        return map.get(version);
    }

    public static KeyType[] getValues(KeyType keyType, int version) {
        KeyType ft = KeyTypeManager.getKeyType((UUID)keyType.getId(), version);
        if (ft == null) {
            return null;
        }
        return ft.getValues();
    }
}

