/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.pogo;

import com.gemstone.gemfire.DataSerializable;
import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.Delta;
import com.gemstone.gemfire.InvalidDeltaException;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.InvalidKeyException;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyType;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.KeyTypeManager;
import com.gemstone.gemfire.internal.tools.gfsh.app.pogo.MapLiteSerializer;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;

public class MapLite<V>
implements DataSerializable,
Delta,
Map<String, V>,
Cloneable {
    private static final long serialVersionUID = 1L;
    private static final int BIT_MASK_SIZE = 32;
    private KeyType keyType;
    private Object[] values;
    private int keyVersion;
    private int[] dirtyFlags;
    private byte flags;
    private byte[] serializedBytes;

    public MapLite() {
    }

    public MapLite(KeyType keyType) {
        this.init(keyType);
    }

    private void init(KeyType keyType) {
        if (keyType == null) {
            return;
        }
        this.keyType = keyType;
        this.keyVersion = keyType.getVersion();
        int count = keyType.getKeyCount();
        this.values = new Object[count];
        int dirtyFlagCount = this.calculateDirtyFlagCount();
        this.dirtyFlags = new int[dirtyFlagCount];
        if (!KeyTypeManager.isRegistered(keyType)) {
            KeyTypeManager.registerKeyType(keyType);
        }
    }

    private int calculateDirtyFlagCount() {
        int count = this.keyType.getKeyCount();
        int dirtyFlagCount = count / 32;
        int reminder = count % 32;
        if (reminder > 0) {
            ++dirtyFlagCount;
        }
        return dirtyFlagCount;
    }

    private void dirtyAllKeys() {
        if (this.dirtyFlags != null) {
            for (int i = 0; i < this.dirtyFlags.length; ++i) {
                this.dirtyFlags[i] = -1;
            }
        }
    }

    private void clearDirty() {
        if (this.dirtyFlags != null) {
            for (int i = 0; i < this.dirtyFlags.length; ++i) {
                this.dirtyFlags[i] = 0;
            }
        }
    }

    public KeyType getKeyType() {
        return this.keyType;
    }

    public V get(KeyType keyType) {
        if (keyType == null) {
            return null;
        }
        if (this.values == null && keyType != null) {
            this.init(keyType);
        }
        return (V)this.values[keyType.getIndex()];
    }

    @Override
    public V put(KeyType keyType, V value2) throws InvalidKeyException {
        if (keyType == null) {
            return null;
        }
        if (this.values == null) {
            this.init(keyType);
        }
        Object oldVal = this.values[keyType.getIndex()];
        this.values[keyType.getIndex()] = value2;
        this.setDirty(keyType, this.dirtyFlags);
        return (V)oldVal;
    }

    @Override
    public V get(Object key2) {
        if (this.keyType == null || key2 == null) {
            return null;
        }
        this.deserialize();
        KeyType keyType = this.keyType.getKeyType(key2.toString());
        if (keyType == null) {
            return null;
        }
        return this.get(keyType);
    }

    @Override
    public V put(String key2, V value2) throws InvalidKeyException {
        if (this.keyType == null) {
            if (value2 == null) {
                throw new InvalidKeyException("KeyType undefined due to the use of the MapLite default constructor. Use MapLite(KeyType) to register the key type.");
            }
            throw new InvalidKeyException("Invalid " + value2.getClass().getName() + ". KeyType undefined due to the use of the default constructor.");
        }
        this.deserialize();
        KeyType keyType = this.keyType.getKeyType(key2.toString());
        if (keyType == null) {
            return null;
        }
        return this.put(keyType, value2);
    }

    @Override
    public boolean hasDelta() {
        if (this.keyType.isDeltaEnabled()) {
            return this.isDirty();
        }
        return false;
    }

    public boolean isDirty() {
        for (int i = 0; i < this.dirtyFlags.length; ++i) {
            if ((this.dirtyFlags[i] & 0xFFFFFFFF) == 0) continue;
            return true;
        }
        return false;
    }

    private void setDirty(KeyType keyType, int[] flags) {
        int index2 = keyType.getIndex();
        this.setDirty(index2, flags);
    }

    private void setDirty(int contiguousBit, int[] flags) {
        int dirtyFlagsIndex = contiguousBit / 32;
        int bit = contiguousBit % 32;
        int n = dirtyFlagsIndex;
        flags[n] = flags[n] | 1 << bit;
    }

    private boolean isBitDirty(int flag, int bit) {
        return (flag >> bit & 1) == 1;
    }

    private boolean isDirty(int flag) {
        return (flag & 0xFFFFFFFF) != 0;
    }

    private void deserialize() {
        byte[] byteArray = this.serializedBytes;
        if (byteArray != null) {
            KeyType[] keyTypeValues = this.keyType.getValues(this.keyVersion);
            ByteArrayInputStream bais = new ByteArrayInputStream(byteArray);
            DataInputStream dis = new DataInputStream(bais);
            try {
                for (int i = 0; i < keyTypeValues.length; ++i) {
                    if (!keyTypeValues[i].isKeyKeepSerialized()) continue;
                    this.values[i] = this.readValue(keyTypeValues, i, dis);
                }
                dis.close();
                this.serializedBytes = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private Object readValue(KeyType[] keyTypes, int index2, DataInput input) throws IOException, ClassNotFoundException {
        return MapLiteSerializer.read(keyTypes[index2].getType(), input);
    }

    @Override
    public void fromData(DataInput input) throws IOException, ClassNotFoundException {
        this.flags = MapLiteSerializer.readByte(input);
        long mostSigBits = input.readLong();
        long leastSigBits = input.readLong();
        this.keyVersion = DataSerializer.readUnsignedShort(input);
        this.keyType = KeyTypeManager.getKeyType(mostSigBits, leastSigBits, this.keyVersion);
        this.init(this.keyType);
        this.values = new Object[this.keyType.getKeyCount()];
        KeyType[] keyTypeValues = this.keyType.getValues(this.keyVersion);
        if (this.keyType.isPayloadKeepSerialized()) {
            this.serializedBytes = DataSerializer.readByteArray(input);
            byte[] deserializedBytes = DataSerializer.readByteArray(input);
            ByteArrayInputStream bais = new ByteArrayInputStream(deserializedBytes);
            DataInputStream dis = new DataInputStream(bais);
            for (int i = 0; i < keyTypeValues.length; ++i) {
                if (keyTypeValues[i].isKeyKeepSerialized()) continue;
                this.values[i] = this.readValue(keyTypeValues, i, dis);
            }
            dis.close();
        } else {
            for (int i = 0; i < keyTypeValues.length; ++i) {
                this.values[i] = this.readValue(keyTypeValues, i, input);
            }
        }
    }

    private void writeValue(KeyType[] keyTypes, int index2, DataOutput output) throws IOException {
        try {
            MapLiteSerializer.write(keyTypes[index2].getType(), this.values[index2], output);
        }
        catch (Exception ex) {
            throw new InvalidKeyException(ex.getMessage() + keyTypes.getClass() + " index=" + keyTypes[index2].getName(), ex);
        }
    }

    @Override
    public void toData(DataOutput output) throws IOException {
        MapLiteSerializer.writeByte(this.flags, output);
        output.writeLong(((UUID)this.keyType.getId()).getMostSignificantBits());
        output.writeLong(((UUID)this.keyType.getId()).getLeastSignificantBits());
        DataSerializer.writeUnsignedShort(this.keyType.getVersion(), output);
        KeyType[] keyTypeValues = this.keyType.getValues(this.keyVersion);
        if (this.keyType.isPayloadKeepSerialized()) {
            byte[] byteArray = this.serializedBytes;
            if (byteArray != null) {
                DataSerializer.writeByteArray(byteArray, output);
                HeapDataOutputStream hdos2 = new HeapDataOutputStream(Version.CURRENT);
                for (int i = 0; i < keyTypeValues.length; ++i) {
                    if (keyTypeValues[i].isKeyKeepSerialized()) continue;
                    this.writeValue(keyTypeValues, i, hdos2);
                }
                DataSerializer.writeByteArray(hdos2.toByteArray(), output);
                hdos2.close();
            } else {
                HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);
                HeapDataOutputStream hdos2 = new HeapDataOutputStream(Version.CURRENT);
                for (int i = 0; i < keyTypeValues.length; ++i) {
                    if (keyTypeValues[i].isKeyKeepSerialized()) {
                        this.writeValue(keyTypeValues, i, hdos);
                        continue;
                    }
                    this.writeValue(keyTypeValues, i, hdos2);
                }
                DataSerializer.writeByteArray(hdos.toByteArray(), output);
                DataSerializer.writeByteArray(hdos2.toByteArray(), output);
                hdos.close();
                hdos2.close();
            }
        } else {
            for (int i = 0; i < keyTypeValues.length; ++i) {
                this.writeValue(keyTypeValues, i, output);
            }
        }
        this.clearDirty();
    }

    @Override
    public void fromDelta(DataInput input) throws IOException, InvalidDeltaException {
        KeyType[] keyTypeValues = this.keyType.getValues();
        int bitCount = keyTypeValues.length;
        int dirtyFlagCount = this.dirtyFlags.length;
        int[] dirtyFlagsToApply = new int[dirtyFlagCount];
        for (int i = 0; i < dirtyFlagCount; ++i) {
            dirtyFlagsToApply[i] = input.readInt();
        }
        try {
            int count = 32;
            for (int i = 0; i < dirtyFlagsToApply.length; ++i) {
                int dirty = dirtyFlagsToApply[i];
                int userDirty = this.dirtyFlags[i];
                if (i == dirtyFlagsToApply.length - 1 && (count = bitCount % 32) == 0 && bitCount != 0) {
                    count = 32;
                }
                int startIndex = i * 32;
                for (int j = 0; j < count; ++j) {
                    if (!this.isBitDirty(dirty, j)) continue;
                    int index2 = startIndex + j;
                    Object value2 = MapLiteSerializer.readObject(input);
                    if (this.isBitDirty(userDirty, j)) continue;
                    this.values[index2] = value2;
                }
            }
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
    }

    @Override
    public void toDelta(DataOutput output) throws IOException {
        KeyType[] keyTypeValues = this.keyType.getValues();
        int bitCount = keyTypeValues.length;
        for (int i = 0; i < this.dirtyFlags.length; ++i) {
            output.writeInt(this.dirtyFlags[i]);
        }
        int count = 32;
        for (int i = 0; i < this.dirtyFlags.length; ++i) {
            int dirty = this.dirtyFlags[i];
            if (!this.isDirty(dirty)) continue;
            if (i == this.dirtyFlags.length - 1 && (count = bitCount % 32) == 0 && bitCount != 0) {
                count = 32;
            }
            int startIndex = i * 32;
            for (int j = 0; j < count; ++j) {
                if (!this.isBitDirty(dirty, j)) continue;
                int index2 = startIndex + j;
                MapLiteSerializer.writeObject(this.values[index2], output);
            }
        }
        this.clearDirty();
    }

    public Object getId() {
        if (this.keyType == null) {
            return null;
        }
        return this.keyType.getId();
    }

    public int getKeyTypeVersion() {
        if (this.keyType == null) {
            return 0;
        }
        return this.keyType.getVersion();
    }

    public String getName() {
        if (this.keyType == null) {
            return null;
        }
        return this.keyType.getClass().getSimpleName();
    }

    public String getKeyTypeName() {
        if (this.keyType == null) {
            return null;
        }
        return this.keyType.getClass().getSimpleName();
    }

    @Override
    public Set<String> keySet() {
        TreeSet<String> retSet = new TreeSet<String>();
        if (this.keyType != null) {
            Set<String> set = this.keyType.getNameSet();
            for (String key2 : set) {
                if (this.get(key2) == null) continue;
                retSet.add(key2);
            }
        }
        return retSet;
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> list = new ArrayList<Object>(this.values.length + 1);
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            list.add(this.values[i]);
        }
        return Collections.unmodifiableCollection(list);
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        if (this.keyType == null) {
            return null;
        }
        HashMap<String, V> map = new HashMap<String, V>(this.keyType.getKeyCount() + 1, 1.0f);
        for (KeyType ft : this.keyType.getValues()) {
            V value2 = this.get(ft);
            if (value2 == null) continue;
            map.put(ft.getName(), this.get(ft));
        }
        return Collections.unmodifiableMap(map).entrySet();
    }

    @Override
    public void clear() {
        if (this.values != null) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == null) continue;
                this.setDirty(i, this.dirtyFlags);
            }
            this.values = new Object[this.values.length];
        }
    }

    @Override
    public boolean containsKey(Object key2) {
        if (this.keyType == null) {
            return false;
        }
        return this.get(key2) != null;
    }

    @Override
    public boolean containsValue(Object value2) {
        if (this.keyType == null) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != value2) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        if (this.keyType == null || this.values == null) {
            return true;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            return false;
        }
        return false;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        MapLite ml;
        if (map == null) {
            return;
        }
        if (this.keyType == null) {
            if (map instanceof MapLite) {
                MapLite ml2 = (MapLite)map;
                if (ml2.getKeyType() == null) {
                    return;
                }
                this.init(ml2.getKeyType());
                System.arraycopy(ml2.values, 0, this.values, 0, this.values.length);
                this.dirtyAllKeys();
                return;
            }
            return;
        }
        if (map instanceof MapLite && this.keyType == (ml = (MapLite)map).getKeyType()) {
            System.arraycopy(ml.values, 0, this.values, 0, this.values.length);
            this.dirtyAllKeys();
            return;
        }
        Set<Map.Entry<String, V>> set = map.entrySet();
        for (Map.Entry<String, V> entry : set) {
            KeyType keyType = this.keyType.getKeyType(entry.getKey());
            if (keyType == null || entry.getValue() != null && keyType.getType() != entry.getValue().getClass()) continue;
            this.put(keyType, entry.getValue());
        }
    }

    @Override
    public V remove(Object key2) {
        if (this.keyType == null || key2 == null) {
            return null;
        }
        KeyType keyType = this.keyType.getKeyType(key2.toString());
        if (keyType == null) {
            return null;
        }
        Object oldVal = this.values[keyType.getIndex()];
        if (oldVal != null) {
            this.setDirty(keyType, this.dirtyFlags);
        }
        this.values[keyType.getIndex()] = null;
        return (V)oldVal;
    }

    @Override
    public int size() {
        if (this.keyType == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null) continue;
            ++count;
        }
        return count;
    }

    public int getKeyCount() {
        if (this.keyType == null) {
            return 0;
        }
        return this.keyType.getKeyCount();
    }

    public Object clone() {
        if (this.keyType == null) {
            return new MapLite<V>();
        }
        MapLite<V> ml = new MapLite<V>(this.keyType);
        System.arraycopy(this.values, 0, ml.values, 0, this.values.length);
        System.arraycopy(this.dirtyFlags, 0, ml.dirtyFlags, 0, this.dirtyFlags.length);
        if (this.serializedBytes != null) {
            System.arraycopy(this.serializedBytes, 0, ml.serializedBytes, 0, this.serializedBytes.length);
        }
        return ml;
    }
}

