/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.util;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.tools.gfsh.app.Gfsh;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryResults;
import com.gemstone.gemfire.internal.tools.gfsh.app.command.task.QueryTask;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ReflectionUtil;
import com.gemstone.gemfire.internal.tools.gfsh.app.util.DBUtilException;
import com.gemstone.gemfire.internal.tools.gfsh.command.CommandResults;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DBUtil {
    public static final int TYPE_KEYS = 0;
    public static final int TYPE_VALUES = 1;
    public static final int TYPE_KEYS_VALUES = 2;
    private static DBUtil dbutil;
    static SimpleDateFormat dateFormat;
    static SimpleDateFormat smallDateFormat;
    protected Connection conn;
    private String driverName;
    private String url;
    private String userName;

    private DBUtil(String driverName) throws DBUtilException {
        this.init(driverName);
    }

    @SuppressFBWarnings(value={"LI_LAZY_INIT_UPDATE_STATIC"}, justification="This looks like singleton and at present looks like desired functionality")
    public static DBUtil initialize(String driverName, String url, String userName, String password) throws DBUtilException {
        if (dbutil != null) {
            dbutil.close();
        }
        dbutil = new DBUtil(driverName);
        dbutil.connect(url, userName, password);
        return dbutil;
    }

    public static DBUtil getDBUtil() {
        return dbutil;
    }

    private void init(String driverName) throws DBUtilException {
        try {
            Driver driver = (Driver)Class.forName(driverName).newInstance();
            DriverManager.registerDriver(driver);
            this.driverName = driverName;
        }
        catch (Exception ex) {
            throw new DBUtilException(ex);
        }
    }

    private synchronized void connect(String url, String userName, String password) throws DBUtilException {
        if (this.conn != null) {
            throw new DBUtilException(2, "The database connection has already been established. To establish a new connection, close it first.");
        }
        Properties props = new Properties();
        props.put("user", userName);
        props.put("password", password);
        try {
            this.conn = DriverManager.getConnection(url, props);
            this.url = url;
            this.userName = userName;
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            System.out.println("Error Code: " + ex.getErrorCode());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new DBUtilException(ex);
        }
    }

    public String getDriverName() {
        return this.driverName;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUserName() {
        return this.userName;
    }

    public synchronized void close() throws DBUtilException {
        try {
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (Exception ex) {
            throw new DBUtilException(ex);
        }
    }

    public boolean isClosed() {
        return this.conn == null;
    }

    public int loadDB(Gfsh gfsh, Region region, Class keyClass, Class valueClass, String sql, String primaryColumn) throws DBUtilException {
        int count = 0;
        Statement statement = null;
        try {
            Map keySettersMap = ReflectionUtil.getAllSettersMap(keyClass);
            Map valueSettersMap = ReflectionUtil.getAllSettersMap(valueClass);
            HashMap<String, Method> realMap = new HashMap<String, Method>();
            if (!sql.startsWith("select ")) {
                sql = "select * from " + sql;
            }
            statement = this.conn.prepareStatement(sql);
            ResultSet resultSet = statement.executeQuery();
            while (resultSet.next()) {
                Object key2 = this.updateObject(gfsh, keyClass, keySettersMap, realMap, resultSet, primaryColumn);
                Object value2 = this.updateObject(gfsh, valueClass, valueSettersMap, realMap, resultSet, null);
                region.put(key2, value2);
                ++count;
            }
        }
        catch (Exception ex) {
            throw new DBUtilException(ex);
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    throw new DBUtilException(e);
                }
            }
        }
        return count;
    }

    public int storeDB(Gfsh gfsh, Region region, String tableName, int storeType, String primaryColumn, boolean isKeyPrimary) throws DBUtilException {
        int count = 0;
        try {
            DatabaseMetaData meta = this.conn.getMetaData();
            ResultSet resultSet = meta.getColumns(null, null, tableName, null);
            ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
            while (resultSet.next()) {
                ColumnInfo info = new ColumnInfo();
                info.name = (String)resultSet.getObject("COLUMN_NAME");
                info.type = (Integer)resultSet.getObject("DATA_TYPE");
                columnList.add(info);
            }
            Set entrySet = region.entrySet();
            Map<String, Method> keyGettersMap = new HashMap(0);
            Map<String, Method> valueGettersMap = new HashMap(0);
            int columnCount = 0;
            String[] keyKeys = new String[]{};
            String[] valueKeys = new String[]{};
            Iterator i$ = entrySet.iterator();
            if (i$.hasNext()) {
                Region.Entry entry = (Region.Entry)i$.next();
                Object key2 = entry.getKey();
                Object v = entry.getValue();
                switch (storeType) {
                    case 0: {
                        keyGettersMap = ReflectionUtil.getAllGettersMap(key2.getClass());
                        keyGettersMap = this.getGettersMap(keyGettersMap, columnList);
                        columnCount = keyGettersMap.size();
                        keyKeys = keyGettersMap.keySet().toArray(new String[0]);
                        break;
                    }
                    case 1: {
                        valueGettersMap = ReflectionUtil.getAllGettersMap(v.getClass());
                        valueGettersMap = this.getGettersMap(valueGettersMap, columnList);
                        columnCount = valueGettersMap.size();
                        valueKeys = valueGettersMap.keySet().toArray(new String[0]);
                        break;
                    }
                    case 2: {
                        keyGettersMap = ReflectionUtil.getAllGettersMap(key2.getClass());
                        keyGettersMap = this.getGettersMap(keyGettersMap, columnList);
                        valueGettersMap = ReflectionUtil.getAllGettersMap(v.getClass());
                        valueGettersMap = this.getGettersMap(valueGettersMap, columnList);
                        columnCount = keyGettersMap.size() + valueGettersMap.size();
                        keyKeys = keyGettersMap.keySet().toArray(new String[0]);
                        valueKeys = valueGettersMap.keySet().toArray(new String[0]);
                    }
                }
                Set keySet = valueGettersMap.keySet();
                if (primaryColumn != null) {
                    for (String keyStr : keySet) {
                        if (!primaryColumn.equalsIgnoreCase(keyStr)) continue;
                        primaryColumn = keyStr;
                        break;
                    }
                }
                for (String keyStr : keySet) {
                    if (isKeyPrimary && primaryColumn != null && primaryColumn.equalsIgnoreCase(keyStr)) continue;
                    keyGettersMap.remove(keyStr);
                }
            }
            try {
                String insertQuery = this.createInsertQuery(keyKeys, valueKeys, tableName);
                String updateQuery = this.createUpdateQuery(keyKeys, valueKeys, tableName, primaryColumn, isKeyPrimary);
                for (Region.Entry entry : entrySet) {
                    Object key3 = entry.getKey();
                    Object value3 = entry.getValue();
                    PreparedStatement statement = this.createInsertPreparedStatement(keyGettersMap, valueGettersMap, keyKeys, valueKeys, key3, value3, insertQuery);
                    try {
                        statement.executeUpdate();
                    }
                    catch (SQLException ex) {
                        statement = this.createUpdatePreparedStatement(keyGettersMap, valueGettersMap, keyKeys, valueKeys, key3, value3, updateQuery, primaryColumn, isKeyPrimary);
                        statement.executeUpdate();
                    }
                    ++count;
                }
            }
            catch (SQLException ex) {
                throw new DBUtilException(ex);
            }
        }
        catch (Exception ex) {
            throw new DBUtilException(ex);
        }
        return count;
    }

    private List<ColumnInfo> getColumnInfoList(String tableName) throws SQLException {
        ArrayList<ColumnInfo> columnList;
        block8: {
            String lowercase = tableName.toLowerCase();
            columnList = new ArrayList<ColumnInfo>();
            if (lowercase.startsWith("insert ")) break block8;
            if (lowercase.startsWith("update ")) {
                String[] split = tableName.split("= *\\?");
                for (int i = 0; i < split.length; ++i) {
                    String token = split[i].trim();
                    int index2 = token.indexOf(61);
                    if (index2 >= 0) {
                        String x = token.substring(index2);
                        index2 = (x = x.trim()).lastIndexOf(44);
                        if (index2 > 0) {
                            token = x.substring(index2 + 1);
                        } else {
                            index2 = x.lastIndexOf(32);
                            if (index2 <= 0) continue;
                            token = x.substring(index2 + 1);
                        }
                    }
                    if ((index2 = token.lastIndexOf(32)) != -1) {
                        token = token.substring(index2);
                    }
                    token = token.replace(',', ' ');
                    token = token.trim();
                    ColumnInfo info = new ColumnInfo();
                    info.name = token;
                    columnList.add(info);
                }
            } else {
                DatabaseMetaData meta = this.conn.getMetaData();
                ResultSet resultSet = meta.getColumns(null, null, tableName, null);
                while (resultSet.next()) {
                    ColumnInfo info = new ColumnInfo();
                    info.name = (String)resultSet.getObject("COLUMN_NAME");
                    info.type = (Integer)resultSet.getObject("DATA_TYPE");
                    columnList.add(info);
                }
            }
        }
        return columnList;
    }

    private String[] getColumnNames(List<ColumnInfo> columnList) {
        String[] columnNames = new String[columnList.size()];
        for (int i = 0; i < columnList.size(); ++i) {
            columnNames[i] = columnList.get((int)i).name;
        }
        return columnNames;
    }

    private int storeMapDB(Gfsh gfsh, Map map, String tableName, int storeType, String primaryColumn, boolean isKeyPrimary, List<ColumnInfo> columnList, boolean isQuery) throws DBUtilException {
        int count = 0;
        try {
            Set entrySet = map.entrySet();
            Map<String, Method> keyGettersMap = new HashMap(0);
            Map<String, Method> valueGettersMap = new HashMap(0);
            int columnCount = 0;
            String[] keyKeys = new String[]{};
            String[] valueKeys = new String[]{};
            Iterator i$ = entrySet.iterator();
            if (i$.hasNext()) {
                Map.Entry entry = i$.next();
                Object key2 = entry.getKey();
                Object value2 = entry.getValue();
                switch (storeType) {
                    case 0: {
                        keyGettersMap = ReflectionUtil.getAllGettersMap(key2.getClass());
                        keyGettersMap = this.getGettersMap(keyGettersMap, columnList);
                        columnCount = keyGettersMap.size();
                        if (isQuery) {
                            keyKeys = this.getColumnNames(columnList);
                            break;
                        }
                        keyKeys = keyGettersMap.keySet().toArray(new String[0]);
                        break;
                    }
                    case 1: {
                        valueGettersMap = ReflectionUtil.getAllGettersMap(value2.getClass());
                        valueGettersMap = this.getGettersMap(valueGettersMap, columnList);
                        columnCount = valueGettersMap.size();
                        if (isQuery) {
                            valueKeys = this.getColumnNames(columnList);
                            break;
                        }
                        valueKeys = valueGettersMap.keySet().toArray(new String[0]);
                        break;
                    }
                    case 2: {
                        keyGettersMap = ReflectionUtil.getAllGettersMap(key2.getClass());
                        keyGettersMap = this.getGettersMap(keyGettersMap, columnList);
                        valueGettersMap = ReflectionUtil.getAllGettersMap(value2.getClass());
                        valueGettersMap = this.getGettersMap(valueGettersMap, columnList);
                        columnCount = keyGettersMap.size() + valueGettersMap.size();
                        if (isQuery) {
                            keyKeys = this.getColumnNames(columnList);
                            valueKeys = this.getColumnNames(columnList);
                            break;
                        }
                        keyKeys = keyGettersMap.keySet().toArray(new String[0]);
                        valueKeys = valueGettersMap.keySet().toArray(new String[0]);
                    }
                }
                Set keySet = valueGettersMap.keySet();
                if (primaryColumn != null) {
                    for (String keyStr : keySet) {
                        if (!primaryColumn.equalsIgnoreCase(keyStr)) continue;
                        primaryColumn = keyStr;
                        break;
                    }
                }
                for (String keyStr : keySet) {
                    if (isKeyPrimary && primaryColumn != null && primaryColumn.equalsIgnoreCase(keyStr)) continue;
                    keyGettersMap.remove(keyStr);
                }
            }
            try {
                String insertQuery = this.createInsertQuery(keyKeys, valueKeys, tableName);
                String updateQuery = this.createUpdateQuery(keyKeys, valueKeys, tableName, primaryColumn, isKeyPrimary);
                if (gfsh.isDebug()) {
                    System.out.println("insert: " + insertQuery);
                    System.out.println("update: " + updateQuery);
                }
                for (Map.Entry entry : entrySet) {
                    PreparedStatement statement;
                    Object key3 = entry.getKey();
                    Object value3 = entry.getValue();
                    if (insertQuery != null) {
                        try {
                            statement = this.createInsertPreparedStatement(keyGettersMap, valueGettersMap, keyKeys, valueKeys, key3, value3, insertQuery);
                            statement.executeUpdate();
                        }
                        catch (SQLException ex) {
                            if (updateQuery != null) {
                                statement = this.createUpdatePreparedStatement(keyGettersMap, valueGettersMap, keyKeys, valueKeys, key3, value3, updateQuery, primaryColumn, isKeyPrimary);
                                statement.executeUpdate();
                            }
                        }
                    } else {
                        statement = this.createUpdatePreparedStatement(keyGettersMap, valueGettersMap, keyKeys, valueKeys, key3, value3, updateQuery, primaryColumn, isKeyPrimary);
                        statement.executeUpdate();
                    }
                    ++count;
                }
            }
            catch (SQLException ex) {
                throw new DBUtilException(ex);
            }
        }
        catch (Exception ex) {
            throw new DBUtilException(ex);
        }
        return count;
    }

    public int storeDB(Gfsh gfsh, String oql, String tableName, int storeType, String primaryColumn, boolean isKeyPrimary, int batchSize) throws DBUtilException {
        String lowercase = tableName.toLowerCase();
        boolean isQuery = lowercase.startsWith("insert ") || lowercase.startsWith("update ");
        int count = 0;
        String insertQuery = null;
        String updateQuery = null;
        int columnCount = 0;
        Map<String, Method> valueGettersMap = null;
        String[] valueKeys = null;
        try {
            int actualSize;
            List<ColumnInfo> columnList = this.getColumnInfoList(tableName);
            do {
                CommandResults cr;
                if ((cr = gfsh.getCommandClient().execute(new QueryTask(oql, batchSize, true))).getCode() == 1) {
                    gfsh.println(cr.getCodeMessage());
                    return -1;
                }
                QueryResults results = (QueryResults)cr.getDataObject();
                if (results == null || results.getResults() == null) {
                    return count;
                }
                if (results.getResults() instanceof Map) {
                    Map map = (Map)results.getResults();
                    count += this.storeMapDB(gfsh, map, tableName, storeType, primaryColumn, isKeyPrimary, columnList, isQuery);
                } else {
                    SelectResults sr = (SelectResults)results.getResults();
                    CollectionType type = sr.getCollectionType();
                    ObjectType elementType = type.getElementType();
                    List srList = sr.asList();
                    Object element = null;
                    StructType structType = null;
                    Struct struct = null;
                    if (insertQuery == null && srList.size() > 0) {
                        element = srList.get(0);
                        if (elementType.isStructType()) {
                            structType = (StructType)elementType;
                            insertQuery = this.createInsertQuery(structType.getFieldNames(), tableName);
                            updateQuery = this.createUpdateQuery(structType.getFieldNames(), tableName, primaryColumn);
                        } else {
                            valueGettersMap = new HashMap<String, Method>(0);
                            valueGettersMap = ReflectionUtil.getAllGettersMap(element.getClass());
                            valueGettersMap = this.getGettersMap(valueGettersMap, columnList);
                            columnCount = valueGettersMap.size();
                            valueKeys = isQuery ? this.getColumnNames(columnList) : valueGettersMap.keySet().toArray(new String[0]);
                            insertQuery = this.createInsertQuery(valueKeys, tableName);
                            updateQuery = this.createUpdateQuery(valueKeys, tableName, primaryColumn);
                        }
                        if (gfsh.isDebug()) {
                            System.out.println("insert: " + insertQuery);
                            System.out.println("update: " + updateQuery);
                        }
                    }
                    for (int i = 0; i < srList.size(); ++i) {
                        PreparedStatement statement;
                        element = srList.get(i);
                        if (elementType.isStructType()) {
                            structType = (StructType)elementType;
                            struct = (Struct)element;
                            statement = this.createInsertPreparedStatement(struct, insertQuery);
                            try {
                                statement.executeUpdate();
                            }
                            catch (SQLException ex) {
                                statement = this.createUpdatePreparedStatement(struct, updateQuery, primaryColumn);
                                statement.executeUpdate();
                            }
                            continue;
                        }
                        if (insertQuery != null) {
                            try {
                                statement = this.createInsertPreparedStatement(valueGettersMap, valueKeys, element, insertQuery);
                                statement.executeUpdate();
                            }
                            catch (SQLException ex) {
                                if (updateQuery == null) continue;
                                statement = this.createUpdatePreparedStatement(valueGettersMap, valueKeys, element, updateQuery, primaryColumn);
                                statement.executeUpdate();
                            }
                            continue;
                        }
                        statement = this.createUpdatePreparedStatement(valueGettersMap, valueKeys, element, updateQuery, primaryColumn);
                        System.out.println(statement.toString());
                        statement.executeUpdate();
                    }
                    count += sr.size();
                }
                actualSize = results.getActualSize();
                oql = null;
            } while (count < actualSize);
        }
        catch (Exception ex) {
            throw new DBUtilException(ex);
        }
        return count;
    }

    private PreparedStatement createUpdatePreparedStatement(Struct struct, String query, String primaryColumn) throws SQLException, InvocationTargetException, IllegalAccessException {
        int i;
        Object primaryObj = null;
        PreparedStatement statement = this.conn.prepareStatement(query);
        String[] fieldNames = struct.getStructType().getFieldNames();
        Object[] fieldValues = struct.getFieldValues();
        for (i = 0; i < fieldValues.length; ++i) {
            statement.setObject(i + 1, fieldValues[i]);
            Object obj = fieldValues[i];
            if (primaryColumn != null && primaryColumn.equals(fieldNames[i])) {
                primaryObj = obj;
                continue;
            }
            statement.setObject(i + 1, obj);
        }
        if (primaryObj != null) {
            statement.setObject(i + 1, primaryObj);
        }
        return statement;
    }

    private PreparedStatement createInsertPreparedStatement(Struct struct, String query) throws SQLException, InvocationTargetException, IllegalAccessException {
        PreparedStatement statement = this.conn.prepareStatement(query);
        Object[] fieldValues = struct.getFieldValues();
        for (int i = 0; i < fieldValues.length; ++i) {
            statement.setObject(i + 1, fieldValues[i]);
        }
        return statement;
    }

    private PreparedStatement createUpdatePreparedStatement(Map<String, Method> valueGettersMap, String[] valueKeys, Object value2, String query, String primaryColumn) throws SQLException, InvocationTargetException, IllegalAccessException {
        return this.createUpdatePreparedStatement(null, valueGettersMap, null, valueKeys, null, value2, query, primaryColumn, false);
    }

    private PreparedStatement createInsertPreparedStatement(Map<String, Method> valueGettersMap, String[] valueKeys, Object value2, String query) throws SQLException, InvocationTargetException, IllegalAccessException {
        return this.createInsertPreparedStatement(null, valueGettersMap, null, valueKeys, null, value2, query);
    }

    private PreparedStatement createUpdatePreparedStatement(Map<String, Method> keyGettersMap, Map<String, Method> valueGettersMap, String[] keyKeys, String[] valueKeys, Object key2, Object value2, String query, String primaryColumn, boolean isKeyPrimary) throws SQLException, InvocationTargetException, IllegalAccessException {
        Object obj;
        Method method;
        int i;
        Object primaryObj = null;
        PreparedStatement statement = this.conn.prepareStatement(query);
        int index2 = 1;
        if (keyKeys != null) {
            for (i = 0; i < keyKeys.length; ++i) {
                method = keyGettersMap.get(keyKeys[i]);
                obj = method.invoke(key2, (Object[])null);
                if (primaryColumn != null && !isKeyPrimary && primaryColumn.equals(keyKeys[i])) {
                    primaryObj = obj;
                    continue;
                }
                statement.setObject(index2++, obj);
            }
        }
        if (valueKeys != null) {
            for (i = 0; i < valueKeys.length; ++i) {
                method = valueGettersMap.get(valueKeys[i]);
                obj = method.invoke(value2, (Object[])null);
                if (primaryColumn != null && !isKeyPrimary && primaryColumn.equals(valueKeys[i])) {
                    primaryObj = obj;
                    continue;
                }
                statement.setObject(index2++, obj);
            }
        }
        if (primaryObj != null) {
            statement.setObject(index2, primaryObj);
        }
        return statement;
    }

    private PreparedStatement createInsertPreparedStatement(Map<String, Method> keyGettersMap, Map<String, Method> valueGettersMap, String[] keyKeys, String[] valueKeys, Object key2, Object value2, String query) throws SQLException, InvocationTargetException, IllegalAccessException {
        Object obj;
        Method method;
        int i;
        PreparedStatement statement = this.conn.prepareStatement(query);
        if (keyKeys != null) {
            for (i = 0; i < keyKeys.length; ++i) {
                method = keyGettersMap.get(keyKeys[i]);
                obj = method.invoke(key2, (Object[])null);
                statement.setObject(i + 1, obj);
            }
        }
        if (valueKeys != null) {
            for (i = 0; i < valueKeys.length; ++i) {
                method = valueGettersMap.get(valueKeys[i]);
                obj = method.invoke(value2, (Object[])null);
                statement.setObject(i + 1, obj);
            }
        }
        return statement;
    }

    private String createUpdateQuery(String[] fieldNames, String tableName, String primaryColumn) {
        String query = null;
        String lowercase = tableName.trim().toLowerCase();
        if (lowercase.startsWith("insert ")) {
            query = null;
        } else if (lowercase.startsWith("update ")) {
            query = tableName;
        } else {
            query = "UPDATE " + tableName + " SET ";
            for (int i = 0; i < fieldNames.length; ++i) {
                if (primaryColumn != null && primaryColumn.equals(fieldNames[i])) continue;
                query = query + fieldNames[i] + "=?,";
            }
            int index2 = query.lastIndexOf(",");
            if (index2 != -1) {
                query = query.substring(0, index2);
            }
            if (primaryColumn != null) {
                query = query + " WHERE " + primaryColumn + "=?";
            }
        }
        return query;
    }

    private String createInsertQuery(String[] fieldNames, String tableName) {
        String lowercase = tableName.trim().toLowerCase();
        String query = null;
        if (lowercase.startsWith("insert ")) {
            query = tableName;
        } else if (lowercase.startsWith("update ")) {
            query = null;
        } else {
            query = "INSERT INTO " + tableName + " (";
            for (int i = 0; i < fieldNames.length; ++i) {
                query = query + fieldNames[i] + ",";
            }
            int index2 = query.lastIndexOf(44);
            if (index2 != -1) {
                query = query.substring(0, index2);
            }
            int columnCount = fieldNames.length;
            query = query + ") VALUES (";
            for (int i = 0; i < columnCount; ++i) {
                query = query + "?,";
            }
            index2 = query.lastIndexOf(44);
            if (index2 != -1) {
                query = query.substring(0, index2);
            }
            query = query + ")";
        }
        return query;
    }

    private String createUpdateQuery(String[] keyKeys, String[] valueKeys, String tableName, String primaryColumn, boolean isKeyPrimary) {
        String query = null;
        String lowercase = tableName.trim().toLowerCase();
        if (lowercase.startsWith("insert ")) {
            query = null;
        } else if (lowercase.startsWith("update ")) {
            query = tableName;
        } else {
            int i;
            query = "UPDATE " + tableName + " SET ";
            for (i = 0; i < keyKeys.length; ++i) {
                if (primaryColumn != null && isKeyPrimary && primaryColumn.equals(keyKeys[i])) continue;
                query = query + keyKeys[i] + "=?,";
            }
            for (i = 0; i < valueKeys.length; ++i) {
                if (primaryColumn != null && !isKeyPrimary && primaryColumn.equals(valueKeys[i])) continue;
                query = query + valueKeys[i] + "=?,";
            }
            int index2 = query.lastIndexOf(",");
            if (index2 != -1) {
                query = query.substring(0, index2);
            }
            if (primaryColumn != null) {
                query = query + " WHERE " + primaryColumn + "=?";
            }
        }
        return query;
    }

    private String createInsertQuery(String[] keyKeys, String[] valueKeys, String tableName) {
        String lowercase = tableName.trim().toLowerCase();
        String query = null;
        if (lowercase.startsWith("insert ")) {
            query = tableName;
        } else if (lowercase.startsWith("update ")) {
            query = null;
        } else {
            int index2;
            int i;
            int columnCount = 0;
            query = "INSERT INTO " + tableName + " (";
            if (keyKeys != null) {
                for (i = 0; i < keyKeys.length; ++i) {
                    query = query + keyKeys[i] + ",";
                }
                columnCount += keyKeys.length;
            }
            if (valueKeys != null) {
                for (i = 0; i < valueKeys.length; ++i) {
                    query = query + valueKeys[i] + ",";
                }
                columnCount += valueKeys.length;
            }
            if ((index2 = query.lastIndexOf(44)) != -1) {
                query = query.substring(0, index2);
            }
            query = query + ") VALUES (";
            for (int i2 = 0; i2 < columnCount; ++i2) {
                query = query + "?,";
            }
            index2 = query.lastIndexOf(44);
            if (index2 != -1) {
                query = query.substring(0, index2);
            }
            query = query + ")";
        }
        return query;
    }

    private Map getGettersMap(Map<String, Method> gettersMap, List<ColumnInfo> columnList) {
        HashMap<String, Method> map = new HashMap<String, Method>();
        Set<String> keySet = gettersMap.keySet();
        for (int i = 0; i < columnList.size(); ++i) {
            ColumnInfo info = columnList.get(i);
            Method getterMethod = gettersMap.get("get" + info.name);
            if (getterMethod == null) {
                for (String key2 : keySet) {
                    if (!key2.substring(3).equalsIgnoreCase(info.name)) continue;
                    getterMethod = gettersMap.get(key2);
                    break;
                }
            }
            if (getterMethod == null) continue;
            map.put(info.name, getterMethod);
        }
        return map;
    }

    private Object updateObject(Gfsh gfsh, Class clazz, Map<String, Method> settersMap, Map<String, Method> realMap, ResultSet resultSet, String primaryColumn) throws Exception {
        if (primaryColumn != null) {
            Object obj = resultSet.getObject(primaryColumn);
            if (clazz == null || clazz == Byte.TYPE || clazz == Byte.class || clazz == Character.TYPE || clazz == Character.class || clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Date.class || clazz == String.class) {
                return obj;
            }
            Object value2 = clazz.newInstance();
            Method setterMethod = realMap.get(primaryColumn);
            if (setterMethod == null && (setterMethod = settersMap.get("set" + primaryColumn)) == null) {
                Set<Map.Entry<String, Method>> entrySet = settersMap.entrySet();
                for (Map.Entry<String, Method> entry : entrySet) {
                    String key2 = entry.getKey();
                    if (!key2.substring(3).equalsIgnoreCase(primaryColumn)) continue;
                    setterMethod = entry.getValue();
                    realMap.put(primaryColumn, settersMap.get(key2));
                }
            }
            setterMethod.invoke(value2, obj);
            return value2;
        }
        if (clazz == null || clazz == Byte.TYPE || clazz == Byte.class || clazz == Character.TYPE || clazz == Character.class || clazz == Short.TYPE || clazz == Short.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Float.TYPE || clazz == Float.class || clazz == Double.TYPE || clazz == Double.class || clazz == Date.class || clazz == String.class) {
            return resultSet.getObject(1);
        }
        Object value3 = clazz.newInstance();
        ResultSetMetaData meta = resultSet.getMetaData();
        for (int i = 1; i <= meta.getColumnCount(); ++i) {
            String columnName = meta.getColumnName(i);
            Method setterMethod = realMap.get(columnName);
            if (setterMethod == null && (setterMethod = settersMap.get("set" + columnName)) == null) {
                Set<String> keySet = settersMap.keySet();
                for (String key3 : keySet) {
                    if (!key3.substring(3).equalsIgnoreCase(columnName)) continue;
                    setterMethod = settersMap.get(key3);
                    realMap.put(columnName, settersMap.get(key3));
                }
            }
            if (setterMethod == null) continue;
            Object obj = resultSet.getObject(i);
            setterMethod.invoke(value3, obj);
        }
        return value3;
    }

    static {
        dateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss.SSS");
        smallDateFormat = new SimpleDateFormat("MM/dd/yy");
    }

    static class ColumnInfo {
        String name;
        int type;

        ColumnInfo() {
        }
    }
}

