/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.util;

import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.ReflectionUtil;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class OutputUtil {
    public static final int TYPE_KEYS = 0;
    public static final int TYPE_VALUES = 1;
    public static final int TYPE_KEYS_VALUES = 2;
    public static final String TAG_COLUMN_SEPARATOR = "#|";
    public static final String TAG_KEY = "#%key";
    public static final String TAG_DATE_FORMAT = "#%date_format";
    public static final String TAG_VALUE = "#%value";
    public static final String TAG_VALUE_KEY = "#%value_key";

    public static void printEntries(PrintWriter writer, Map map, String fieldTerminator, String rowTerminator, int firstRow, int lastRow, int printType, boolean printHeader, SimpleDateFormat dateFormat, String valueKeyFieldName) {
        if (map == null) {
            System.out.println("Error: map is null");
            return;
        }
        Set entrySet = map.entrySet();
        Object key2 = null;
        Object value2 = null;
        Method[] keyGetters = null;
        Method[] valueGetters = null;
        Iterator i$ = entrySet.iterator();
        if (i$.hasNext()) {
            Map.Entry entry = i$.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            keyGetters = ReflectionUtil.getAllGetters(key2.getClass());
            valueGetters = value2 == null ? new Method[]{} : ReflectionUtil.getAllGetters(value2.getClass());
        }
        if (value2 == null) {
            System.out.println("Error: value is null");
            return;
        }
        switch (printType) {
            case 0: {
                if (printHeader) {
                    writer.print("#%key " + key2.getClass().getName());
                    writer.print(rowTerminator);
                    writer.print("#%date_format " + dateFormat.toPattern());
                    writer.print(rowTerminator);
                    OutputUtil.printHeader(writer, key2, keyGetters, fieldTerminator, rowTerminator);
                }
                for (Map.Entry entry : entrySet) {
                    key2 = entry.getKey();
                    OutputUtil.printObject(writer, keyGetters, key2, fieldTerminator, rowTerminator, dateFormat);
                }
                break;
            }
            case 1: {
                if (printHeader) {
                    if (value2 != null) {
                        writer.print("#%value " + value2.getClass().getName());
                    }
                    writer.print(rowTerminator);
                    writer.print("#%value_key " + valueKeyFieldName);
                    writer.print(rowTerminator);
                    writer.print("#%date_format " + dateFormat.toPattern());
                    writer.print(rowTerminator);
                    OutputUtil.printHeader(writer, value2, valueGetters, fieldTerminator, rowTerminator);
                }
                for (Map.Entry entry : entrySet) {
                    value2 = entry.getValue();
                    OutputUtil.printObject(writer, valueGetters, value2, fieldTerminator, rowTerminator, dateFormat);
                }
                break;
            }
            default: {
                if (printHeader) {
                    writer.print("#%key " + key2.getClass().getName());
                    writer.print(rowTerminator);
                    if (value2 != null) {
                        writer.print("#%value " + value2.getClass().getName());
                    }
                    writer.print(rowTerminator);
                    writer.print("#%date_format " + dateFormat.toPattern());
                    writer.print(rowTerminator);
                    OutputUtil.printHeader(writer, key2, keyGetters, fieldTerminator);
                    writer.print(",");
                    OutputUtil.printHeader(writer, value2, valueGetters, fieldTerminator, rowTerminator);
                }
                for (Map.Entry entry : entrySet) {
                    key2 = entry.getKey();
                    value2 = entry.getValue();
                    OutputUtil.printObject(writer, keyGetters, key2, fieldTerminator, dateFormat);
                    writer.print(",");
                    OutputUtil.printObject(writer, valueGetters, value2, fieldTerminator, dateFormat);
                    writer.print(rowTerminator);
                }
            }
        }
    }

    private static void printHeader(PrintWriter writer, Object object, Method[] methods, String fieldTerminator, String rowTerminator) {
        OutputUtil.printHeader(writer, object, methods, fieldTerminator);
        writer.print(rowTerminator);
    }

    private static void printHeader(PrintWriter writer, Object object, Method[] methods, String fieldTerminator) {
        writer.print(TAG_COLUMN_SEPARATOR);
        if (object == null || object instanceof String || object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class || object instanceof Date) {
            writer.print("Value");
        } else {
            for (int i = 0; i < methods.length; ++i) {
                String name = methods[i].getName().substring(3);
                writer.print(name);
                if (i >= methods.length - 1) continue;
                writer.print(fieldTerminator);
            }
        }
    }

    public static void printObject(PrintWriter writer, Method[] methods, Object object, String fieldTerminator, String rowTerminator, SimpleDateFormat dateFormat) {
        OutputUtil.printObject(writer, methods, object, fieldTerminator, dateFormat);
        writer.print(rowTerminator);
    }

    private static void printObject(PrintWriter writer, Method[] methods, Object object, String fieldTerminator, SimpleDateFormat dateFormat) {
        if (object == null) {
            writer.print("null");
        } else if (object instanceof String) {
            String value2 = object.toString();
            if ((value2 = value2.replaceAll("\"", "\"\"")).indexOf("\"") != -1) {
                value2 = "\"" + value2;
                value2 = value2 + "\"";
            } else {
                if (value2.startsWith("\"")) {
                    value2 = "\"" + value2;
                }
                if (value2.endsWith("\"")) {
                    value2 = value2 + "\"";
                }
            }
            writer.print(value2);
        } else if (object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class) {
            writer.print(object.toString());
        } else if (object instanceof Date) {
            writer.print(dateFormat.format((Date)object));
        } else if (methods != null) {
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                String name = method.getName();
                try {
                    Object value3 = method.invoke(object, (Object[])null);
                    value3 = OutputUtil.getPrintableValue(value3);
                    OutputUtil.printObject(writer, null, value3, fieldTerminator, dateFormat);
                    if (i >= methods.length - 1) continue;
                    writer.print(fieldTerminator);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private static Object getPrintableValue(Object value2) {
        if (value2 instanceof Byte) {
            value2 = ((Byte)value2).toString();
        } else if (value2 instanceof byte[]) {
            value2 = "[B " + ((byte[])value2).length;
        } else if (value2 instanceof boolean[]) {
            value2 = "[Z " + ((boolean[])value2).length;
        } else if (value2 instanceof short[]) {
            value2 = "[S " + ((short[])value2).length;
        } else if (value2 instanceof int[]) {
            value2 = "[I " + ((int[])value2).length;
        } else if (value2 instanceof long[]) {
            value2 = "[J " + ((long[])value2).length;
        } else if (value2 instanceof float[]) {
            value2 = "[F " + ((float[])value2).length;
        } else if (value2 instanceof double[]) {
            value2 = "[D " + ((double[])value2).length;
        }
        return value2;
    }
}

