/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.app.util;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.SelectResults;
import com.gemstone.gemfire.cache.query.Struct;
import com.gemstone.gemfire.cache.query.types.CollectionType;
import com.gemstone.gemfire.cache.query.types.ObjectType;
import com.gemstone.gemfire.cache.query.types.StructType;
import com.gemstone.gemfire.internal.tools.gfsh.app.cache.data.Mappable;
import com.gemstone.gemfire.internal.tools.gfsh.app.misc.util.StringUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SimplePrintUtil {
    private static boolean printType = false;
    private static int collectionEntryPrintCount = 5;

    public static boolean isPrintType() {
        return printType;
    }

    public static void setPrintType(boolean printType) {
        SimplePrintUtil.printType = printType;
    }

    public static int getCollectionEntryPrintCount() {
        return collectionEntryPrintCount;
    }

    public static void setCollectionEntryPrintCount(int collectionEntryPrintCount) {
        SimplePrintUtil.collectionEntryPrintCount = collectionEntryPrintCount;
    }

    public static int printEntries(Region region, Iterator regionIterator, int startIndex, int startRowNum, int rowCount, List keyList) throws Exception {
        if (region == null || regionIterator == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        int endIndex = startIndex + rowCount;
        if (endIndex >= region.size()) {
            endIndex = region.size();
        }
        if (startIndex == endIndex) {
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        Object key2 = null;
        Object value2 = null;
        int index2 = startIndex;
        int row = startRowNum;
        Iterator itr = regionIterator;
        for (index2 = startIndex; index2 < endIndex && itr.hasNext(); ++index2) {
            Region.Entry entry = (Region.Entry)itr.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            keyNameSet.add(key2.getClass().getName());
            if (value2 != null) {
                valueNameSet.add(value2.getClass().getName());
            }
            SimplePrintUtil.printObject(row, "Key", key2, true);
            SimplePrintUtil.printObject(row, "Value", value2, false);
            System.out.println();
            ++row;
        }
        System.out.println();
        System.out.println(" Fetch size: " + rowCount);
        System.out.println("   Returned: " + (row - 1) + "/" + region.size());
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return endIndex - startIndex;
    }

    public static int printEntries(Region region, Map keyMap, List keyList) throws Exception {
        if (region == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        ArrayList indexList = new ArrayList(keyMap.keySet());
        Collections.sort(indexList);
        Object key2 = null;
        Object value2 = null;
        int row = 1;
        int rowCount = keyMap.size();
        for (Object k : indexList) {
            key2 = keyMap.get(k);
            value2 = region.get(key2);
            keyNameSet.add(key2.getClass().getName());
            if (value2 != null) {
                valueNameSet.add(value2.getClass().getName());
            }
            SimplePrintUtil.printObject(row, "Key", key2, true);
            SimplePrintUtil.printObject(row, "Value", value2, false);
            System.out.println();
            ++row;
        }
        System.out.println();
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return rowCount;
    }

    public static int printEntries(Region region, Set keySet, List keyList) throws Exception {
        if (region == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        if (keySet.size() == 0) {
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        int row = 1;
        Object key222 = null;
        Object value2 = null;
        for (Object key222 : keySet) {
            value2 = region.get(key222);
            if (keyList != null) {
                keyList.add(key222);
            }
            keyNameSet.add(key222.getClass().getName());
            if (value2 != null) {
                valueNameSet.add(value2.getClass().getName());
            }
            SimplePrintUtil.printObject(row, "Key", key222, true);
            SimplePrintUtil.printObject(row, "Value", value2, false);
            ++row;
        }
        System.out.println();
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return row - 1;
    }

    public static int printEntries(Map map, int startIndex, int startRowNum, int rowCount, int actualSize, List keyList) throws Exception {
        int count;
        if (map == null) {
            System.out.println("Error: map is null");
            return 0;
        }
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        Object key2 = null;
        Object value2 = null;
        Set entrySet = map.entrySet();
        int row = startRowNum;
        int lastRow = startRowNum + rowCount - 1;
        Iterator itr = entrySet.iterator();
        for (count = 0; count < rowCount && itr.hasNext(); ++count) {
            Map.Entry entry = itr.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            keyNameSet.add(key2.getClass().getName());
            if (value2 != null) {
                valueNameSet.add(value2.getClass().getName());
            }
            SimplePrintUtil.printObject(row, "Key", key2, true, 2);
            SimplePrintUtil.printObject(row, "Value", value2, false, 2);
            System.out.println();
            ++row;
        }
        System.out.println();
        System.out.println(" Fetch size: " + rowCount);
        System.out.println("   Returned: " + (row - 1) + "/" + actualSize);
        for (Object e : keyNameSet) {
            System.out.println("  Key Class: " + e);
        }
        for (Object e : valueNameSet) {
            System.out.println("Value Class: " + e);
        }
        return count;
    }

    public static int printEntries(Map map, int rowCount, List keyList, boolean displaySummary, boolean showValues) throws Exception {
        return SimplePrintUtil.printEntries(map, rowCount, keyList, "Key", "Value", displaySummary, showValues);
    }

    public static int printEntries(Map map, int rowCount, List keyList, String keyColumnName, String valueColumnName, boolean displaySummary, boolean showValues) throws Exception {
        if (map == null) {
            System.out.println("Error: Region is null");
            return 0;
        }
        if (map.size() == 0) {
            return 0;
        }
        int row = 1;
        Object key2 = null;
        Object value2 = null;
        HashSet<String> keyNameSet = new HashSet<String>();
        HashSet<String> valueNameSet = new HashSet<String>();
        Set nameSet = map.entrySet();
        Iterator itr = nameSet.iterator();
        for (int count = 0; count < rowCount && itr.hasNext(); ++count) {
            Map.Entry entry = itr.next();
            key2 = entry.getKey();
            value2 = entry.getValue();
            if (keyList != null) {
                keyList.add(key2);
            }
            keyNameSet.add(key2.getClass().getName());
            if (value2 != null) {
                valueNameSet.add(value2.getClass().getName());
            }
            SimplePrintUtil.printObject(row, keyColumnName, key2, true, 2);
            if (showValues) {
                SimplePrintUtil.printObject(row, valueColumnName, value2, false, 2);
            }
            System.out.println();
            ++row;
        }
        if (displaySummary) {
            System.out.println();
            System.out.println("Displayed (fetched): " + (row - 1));
            System.out.println("        Actual Size: " + map.size());
            for (Object e : keyNameSet) {
                System.out.println("          " + keyColumnName + " Class: " + e);
            }
            for (Object e : valueNameSet) {
                System.out.println("        " + valueColumnName + " Class: " + e);
            }
        }
        return row - 1;
    }

    public static int printSet(Set set, int rowCount, List keyList, String keyColumnName, boolean displaySummary) throws Exception {
        if (set == null) {
            return 0;
        }
        if (set.size() == 0) {
            return 0;
        }
        int row = 1;
        Object key2 = null;
        HashSet<String> keyNameSet = new HashSet<String>();
        Set nameSet = set;
        Iterator itr = nameSet.iterator();
        for (int count = 0; count < rowCount && itr.hasNext(); ++count) {
            key2 = itr.next();
            if (keyList != null) {
                keyList.add(key2);
            }
            keyNameSet.add(key2.getClass().getName());
            SimplePrintUtil.printObject(row, keyColumnName, key2, true, 2);
            System.out.println();
            ++row;
        }
        if (displaySummary) {
            System.out.println();
            System.out.println("Displayed (fetched): " + (row - 1));
            System.out.println("        Actual Size: " + set.size());
            for (Object e : keyNameSet) {
                System.out.println("          " + keyColumnName + " Class: " + e);
            }
        }
        return row - 1;
    }

    private static void printTopHeaders(List list, Object obj, boolean printLastColumnSpaces, String primitiveHeader) {
        Object object = obj;
        if (object == null) {
            object = "null";
        }
        if (object instanceof String || object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class || object.getClass().isArray() || object instanceof Date) {
            int maxLen = (Integer)list.get(0);
            if (maxLen < primitiveHeader.length()) {
                maxLen = primitiveHeader.length();
            }
            if (printLastColumnSpaces) {
                System.out.print(StringUtil.getRightPaddedString(primitiveHeader, maxLen, ' '));
            } else {
                System.out.print(primitiveHeader);
            }
        } else {
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            int listIndex = 0;
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value2 = method.invoke(object, (Object[])null);
                    value2 = SimplePrintUtil.getPrintableValue(value2);
                    int maxLen = (Integer)list.get(listIndex);
                    String header = name.substring(3);
                    if (listIndex == list.size() - 1) {
                        if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                        } else {
                            System.out.print(header);
                        }
                    } else {
                        System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                        System.out.print("  ");
                    }
                    ++listIndex;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private static void printBottomHeaders(List list, Object obj, boolean printLastColumnSpaces, String primitiveHeader) {
        Object object = obj;
        if (object == null) {
            object = "null";
        }
        if (object instanceof String || object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class || object.getClass().isArray() || object instanceof Date) {
            int maxLen = (Integer)list.get(0);
            if (maxLen < primitiveHeader.length()) {
                maxLen = primitiveHeader.length();
            }
            if (printLastColumnSpaces) {
                System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", primitiveHeader.length(), '-'), maxLen, ' '));
            } else {
                System.out.print(StringUtil.getRightPaddedString("", primitiveHeader.length(), '-'));
            }
        } else {
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            int listIndex = 0;
            listIndex = 0;
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value2 = method.invoke(object, (Object[])null);
                    value2 = SimplePrintUtil.getPrintableValue(value2);
                    int maxLen = (Integer)list.get(listIndex);
                    String header = name.substring(3);
                    if (listIndex == list.size() - 1) {
                        if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                        } else {
                            System.out.print(StringUtil.getRightPaddedString("", header.length(), '-'));
                        }
                    } else {
                        System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                        System.out.print("  ");
                    }
                    ++listIndex;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public static int printSelectResults(SelectResults sr, int startIndex, int startRowNum, int rowCount) {
        if (sr == null) {
            System.out.println("Error: SelectResults is null");
            return 0;
        }
        int endIndex = startIndex + rowCount;
        if (endIndex >= sr.size()) {
            endIndex = sr.size();
        }
        if (startIndex >= endIndex) {
            return 0;
        }
        CollectionType type = sr.getCollectionType();
        ObjectType elementType = type.getElementType();
        int row = 1;
        if (rowCount == -1) {
            rowCount = sr.size();
        }
        HashSet elementNameSet = new HashSet();
        Object element = null;
        boolean isStructType = false;
        StructType structType = null;
        Struct struct = null;
        List srList = sr.asList();
        row = startRowNum;
        for (int i = startIndex; i < endIndex; ++i) {
            element = srList.get(i);
            if (elementType.isStructType()) {
                structType = (StructType)elementType;
                struct = element;
                SimplePrintUtil.printStruct(row, structType, struct, 0);
                System.out.println();
            } else {
                System.out.println(row + ". " + SimplePrintUtil.getPrintableType(element));
                SimplePrintUtil.printObject(null, element, 1);
                System.out.println();
            }
            ++row;
        }
        System.out.println();
        for (Object elementClassName : elementNameSet) {
            System.out.println("Class: " + elementClassName);
        }
        return endIndex - startIndex;
    }

    private static int printSelectResults_iterator(SelectResults sr, int startRowNum, int rowCount) {
        if (sr == null) {
            System.out.println("SelectResults is null");
            return 0;
        }
        CollectionType type = sr.getCollectionType();
        ObjectType elementType = type.getElementType();
        int row = 1;
        if (rowCount == -1) {
            rowCount = sr.size();
        }
        HashSet<String> elementNameSet = new HashSet<String>();
        ArrayList maxLenList = new ArrayList();
        Object element = null;
        boolean isStructType = false;
        StructType structType = null;
        Struct struct = null;
        Iterator iter = sr.iterator();
        while (iter.hasNext() && row <= rowCount) {
            element = iter.next();
            if (elementType.isStructType()) {
                structType = (StructType)elementType;
                struct = (Struct)element;
                SimplePrintUtil.computeMaxLengths(maxLenList, structType, struct);
                isStructType = true;
            } else {
                SimplePrintUtil.computeMaxLengths(maxLenList, element, false);
                elementNameSet.add(element.getClass().getName());
            }
            ++row;
        }
        if (element == null && struct == null) {
            return 0;
        }
        int rowMax = String.valueOf(startRowNum + rowCount - 1).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        if (isStructType) {
            SimplePrintUtil.printHeaders(maxLenList, structType, struct, rowMax);
        } else {
            SimplePrintUtil.printHeaders(maxLenList, element, rowMax);
        }
        int lastRow = startRowNum + rowCount - 1;
        Iterator iter2 = sr.iterator();
        for (row = startRowNum; iter2.hasNext() && row <= lastRow; ++row) {
            element = iter2.next();
            if (elementType.isStructType()) {
                structType = (StructType)elementType;
                struct = (Struct)element;
                System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
                System.out.print("  ");
                System.out.println();
                continue;
            }
            System.out.print(StringUtil.getRightPaddedString(row + "", rowMax, ' '));
            System.out.print("  ");
            SimplePrintUtil.printObject(maxLenList, element, false);
            System.out.println();
        }
        System.out.println();
        for (Object e : elementNameSet) {
            System.out.println("Class: " + e);
        }
        return row - 1;
    }

    private static void computeMaxLengths(List list, StructType structType, Struct struct) {
        ObjectType[] fieldTypes = structType.getFieldTypes();
        String[] fieldNames = structType.getFieldNames();
        Object[] fieldValues = struct.getFieldValues();
        int listIndex = 0;
        for (int i = 0; i < fieldTypes.length; ++i) {
            Integer len;
            ObjectType fieldType = fieldTypes[i];
            String fieldName = fieldNames[i];
            Object fieldValue = fieldValues[i];
            if (listIndex >= list.size()) {
                len = fieldName.length();
                list.add(len);
            } else {
                len = (Integer)list.get(listIndex);
            }
            if (fieldValue == null) {
                if (len < 4) {
                    len = 4;
                }
            } else {
                int valueLen = fieldValue.toString().length();
                if (len < valueLen) {
                    len = valueLen;
                }
            }
            list.set(listIndex, len);
            ++listIndex;
        }
    }

    private static void computeMaxLengths(List list, Object obj, boolean isKey) {
        Object object = obj;
        if (object == null) {
            object = "null";
        }
        if (object instanceof String || object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class || object.getClass().isArray() || object instanceof Date) {
            if (list.size() > 0) {
                int len = (Integer)list.get(0);
                if (len < object.toString().length()) {
                    list.set(0, object.toString().length());
                }
            } else if (isKey) {
                if (object.toString().length() < 3) {
                    list.add(3);
                } else {
                    list.add(object.toString().length());
                }
            } else if (object.toString().length() < 5) {
                list.add(5);
            } else {
                list.add(object.toString().length());
            }
        } else {
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            int listIndex = 0;
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Integer len;
                    Object value2 = method.invoke(object, (Object[])null);
                    value2 = SimplePrintUtil.getPrintableValue(value2);
                    if (listIndex >= list.size()) {
                        len = name.length() - 3;
                        list.add(len);
                    } else {
                        len = (Integer)list.get(listIndex);
                    }
                    if (value2 == null) {
                        if (len < 4) {
                            len = 4;
                        }
                    } else {
                        int valueLen = value2.toString().length();
                        if (len < valueLen) {
                            len = valueLen;
                        }
                    }
                    list.set(listIndex, len);
                    ++listIndex;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    private static void printHeaders(List list, StructType structType, Struct struct, int rowMaxLen) {
        String header;
        int maxLen;
        Object fieldValue;
        String fieldName;
        ObjectType fieldType;
        int i;
        System.out.print(StringUtil.getRightPaddedString("Row", rowMaxLen, ' '));
        System.out.print("  ");
        ObjectType[] fieldTypes = structType.getFieldTypes();
        String[] fieldNames = structType.getFieldNames();
        Object[] fieldValues = struct.getFieldValues();
        int listIndex = 0;
        for (i = 0; i < fieldTypes.length; ++i) {
            fieldType = fieldTypes[i];
            fieldName = fieldNames[i];
            fieldValue = fieldValues[i];
            fieldValue = SimplePrintUtil.getPrintableValue(fieldValue);
            maxLen = (Integer)list.get(listIndex);
            header = fieldName;
            System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
            System.out.print("  ");
            ++listIndex;
        }
        System.out.println();
        System.out.print(StringUtil.getRightPaddedString("", rowMaxLen, '-'));
        System.out.print("  ");
        listIndex = 0;
        for (i = 0; i < fieldTypes.length; ++i) {
            fieldType = fieldTypes[i];
            fieldName = fieldNames[i];
            fieldValue = fieldValues[i];
            fieldValue = SimplePrintUtil.getPrintableValue(fieldValue);
            maxLen = (Integer)list.get(listIndex);
            header = fieldName;
            System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
            System.out.print("  ");
            ++listIndex;
        }
        System.out.println();
    }

    private static void printHeaders(List list, Object object, int rowMaxLen) {
        System.out.print(StringUtil.getRightPaddedString("Row", rowMaxLen, ' '));
        System.out.print("  ");
        SimplePrintUtil.printTopHeaders(list, object, false, "Value");
        System.out.println();
        System.out.print(StringUtil.getRightPaddedString("", rowMaxLen, '-'));
        System.out.print("  ");
        SimplePrintUtil.printBottomHeaders(list, object, false, "Value");
        System.out.println();
    }

    private static String getPrintableType(Object object) {
        if (SimplePrintUtil.isPrintType()) {
            if (object == null) {
                return " (N/A)";
            }
            return " (" + object.getClass().getSimpleName() + ")";
        }
        return "";
    }

    private static void printStruct(int row, StructType structType, Struct struct, int level) {
        String spaces = SimplePrintUtil.getSpaces(level);
        String spaces2 = SimplePrintUtil.getSpaces(level + 1);
        ObjectType[] fieldTypes = structType.getFieldTypes();
        String[] fieldNames = structType.getFieldNames();
        Object[] fieldValues = struct.getFieldValues();
        boolean listIndex = false;
        System.out.println(spaces + row + ".");
        for (int i = 0; i < fieldTypes.length; ++i) {
            ObjectType fieldType = fieldTypes[i];
            String fieldName = fieldNames[i];
            Object fieldValue = fieldValues[i];
            SimplePrintUtil.printObject(fieldName, fieldValue, level + 1);
        }
    }

    private static void printObject(int row, String header, Object object, boolean printRow) {
        SimplePrintUtil.printObject(row, header, object, printRow, 1);
    }

    private static void printObject(int row, String header, Object object, boolean printRow, int level) {
        if (printRow) {
            System.out.print(row + ". ");
        } else {
            String rowStr = Integer.toString(row);
            String spaces = "";
            for (int i = 0; i < rowStr.length(); ++i) {
                spaces = spaces + " ";
            }
            System.out.print(spaces + "  ");
        }
        if (header == null) {
            System.out.print(SimplePrintUtil.getPrintableType(object));
        } else {
            System.out.print(header + SimplePrintUtil.getPrintableType(object));
        }
        System.out.println();
        SimplePrintUtil.printObject(null, object, level);
    }

    private static void printObject(String name, Object obj, int level) {
        String spaces = SimplePrintUtil.getSpaces(level);
        Object object = obj;
        if (object == null) {
            object = "null";
        }
        if (object instanceof String || object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class || object.getClass().isArray() || object instanceof Date) {
            SimplePrintUtil.printValue(name, object, level);
        } else if (object instanceof Map) {
            SimplePrintUtil.printMap(name, (Map)object, level);
        } else if (object instanceof Collection) {
            SimplePrintUtil.printCollection(name, (Collection)object, level);
        } else if (object instanceof Mappable) {
            SimplePrintUtil.printMappable(name, (Mappable)object, level);
        } else {
            Method method;
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            boolean listIndex = false;
            ArrayList<String> methodList = new ArrayList<String>();
            HashMap<String, Method> methodMap = new HashMap<String, Method>();
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                method = methods[i];
                name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                String propertyName = name.substring(3);
                methodMap.put(propertyName, method);
                methodList.add(propertyName);
            }
            Collections.sort(methodList);
            for (String propertyName : methodList) {
                try {
                    method = (Method)methodMap.get(propertyName);
                    Object value2 = method.invoke(object, (Object[])null);
                    SimplePrintUtil.printObject(propertyName, value2, level);
                }
                catch (Exception ex) {}
            }
        }
    }

    public static void printList(List resultList) {
        ArrayList maxLenList = new ArrayList();
        Object nonNullObject = null;
        for (int i = 0; i < resultList.size(); ++i) {
            Object object = resultList.get(i);
            if (object != null) {
                nonNullObject = object;
            }
            SimplePrintUtil.computeMaxLengths(maxLenList, object, true);
        }
        if (nonNullObject == null) {
            return;
        }
        int rowMax = String.valueOf(resultList.size()).length();
        if (rowMax < 3) {
            rowMax = 3;
        }
        SimplePrintUtil.printHeaders(maxLenList, nonNullObject, rowMax);
        for (int i = 0; i < resultList.size(); ++i) {
            Object object = resultList.get(i);
            System.out.print(StringUtil.getRightPaddedString(i + 1 + "", rowMax, ' '));
            System.out.print("  ");
            SimplePrintUtil.printObject(maxLenList, object, false);
            System.out.println();
        }
    }

    public static int printList(List list, int startIndex, int startRowNum, int rowCount, int actualSize, List keyList) throws Exception {
        int count;
        if (list == null) {
            System.out.println("Error: map is null");
            return 0;
        }
        HashSet<String> objectNameSet = new HashSet<String>();
        Object object = null;
        int row = startRowNum;
        int lastRow = startRowNum + rowCount - 1;
        Iterator itr = list.iterator();
        for (count = 0; count < rowCount && itr.hasNext(); ++count) {
            object = itr.next();
            objectNameSet.add(object.getClass().getName());
            SimplePrintUtil.printObject(row, "Object", object, true, 2);
            System.out.println();
            ++row;
        }
        System.out.println();
        System.out.println(" Fetch size: " + rowCount);
        System.out.println("   Returned: " + (row - 1) + "/" + actualSize);
        for (Object e : objectNameSet) {
            System.out.println("      Class: " + e);
        }
        return count;
    }

    private static void computeMappableMaxLengths(List list, Mappable mappable) {
        int listIndex = 0;
        ArrayList keyList = new ArrayList(mappable.getKeys());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            Integer len;
            String name = (String)keyList.get(i);
            Object value2 = mappable.getValue(name);
            value2 = SimplePrintUtil.getPrintableValue(value2);
            if (listIndex >= list.size()) {
                len = name.length();
                list.add(len);
            } else {
                len = (Integer)list.get(listIndex);
            }
            if (value2 == null) {
                if (len < 4) {
                    len = 4;
                }
            } else {
                int valueLen = value2.toString().length();
                if (len < valueLen) {
                    len = valueLen;
                }
            }
            list.set(listIndex, len);
            ++listIndex;
        }
    }

    private static void printMappableHeaders(List list, Mappable mappable, int rowMaxLen) {
        System.out.print(StringUtil.getRightPaddedString("Row", rowMaxLen, ' '));
        System.out.print("  ");
        SimplePrintUtil.printMappableTopHeaders(list, mappable, false);
        System.out.println();
        if (rowMaxLen < 3) {
            rowMaxLen = 3;
        }
        System.out.print(StringUtil.getRightPaddedString("", rowMaxLen, '-'));
        System.out.print("  ");
        SimplePrintUtil.printMappableBottomHeaders(list, mappable, false);
        System.out.println();
    }

    private static void printMappableTopHeaders(List list, Mappable mappable, boolean printLastColumnSpaces) {
        int listIndex = 0;
        ArrayList keyList = new ArrayList(mappable.getKeys());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String header = (String)keyList.get(i);
            int maxLen = (Integer)list.get(listIndex);
            if (listIndex == list.size() - 1) {
                if (printLastColumnSpaces) {
                    System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                } else {
                    System.out.print(header);
                }
            } else {
                System.out.print(StringUtil.getRightPaddedString(header, maxLen, ' '));
                System.out.print("  ");
            }
            ++listIndex;
        }
    }

    private static void printMappableBottomHeaders(List list, Mappable mappable, boolean printLastColumnSpaces) {
        int listIndex = 0;
        ArrayList keyList = new ArrayList(mappable.getKeys());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String header = (String)keyList.get(i);
            int maxLen = (Integer)list.get(listIndex);
            if (listIndex == list.size() - 1) {
                if (printLastColumnSpaces) {
                    System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                } else {
                    System.out.print(StringUtil.getRightPaddedString("", header.length(), '-'));
                }
            } else {
                System.out.print(StringUtil.getRightPaddedString(StringUtil.getRightPaddedString("", header.length(), '-'), maxLen, ' '));
                System.out.print("  ");
            }
            ++listIndex;
        }
    }

    private static void printMappable(String name, Mappable mappable, int level) {
        String spaces = SimplePrintUtil.getSpaces(level);
        boolean listIndex = false;
        ArrayList keyList = new ArrayList(mappable.getKeys());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            String n = (String)keyList.get(i);
            Object value2 = mappable.getValue(n);
            SimplePrintUtil.printObject(n, value2, level);
        }
    }

    public static void printMappableList(List<Mappable> resultList) {
        for (int i = 0; i < resultList.size(); ++i) {
            Mappable mappable = resultList.get(i);
            SimplePrintUtil.printObject(i + 1, null, mappable, true);
            System.out.println();
        }
    }

    private static Object getPrintableValue(Object value2) {
        if (value2 instanceof Byte) {
            value2 = ((Byte)value2).toString();
        } else if (value2 instanceof byte[]) {
            value2 = "[B " + ((byte[])value2).length;
        } else if (value2 instanceof boolean[]) {
            value2 = "[Z " + ((boolean[])value2).length;
        } else if (value2 instanceof short[]) {
            value2 = "[S " + ((short[])value2).length;
        } else if (value2 instanceof int[]) {
            value2 = "[I " + ((int[])value2).length;
        } else if (value2 instanceof long[]) {
            value2 = "[J " + ((long[])value2).length;
        } else if (value2 instanceof float[]) {
            value2 = "[F " + ((float[])value2).length;
        } else if (value2 instanceof double[]) {
            value2 = "[D " + ((double[])value2).length;
        }
        return value2;
    }

    private static void printValue(Object name, Object value2, int level) {
        String spaces = SimplePrintUtil.getSpaces(level);
        Object printableValue = value2;
        if (value2 instanceof Byte) {
            printableValue = ((Byte)value2).toString();
        } else if (value2 instanceof byte[]) {
            printableValue = "[B " + ((byte[])value2).length;
        } else if (value2 instanceof boolean[]) {
            printableValue = "[Z " + ((boolean[])value2).length;
        } else if (value2 instanceof short[]) {
            printableValue = "[S " + ((short[])value2).length;
        } else if (value2 instanceof int[]) {
            printableValue = "[I " + ((int[])value2).length;
        } else if (value2 instanceof long[]) {
            printableValue = "[J " + ((long[])value2).length;
        } else if (value2 instanceof float[]) {
            printableValue = "[F " + ((float[])value2).length;
        } else if (value2 instanceof double[]) {
            printableValue = "[D " + ((double[])value2).length;
        }
        if (value2 instanceof Map) {
            SimplePrintUtil.printMap(name, (Map)value2, level);
        } else if (name == null) {
            System.out.println(spaces + printableValue + SimplePrintUtil.getPrintableType(value2));
        } else if (name.toString().startsWith("[")) {
            System.out.println(spaces + name + " " + printableValue + SimplePrintUtil.getPrintableType(value2));
        } else {
            System.out.println(spaces + name + " = " + printableValue + SimplePrintUtil.getPrintableType(value2));
        }
    }

    private static void printMap(Object name, Map map, int level) {
        String spaces = SimplePrintUtil.getSpaces(level);
        String spaces2 = SimplePrintUtil.getSpaces(level + 1);
        if (name == null) {
            System.out.println(spaces + "size: " + map.size() + SimplePrintUtil.getPrintableType(map));
        } else {
            System.out.println(spaces + name + " - size: " + map.size() + SimplePrintUtil.getPrintableType(map));
        }
        Set entrySet = map.entrySet();
        int count = 0;
        for (Map.Entry entry : entrySet) {
            Object key2 = entry.getKey();
            Object value2 = entry.getValue();
            if (key2 instanceof Map) {
                SimplePrintUtil.printMap(null, (Map)key2, level + 1);
            } else {
                if (SimplePrintUtil.isPrintType()) {
                    if (value2 == null) {
                        System.out.println(spaces2 + key2 + " (" + key2.getClass().getSimpleName() + ", N/A");
                    } else {
                        System.out.println(spaces2 + key2 + " (" + key2.getClass().getSimpleName() + ", " + value2.getClass().getSimpleName() + ")");
                    }
                } else {
                    System.out.println(spaces2 + key2);
                }
                SimplePrintUtil.printObject(key2.toString(), value2, level + 2);
            }
            if (++count < SimplePrintUtil.getCollectionEntryPrintCount()) continue;
            break;
        }
        if (count < entrySet.size()) {
            System.out.println(spaces2 + "<" + (entrySet.size() - count) + " more ...>");
        }
    }

    private static void printCollection(Object name, Collection col, int level) {
        String spaces = SimplePrintUtil.getSpaces(level);
        String spaces2 = SimplePrintUtil.getSpaces(level + 1);
        if (name == null) {
            System.out.println(spaces + "size: " + col.size() + SimplePrintUtil.getPrintableType(col));
        } else {
            System.out.println(spaces + name + " - size: " + col.size() + SimplePrintUtil.getPrintableType(col));
        }
        int count = 0;
        for (Object value2 : col) {
            if (col instanceof Map) {
                SimplePrintUtil.printMap(null, (Map)value2, level + 1);
            } else if (value2 instanceof Collection) {
                SimplePrintUtil.printCollection(null, (Collection)value2, level + 1);
            } else {
                SimplePrintUtil.printObject("[" + count + "]", value2, level + 1);
            }
            if (++count < SimplePrintUtil.getCollectionEntryPrintCount()) continue;
            break;
        }
        if (count < col.size()) {
            System.out.println(spaces2 + "<" + (col.size() - count) + " more ...>");
        }
    }

    private static String getSpaces(int level) {
        String spaces = "";
        for (int i = 0; i < level; ++i) {
            spaces = spaces + "   ";
        }
        return spaces;
    }

    private static void printObject(List list, Object obj, boolean printLastColumnSpaces) {
        Object object = obj;
        if (object == null) {
            object = "null";
        }
        if (object instanceof String || object.getClass().isPrimitive() || object.getClass() == Boolean.class || object.getClass() == Byte.class || object.getClass() == Character.class || object.getClass() == Short.class || object.getClass() == Integer.class || object.getClass() == Long.class || object.getClass() == Float.class || object.getClass() == Double.class || object.getClass().isArray() || object instanceof Date) {
            object = SimplePrintUtil.getPrintableValue(object);
            if (list.size() > 0) {
                int maxLen = (Integer)list.get(0);
                if (printLastColumnSpaces) {
                    System.out.print(StringUtil.getRightPaddedString(object.toString(), maxLen, ' '));
                } else {
                    System.out.print(object.toString());
                }
            } else {
                System.out.print(object.toString());
            }
        } else {
            Class<?> cls = object.getClass();
            Method[] methods = cls.getMethods();
            int listIndex = 0;
            for (int i = 0; i < methods.length; ++i) {
                Class<?> retType;
                Method method = methods[i];
                String name = method.getName();
                if (name.length() <= 3 || !name.startsWith("get") || name.equals("getClass") || (retType = method.getReturnType()) == Void.TYPE) continue;
                try {
                    Object value2 = method.invoke(object, (Object[])null);
                    value2 = SimplePrintUtil.getPrintableValue(value2);
                    int maxLen = (Integer)list.get(listIndex);
                    if (listIndex == list.size() - 1) {
                        if (value2 == null) {
                            if (printLastColumnSpaces) {
                                System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                            } else {
                                System.out.print("null");
                            }
                        } else if (printLastColumnSpaces) {
                            System.out.print(StringUtil.getRightPaddedString(value2.toString(), maxLen, ' '));
                        } else {
                            System.out.print(value2.toString());
                        }
                    } else {
                        if (value2 == null) {
                            System.out.print(StringUtil.getRightPaddedString("null", maxLen, ' '));
                        } else {
                            System.out.print(StringUtil.getRightPaddedString(value2.toString(), maxLen, ' '));
                        }
                        System.out.print("  ");
                    }
                    ++listIndex;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }
}

