/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.tools.gfsh.util;

import com.gemstone.gemfire.admin.AdminDistributedSystem;
import com.gemstone.gemfire.admin.AdminDistributedSystemFactory;
import com.gemstone.gemfire.admin.AdminException;
import com.gemstone.gemfire.admin.CacheVm;
import com.gemstone.gemfire.admin.DistributedSystemConfig;
import com.gemstone.gemfire.admin.SystemMember;
import com.gemstone.gemfire.admin.SystemMemberCache;
import com.gemstone.gemfire.admin.SystemMemberRegion;
import com.gemstone.gemfire.admin.internal.AdminDistributedSystemImpl;
import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.MirrorType;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.cache.client.Pool;
import com.gemstone.gemfire.cache.util.BridgeClient;
import com.gemstone.gemfire.cache.util.BridgeLoader;
import com.gemstone.gemfire.cache.util.BridgeWriter;
import com.gemstone.gemfire.distributed.DistributedSystem;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class RegionUtil {
    public static Region createRegion(Region parentRegion, String regionName, Scope scope, DataPolicy dataPolicy, CacheListener listener) throws CacheException {
        return RegionUtil.createRegion(parentRegion, regionName, scope, dataPolicy, listener, null, null);
    }

    public static Region createRegion(Region parentRegion, String regionName, Scope scope, DataPolicy dataPolicy, CacheListener listener, File[] persistenceDirs, EvictionAttributes evictionAttributes) throws CacheException {
        return RegionUtil.createRegion(parentRegion, regionName, scope, dataPolicy, listener, persistenceDirs, evictionAttributes, null);
    }

    public static Region createRegion(Region parentRegion, String regionName, Scope scope, DataPolicy dataPolicy, CacheListener listener, File[] persistenceDirs, EvictionAttributes evictionAttributes, String endpoints) throws CacheException {
        Region region = parentRegion.getSubregion(regionName);
        if (region != null) {
            return region;
        }
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        factory.setDataPolicy(dataPolicy);
        if (listener != null) {
            factory.addCacheListener(listener);
        }
        if (persistenceDirs != null) {
            factory.setDiskDirs(persistenceDirs);
        }
        factory.setEvictionAttributes(evictionAttributes);
        if (endpoints != null) {
            BridgeWriter bridgeWriter = new BridgeWriter();
            Properties prop = new Properties();
            prop.setProperty("endpoints", endpoints);
            prop.setProperty("establishCallbackConnection", "true");
            bridgeWriter.init(prop);
            factory.setCacheWriter(bridgeWriter);
            BridgeLoader bridgeLoader = new BridgeLoader();
            prop = new Properties();
            prop.setProperty("endpoints", endpoints);
            bridgeLoader.init(prop);
            factory.setCacheLoader(bridgeLoader);
        }
        RegionAttributes attr = factory.create();
        return parentRegion.createSubregion(regionName, attr);
    }

    public static Region createVMRegion(Cache cache, String regionName, Scope scope, DataPolicy dataPolicy, CacheListener listener) throws CacheException {
        AttributesFactory factory = new AttributesFactory();
        factory.setScope(scope);
        factory.setDataPolicy(dataPolicy);
        if (listener != null) {
            factory.addCacheListener(listener);
        }
        RegionAttributes attr = factory.create();
        return cache.createRegion(regionName, attr);
    }

    public static Region getParentRegion(String regionPath) {
        if (regionPath == null) {
            return null;
        }
        Cache cache = CacheFactory.getAnyInstance();
        String[] split = regionPath.startsWith("/") ? regionPath.substring(1).split("/") : regionPath.split("/");
        if (split.length == 0) {
            return null;
        }
        Region<Object, Object> region = cache.getRegion(split[0]);
        if (region != null) {
            Region subregion;
            int i;
            for (i = 1; i < split.length && (subregion = region.getSubregion(split[i])) != null; ++i) {
                region = subregion;
            }
            if (i != split.length - 1) {
                region = null;
            }
        }
        return region;
    }

    public static Region getLastRegionInPath(String regionPath) {
        if (regionPath == null) {
            return null;
        }
        Cache cache = CacheFactory.getAnyInstance();
        String[] split = regionPath.split("/");
        if (split.length == 0) {
            return null;
        }
        Region<Object, Object> region = cache.getRegion(split[0]);
        if (region != null) {
            Region subregion;
            for (int i = 1; i < split.length && (subregion = region.getSubregion(split[i])) != null; ++i) {
                region = subregion;
            }
        }
        return region;
    }

    public static Region getRegion(String regionPath, Scope scope, MirrorType mirrorType, String endpoints) {
        DataPolicy dataPolicy = mirrorType == MirrorType.KEYS || mirrorType == MirrorType.KEYS_VALUES ? DataPolicy.REPLICATE : (mirrorType == MirrorType.NONE ? DataPolicy.NORMAL : DataPolicy.DEFAULT);
        return RegionUtil.getRegion(regionPath, scope, dataPolicy, endpoints);
    }

    public static Region getRegion(String regionPath, Scope scope, DataPolicy dataPolicy, String endpoints) throws CacheException {
        return RegionUtil.getRegion(regionPath, scope, dataPolicy, endpoints, false, null);
    }

    public static Region getRegion(String regionPath, Scope scope, DataPolicy dataPolicy, String endpoints, boolean enableBridgeConflation) throws CacheException {
        return RegionUtil.getRegion(regionPath, scope, dataPolicy, endpoints, enableBridgeConflation, null);
    }

    public static Region getRegion(String regionPath, Scope scope, DataPolicy dataPolicy, String endpoints, boolean enableBridgeConflation, String diskDir) throws CacheException {
        Cache cache = null;
        Region<Object, Object> region = null;
        try {
            cache = CacheFactory.getAnyInstance();
            region = cache.getRegion(regionPath);
            if (region != null) {
                return region;
            }
        }
        catch (CacheClosedException ex) {
            Properties props = new Properties();
            DistributedSystem system = DistributedSystem.connect(props);
            cache = CacheFactory.create(system);
        }
        StringTokenizer st = new StringTokenizer(regionPath, "/");
        int index2 = 0;
        int count = st.countTokens();
        AttributesFactory factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.NORMAL);
        while (st.hasMoreTokens()) {
            String regionName = st.nextToken();
            if (++index2 == count) {
                factory.setDataPolicy(dataPolicy);
                if (endpoints != null) {
                    String establishCallbackConnection = System.getProperty("establishCallbackConnection", "true");
                    Long readTimeout = Long.getLong("readTimeout", 10000L);
                    Integer allowableServerTimeouts = Integer.getInteger("allowableServerTimeouts", 7);
                    Long allowableServerTimeoutPeriod = Long.getLong("allowableServerTimeoutPeriod ", 10000L);
                    Integer retryAttempts = Integer.getInteger("retryAttempts", 5);
                    Long retryInterval = Long.getLong("retryInterval", 10000L);
                    String lbPolicy = System.getProperty("LBPolicy", "Sticky");
                    Integer connectionsPerServer = Integer.getInteger("connectionsPerServer", 2);
                    Integer socketBufferSize = Integer.getInteger("socketBufferSize ", 32768);
                    BridgeClient bridgeClient = new BridgeClient();
                    Properties prop = new Properties();
                    prop.setProperty("endpoints", endpoints);
                    prop.setProperty("establishCallbackConnection", establishCallbackConnection);
                    prop.setProperty("readTimeout", readTimeout.toString());
                    prop.setProperty("allowableServerTimeouts", allowableServerTimeouts.toString());
                    prop.setProperty("allowableServerTimeoutPeriod ", allowableServerTimeoutPeriod.toString());
                    prop.setProperty("retryAttempts", retryAttempts.toString());
                    prop.setProperty("retryInterval", retryInterval.toString());
                    prop.setProperty("LBPolicy", lbPolicy);
                    prop.setProperty("connectionsPerServer", connectionsPerServer.toString());
                    prop.setProperty("socketBufferSize", socketBufferSize.toString());
                    bridgeClient.init(prop);
                    factory.setCacheLoader(bridgeClient);
                } else {
                    factory.setEnableBridgeConflation(enableBridgeConflation);
                    factory.setEnableAsyncConflation(enableBridgeConflation);
                }
            }
            if (index2 == 1) {
                region = cache.getRegion(regionName);
                if (region != null) continue;
                factory.setScope(scope);
                if (diskDir != null) {
                    File[] dirs = new File[]{new File(diskDir)};
                    factory.setDiskDirs(dirs);
                }
                region = cache.createRegion(regionName, factory.create());
                continue;
            }
            Region<Object, Object> subregion = region.getSubregion(regionName);
            if (subregion == null) {
                factory.setScope(scope);
                if (diskDir != null) {
                    File[] dirs = new File[]{new File(diskDir)};
                    factory.setDiskDirs(dirs);
                }
                subregion = region.createSubregion(regionName, factory.create());
            }
            region = subregion;
        }
        return region;
    }

    public static Region getRegion(String regionPath, DataPolicy dataPolicy) throws CacheException {
        return RegionUtil.getRegion(regionPath, Scope.DISTRIBUTED_NO_ACK, dataPolicy, null);
    }

    public static Region getRegion(String regionPath) throws CacheException {
        return RegionUtil.getRegion(regionPath, Scope.DISTRIBUTED_NO_ACK, DataPolicy.NORMAL, null);
    }

    public static Region getRegion(String regionPath, Scope scope, DataPolicy dataPolicy, Pool pool, boolean enableBridgeConflation) throws CacheException {
        Cache cache = null;
        Region<Object, Object> region = null;
        try {
            cache = CacheFactory.getAnyInstance();
            region = cache.getRegion(regionPath);
            if (region != null) {
                return region;
            }
        }
        catch (CacheClosedException ex) {
            Properties props = new Properties();
            DistributedSystem system = DistributedSystem.connect(props);
            cache = CacheFactory.create(system);
        }
        StringTokenizer st = new StringTokenizer(regionPath, "/");
        int index2 = 0;
        int count = st.countTokens();
        AttributesFactory factory = new AttributesFactory();
        factory.setDataPolicy(DataPolicy.NORMAL);
        while (st.hasMoreTokens()) {
            String regionName = st.nextToken();
            if (++index2 == count) {
                factory.setDataPolicy(dataPolicy);
                factory.setPoolName(pool.getName());
            }
            if (index2 == 1) {
                region = cache.getRegion(regionName);
                if (region != null) continue;
                factory.setScope(scope);
                region = cache.createRegion(regionName, factory.create());
                continue;
            }
            Region<Object, Object> subregion = region.getSubregion(regionName);
            if (subregion == null) {
                factory.setScope(scope);
                subregion = region.createSubregion(regionName, factory.create());
            }
            region = subregion;
        }
        return region;
    }

    public static List getAllRegionPathListInDistributedSystem(DistributedSystem ds, boolean recursive) {
        List list = new ArrayList();
        try {
            AdminDistributedSystem adminSystem = RegionUtil.getAdminDistributedSystemConnected(ds);
            SystemMember[] members = adminSystem.getSystemMemberApplications();
            for (int i = 0; i < members.length; ++i) {
                SystemMemberCache cache = members[i].getCache();
                if (cache == null) continue;
                list = RegionUtil.getRegionPaths(cache, list, recursive);
            }
            CacheVm[] vms = adminSystem.getCacheVms();
            for (int i = 0; i < vms.length; ++i) {
                SystemMemberCache cache = vms[i].getCache();
                if (cache == null) continue;
                list = RegionUtil.getRegionPaths(cache, list, recursive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(list);
        return list;
    }

    public static String[] getAllRegionPathsInDistributedSystem(DistributedSystem ds, boolean recursive) {
        List list = RegionUtil.getAllRegionPathListInDistributedSystem(ds, recursive);
        return list.toArray(new String[0]);
    }

    public static List getRegionPathList(SystemMemberCache cache, boolean recursive) throws Exception {
        return RegionUtil.getRegionPaths(cache, new ArrayList(), recursive);
    }

    public static String[] getRegionPaths(SystemMemberCache cache, boolean recursive) throws Exception {
        List list = RegionUtil.getRegionPathList(cache, recursive);
        return list.toArray(new String[0]);
    }

    private static List getRegionPaths(SystemMemberCache cache, List list, boolean recursive) throws Exception {
        Set regions = cache.getRootRegionNames();
        Iterator itor = regions.iterator();
        while (itor.hasNext()) {
            String regionPath = "/" + itor.next().toString();
            SystemMemberRegion systemMemberRegion = cache.getRegion(regionPath);
            if (!list.contains(regionPath)) {
                list.add(regionPath);
            }
            if (!recursive || systemMemberRegion.getSubregionCount() <= 0) continue;
            RegionUtil.getRegionPaths(systemMemberRegion, cache, list);
        }
        return list;
    }

    private static List getRegionPaths(SystemMemberRegion systemMemberRegion, SystemMemberCache cache, List list, boolean recursive) throws Exception {
        Set regionNames = systemMemberRegion.getSubregionNames();
        list.addAll(regionNames);
        for (String regionPath : regionNames) {
            if (!list.contains(regionPath)) {
                list.add(regionPath);
            }
            SystemMemberRegion subregion = cache.getRegion(regionPath);
            if (!recursive || subregion == null || subregion.getSubregionCount() <= 0) continue;
            list = RegionUtil.getRegionPaths(subregion, cache, list, recursive);
        }
        return list;
    }

    private static List getRegionPaths(SystemMemberRegion systemMemberRegion, SystemMemberCache cache, List list) throws Exception {
        Set subregions = systemMemberRegion.getSubregionFullPaths();
        Iterator itor = subregions.iterator();
        while (itor.hasNext()) {
            SystemMemberRegion subregion;
            String regionPath = itor.next().toString();
            if (!list.contains(regionPath)) {
                list.add(regionPath);
            }
            if ((subregion = cache.getRegion(regionPath)) == null || subregion.getSubregionCount() <= 0) continue;
            RegionUtil.getRegionPaths(subregion, cache, list);
        }
        return list;
    }

    public static List getAllRegionPathList(Cache cache) {
        return RegionUtil.getAllRegionPathList(cache, true);
    }

    public static List getAllRegionPathList(Cache cache, boolean recursive) {
        ArrayList<String> list = new ArrayList<String>();
        if (cache == null) {
            return list;
        }
        Set<Region<?, ?>> regions = cache.rootRegions();
        Iterator<Region<?, ?>> itor = regions.iterator();
        while (itor.hasNext()) {
            String regionPath = itor.next().getFullPath();
            Region region = cache.getRegion(regionPath);
            list.add(regionPath);
            Set<Region<?, ?>> subregionSet = region.subregions(true);
            if (!recursive) continue;
            Iterator<Region<?, ?>> subIter = subregionSet.iterator();
            while (subIter.hasNext()) {
                list.add(subIter.next().getFullPath());
            }
        }
        Collections.sort(list);
        return list;
    }

    public static String[] getAllRegionPaths(Cache cache) {
        return RegionUtil.getAllRegionPaths(cache, true);
    }

    public static String[] getAllRegionPaths(Cache cache, boolean recursive) {
        List list = RegionUtil.getAllRegionPathList(cache, recursive);
        return list.toArray(new String[0]);
    }

    public static List getAllRegionPathList(Region region, boolean recursive) {
        ArrayList<String> list = new ArrayList<String>();
        if (region == null) {
            return list;
        }
        Set<Region<?, ?>> subregionSet = region.subregions(true);
        if (recursive) {
            Iterator<Region<?, ?>> subIter = subregionSet.iterator();
            while (subIter.hasNext()) {
                list.add(subIter.next().getFullPath());
            }
        }
        Collections.sort(list);
        return list;
    }

    public static String[] getAllRegionPaths(Region region, boolean recursive) {
        List list = RegionUtil.getAllRegionPathList(region, recursive);
        return list.toArray(new String[0]);
    }

    public static List getAllRegionPathListInDistributedSystem(Region region, boolean recursive) {
        DistributedSystem ds = region.getCache().getDistributedSystem();
        String regionPath = region.getFullPath();
        List list = new ArrayList();
        try {
            AdminDistributedSystem adminSystem = RegionUtil.getAdminDistributedSystemConnected(ds);
            SystemMember[] members = adminSystem.getSystemMemberApplications();
            for (int i = 0; i < members.length; ++i) {
                SystemMemberCache cache = members[i].getCache();
                if (cache == null) continue;
                SystemMemberRegion sregion = cache.getRegion(regionPath);
                list = RegionUtil.getRegionPaths(sregion, cache, list, recursive);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.sort(list);
        return list;
    }

    public static String[] getAllRegionPathsInDistributedSystem(Region region, boolean recursive) {
        List list = RegionUtil.getAllRegionPathListInDistributedSystem(region, recursive);
        return list.toArray(new String[0]);
    }

    public static AdminDistributedSystem getAdminDistributedSystemConnected(DistributedSystem ds) throws AdminException {
        AdminDistributedSystem adminSystem = AdminDistributedSystemImpl.getConnectedInstance();
        if (adminSystem == null) {
            DistributedSystemConfig config = AdminDistributedSystemFactory.defineDistributedSystem(ds, null);
            adminSystem = AdminDistributedSystemFactory.getDistributedSystem(config);
        }
        try {
            if (!adminSystem.isConnected()) {
                adminSystem.connect();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return adminSystem;
    }

    public static void createAllRegionsInDistributedSystem(DistributedSystem ds, Scope scope) {
        try {
            AdminDistributedSystem adminSystem = RegionUtil.getAdminDistributedSystemConnected(ds);
            SystemMember[] members = adminSystem.getSystemMemberApplications();
            for (int i = 0; i < members.length; ++i) {
                SystemMemberCache cache = members[i].getCache();
                if (cache == null) continue;
                RegionUtil.createCache(cache, scope);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createAllRegionsInCacheServers(DistributedSystem ds, Scope scope) {
        try {
            AdminDistributedSystem adminSystem = RegionUtil.getAdminDistributedSystemConnected(ds);
            CacheVm[] cacheVms = adminSystem.getCacheVms();
            for (int i = 0; i < cacheVms.length; ++i) {
                SystemMemberCache cache = cacheVms[i].getCache();
                if (cache == null) continue;
                RegionUtil.createCache(cache, scope);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createCache(SystemMemberCache cache, Scope scope) throws Exception {
        Set regions = cache.getRootRegionNames();
        Iterator itor = regions.iterator();
        while (itor.hasNext()) {
            String regionName = itor.next().toString();
            SystemMemberRegion systemMemberRegion = cache.getRegion(regionName);
            Scope regionScope = scope == null ? systemMemberRegion.getScope() : scope;
            Region region = RegionUtil.getRegion(systemMemberRegion.getFullPath(), regionScope, DataPolicy.NORMAL, null);
            if (systemMemberRegion.getSubregionCount() <= 0) continue;
            RegionUtil.createRegion(region, systemMemberRegion, cache, scope);
        }
    }

    private static void createRegion(Region region, SystemMemberRegion systemMemberRegion, SystemMemberCache cache, Scope scope) throws Exception {
        Set subregions = systemMemberRegion.getSubregionFullPaths();
        Iterator itor = subregions.iterator();
        while (itor.hasNext()) {
            String regionName = itor.next().toString();
            SystemMemberRegion subregion = cache.getRegion(regionName);
            region = RegionUtil.getRegion(systemMemberRegion.getFullPath(), scope, DataPolicy.NORMAL, null);
            if (subregion.getSubregionCount() <= 0) continue;
            RegionUtil.createRegion(region, subregion, cache, scope);
        }
    }

    public static final void clearLocalRegion(Region region) throws CacheException {
        if (region == null) {
            return;
        }
        Iterator iterator = region.keySet().iterator();
        while (iterator.hasNext()) {
            try {
                region.localDestroy(iterator.next());
            }
            catch (EntryNotFoundException entryNotFoundException) {}
        }
    }

    public static final void clearRegion(Region region) throws CacheException {
        if (region == null) {
            return;
        }
        region.clear();
    }

    public static Region<?, ?> getLocalRegion(String regionPath) {
        Region region = null;
        try {
            Cache cache = CacheFactory.getAnyInstance();
            region = cache.getRegion(regionPath);
        }
        catch (CacheClosedException cce) {
            region = null;
        }
        return region;
    }
}

