/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util;

import java.nio.ByteBuffer;

public class Bytes {
    public static void putInt(int val, byte[] buf, int off) {
        assert (off + 4 <= buf.length);
        buf[off] = Bytes.int0(val);
        buf[off + 1] = Bytes.int1(val);
        buf[off + 2] = Bytes.int2(val);
        buf[off + 3] = Bytes.int3(val);
    }

    public static void putLong(long val, byte[] buf, int off) {
        assert (off + 4 <= buf.length);
        buf[off] = Bytes.long0(val);
        buf[off + 1] = Bytes.long1(val);
        buf[off + 2] = Bytes.long2(val);
        buf[off + 3] = Bytes.long3(val);
        buf[off + 4] = Bytes.long4(val);
        buf[off + 5] = Bytes.long5(val);
        buf[off + 6] = Bytes.long6(val);
        buf[off + 7] = Bytes.long7(val);
    }

    public static int getVarInt(ByteBuffer buf) {
        byte b = buf.get();
        int val = b & 0x7F;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf.get();
        val |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf.get();
        val |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf.get();
        val |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf.get();
        return val |= (b & 0x7F) << 28;
    }

    public static int getVarInt(byte[] buf, int off) {
        byte b = buf[off++];
        int val = b & 0x7F;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf[off++];
        val |= (b & 0x7F) << 7;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf[off++];
        val |= (b & 0x7F) << 14;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf[off++];
        val |= (b & 0x7F) << 21;
        if ((b & 0x80) == 0) {
            return val;
        }
        b = buf[off++];
        return val |= (b & 0x7F) << 28;
    }

    public static ByteBuffer putVarInt(int val, ByteBuffer buf) {
        assert (val >= 0);
        while ((val & 0xFFFFFF80) != 0) {
            buf.put((byte)(val & 0x7F | 0x80));
            val >>= 7;
        }
        return buf.put((byte)val);
    }

    public static int putVarInt(int val, byte[] buf, int off) {
        assert (val >= 0);
        while (val > 127) {
            buf[off++] = (byte)(val & 0x7F | 0x80);
            val >>= 7;
        }
        buf[off++] = (byte)val;
        return off;
    }

    public static int sizeofVarInt(int val) {
        assert (val >= 0);
        if (val < 128) {
            return 1;
        }
        if (val < 16384) {
            return 2;
        }
        if (val < 0x200000) {
            return 3;
        }
        if (val < 0x10000000) {
            return 4;
        }
        return 5;
    }

    public static short toShort(byte b0, byte b1) {
        return (short)(b0 << 8 | b1 & 0xFF);
    }

    public static char toChar(byte b0, byte b1) {
        return (char)(b0 << 8 | b1 & 0xFF);
    }

    public static int toUnsignedShort(byte b0, byte b1) {
        return (b0 & 0xFF) << 8 | b1 & 0xFF;
    }

    public static int toInt(byte b0, byte b1, byte b2, byte b3) {
        return b0 << 24 | (b1 & 0xFF) << 16 | (b2 & 0xFF) << 8 | b3 & 0xFF;
    }

    public static long toLong(byte b0, byte b1, byte b2, byte b3, byte b4, byte b5, byte b6, byte b7) {
        return (long)b0 << 56 | ((long)b1 & 0xFFL) << 48 | ((long)b2 & 0xFFL) << 40 | ((long)b3 & 0xFFL) << 32 | ((long)b4 & 0xFFL) << 24 | ((long)b5 & 0xFFL) << 16 | ((long)b6 & 0xFFL) << 8 | (long)b7 & 0xFFL;
    }

    public static byte char0(char value2) {
        return (byte)(value2 >> 8);
    }

    public static byte char1(char value2) {
        return (byte)value2;
    }

    public static byte short0(short value2) {
        return (byte)(value2 >> 8);
    }

    public static byte short1(short value2) {
        return (byte)value2;
    }

    public static byte int0(int value2) {
        return (byte)(value2 >> 24);
    }

    public static byte int1(int value2) {
        return (byte)(value2 >> 16);
    }

    public static byte int2(int value2) {
        return (byte)(value2 >> 8);
    }

    public static byte int3(int value2) {
        return (byte)value2;
    }

    public static byte long0(long value2) {
        return (byte)(value2 >> 56);
    }

    public static byte long1(long value2) {
        return (byte)(value2 >> 48);
    }

    public static byte long2(long value2) {
        return (byte)(value2 >> 40);
    }

    public static byte long3(long value2) {
        return (byte)(value2 >> 32);
    }

    public static byte long4(long value2) {
        return (byte)(value2 >> 24);
    }

    public static byte long5(long value2) {
        return (byte)(value2 >> 16);
    }

    public static byte long6(long value2) {
        return (byte)(value2 >> 8);
    }

    public static byte long7(long value2) {
        return (byte)value2;
    }
}

