/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.internal.util.concurrent;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CopyOnWriteHashMap<K, V>
extends AbstractMap<K, V> {
    private volatile Map<K, V> map = Collections.emptyMap();

    public CopyOnWriteHashMap() {
    }

    public CopyOnWriteHashMap(Map map) {
        this.putAll(map);
    }

    @Override
    public V get(Object key2) {
        return this.map.get(key2);
    }

    @Override
    public synchronized V put(K key2, V value2) {
        HashMap<K, V> tmp = new HashMap<K, V>(this.map);
        V result = tmp.put(key2, value2);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void putAll(Map<? extends K, ? extends V> m) {
        HashMap<? extends K, ? extends V> tmp = new HashMap<K, V>(this.map);
        tmp.putAll(m);
        this.map = Collections.unmodifiableMap(tmp);
    }

    @Override
    public synchronized V remove(Object key2) {
        HashMap<K, V> tmp = new HashMap<K, V>(this.map);
        V result = tmp.remove(key2);
        this.map = Collections.unmodifiableMap(tmp);
        return result;
    }

    @Override
    public synchronized void clear() {
        this.map = Collections.emptyMap();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsValue(Object value2) {
        return this.map.containsValue(value2);
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.map.containsKey(key2);
    }

    @Override
    public Set<K> keySet() {
        return this.map.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public boolean equals(Object o) {
        return this.map.equals(o);
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        CopyOnWriteHashMap<K, V> clone = new CopyOnWriteHashMap<K, V>();
        clone.map = this.map;
        return clone;
    }
}

