/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.logging.DateFormatter;
import com.gemstone.gemfire.internal.logging.LogWriterImpl;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.Date;

public class AlertDetails {
    private int alertLevel;
    private String connectionName;
    private String threadName;
    private long tid;
    private String msg;
    private String exceptionText;
    private Date msgDate;
    private final String sourceId;
    private final String message;
    private InternalDistributedMember sender;

    public AlertDetails(int alertLevel, Date msgDate, String connectionName, String threadName, long tid, String msg, String exceptionText, InternalDistributedMember sender) {
        this.alertLevel = alertLevel;
        this.connectionName = connectionName;
        this.threadName = threadName;
        this.tid = tid;
        this.msg = msg;
        this.exceptionText = exceptionText;
        this.msgDate = msgDate;
        this.sender = sender;
        StringBuffer tmpSourceId = new StringBuffer();
        tmpSourceId.append(threadName);
        if (tmpSourceId.length() > 0) {
            tmpSourceId.append(' ');
        }
        tmpSourceId.append("tid=0x");
        tmpSourceId.append(Long.toHexString(tid));
        this.sourceId = tmpSourceId.toString();
        StringBuffer tmpMessage = new StringBuffer();
        tmpMessage.append(msg);
        if (tmpMessage.length() > 0) {
            tmpMessage.append('\n');
        }
        tmpMessage.append(exceptionText);
        this.message = tmpMessage.toString();
    }

    public int getAlertLevel() {
        return this.alertLevel;
    }

    public String getConnectionName() {
        return this.connectionName;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getTid() {
        return this.tid;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getExceptionText() {
        return this.exceptionText;
    }

    public Date getMsgTime() {
        return this.msgDate;
    }

    public String getSource() {
        return this.sourceId;
    }

    public InternalDistributedMember getSender() {
        return this.sender;
    }

    public String toString() {
        DateFormat timeFormatter = DateFormatter.createDateFormat();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print('[');
        pw.print(LogWriterImpl.levelToString(this.alertLevel));
        pw.print(' ');
        pw.print(timeFormatter.format(this.msgDate));
        pw.print(' ');
        pw.print(this.connectionName);
        pw.print(' ');
        pw.print(this.sourceId);
        pw.print("] ");
        pw.print(this.message);
        pw.close();
        try {
            sw.close();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        return sw.toString();
    }

    public static final String getAlertLevelAsString(int intLevel) {
        if (intLevel == 1000) {
            return "severe";
        }
        if (intLevel == 950) {
            return "error";
        }
        if (intLevel == 900) {
            return "warning";
        }
        if (intLevel == Integer.MAX_VALUE) {
            return "none";
        }
        throw new IllegalArgumentException("Unable to find an alert level with int value: " + intLevel);
    }
}

