/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.CancelException;
import com.gemstone.gemfire.SystemFailure;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.GemFireCache;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.execute.FunctionService;
import com.gemstone.gemfire.distributed.DistributedSystem;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.AlreadyRunningException;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.internal.JmxManagerAdvisor;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorRequest;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorResponse;
import com.gemstone.org.jgroups.stack.tcpserver.TcpHandler;
import com.gemstone.org.jgroups.stack.tcpserver.TcpServer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Logger;

public class JmxManagerLocator
implements TcpHandler {
    private static final Logger logger = LogService.getLogger();
    private GemFireCacheImpl cache;

    public JmxManagerLocator(GemFireCacheImpl gfc) {
        this.cache = gfc;
    }

    @Override
    public Object processRequest(Object request) throws IOException {
        assert (request instanceof JmxManagerLocatorRequest);
        return this.findJmxManager((JmxManagerLocatorRequest)request);
    }

    @Override
    public void endRequest(Object request, long startTime) {
    }

    @Override
    public void endResponse(Object request, long startTime) {
    }

    @Override
    public void shutDown() {
    }

    @Override
    public void restarting(DistributedSystem ds, GemFireCache cache, SharedConfiguration sharedConfig) {
        this.cache = (GemFireCacheImpl)cache;
    }

    @Override
    public void init(TcpServer tcpServer) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JmxManagerLocatorResponse findJmxManager(JmxManagerLocatorRequest request) {
        List<JmxManagerAdvisor.JmxManagerProfile> willingToManage;
        List<JmxManagerAdvisor.JmxManagerProfile> alreadyManaging;
        JmxManagerLocatorResponse result = null;
        if (logger.isDebugEnabled()) {
            logger.debug("Locator requested to find or start jmx manager");
        }
        if ((alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging()).isEmpty() && !(willingToManage = this.cache.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
            JmxManagerLocator jmxManagerLocator = this;
            synchronized (jmxManagerLocator) {
                alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                if (alreadyManaging.isEmpty() && !(willingToManage = this.cache.getJmxManagerAdvisor().adviseWillingToManage()).isEmpty()) {
                    JmxManagerAdvisor.JmxManagerProfile p = willingToManage.get(0);
                    if (p.getDistributedMember().equals(this.cache.getMyId())) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Locator starting jmx manager in its JVM");
                        }
                        try {
                            ManagementService.getManagementService(this.cache).startManager();
                        }
                        catch (CancelException ex) {
                        }
                        catch (VirtualMachineError err) {
                            SystemFailure.initiateFailure(err);
                            throw err;
                        }
                        catch (Throwable t) {
                            SystemFailure.checkFailure();
                            return new JmxManagerLocatorResponse(null, 0, false, t);
                        }
                    } else {
                        p = this.startJmxManager(willingToManage);
                        if (p != null && logger.isDebugEnabled()) {
                            logger.debug("Locator started jmx manager in {}", p.getDistributedMember());
                        }
                        alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                        int sleepCount = 0;
                        while (sleepCount < 20 && alreadyManaging.isEmpty() && this.cache.getDistributionManager().getDistributionManagerIds().contains(p.getDistributedMember())) {
                            ++sleepCount;
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                            }
                            alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                        }
                    }
                    if (alreadyManaging.isEmpty()) {
                        alreadyManaging = this.cache.getJmxManagerAdvisor().adviseAlreadyManaging();
                    }
                }
            }
        }
        if (!alreadyManaging.isEmpty()) {
            JmxManagerAdvisor.JmxManagerProfile p = alreadyManaging.get(0);
            result = new JmxManagerLocatorResponse(p.getHost(), p.getPort(), p.getSsl(), null);
            if (logger.isDebugEnabled()) {
                logger.debug("Found jmx manager: " + p);
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("Did not find a jmx manager");
            }
            result = new JmxManagerLocatorResponse();
        }
        return result;
    }

    private JmxManagerAdvisor.JmxManagerProfile startJmxManager(List<JmxManagerAdvisor.JmxManagerProfile> willingToManage) {
        for (JmxManagerAdvisor.JmxManagerProfile p : willingToManage) {
            if (!this.sendStartJmxManager(p.getDistributedMember())) continue;
            return p;
        }
        return null;
    }

    private boolean sendStartJmxManager(InternalDistributedMember distributedMember) {
        try {
            ArrayList resultContainer = (ArrayList)FunctionService.onMember(distributedMember).execute(new StartJmxManagerFunction()).getResult();
            Object result = resultContainer.get(0);
            if (result instanceof Boolean) {
                return (Boolean)result;
            }
            logger.info("Could not start jmx manager on {} because {}", distributedMember, result);
            return false;
        }
        catch (RuntimeException ex) {
            if (!this.cache.getDistributionManager().getDistributionManagerIdsIncludingAdmin().contains(distributedMember)) {
                logger.info("Could not start jmx manager on {} because of {}", distributedMember, ex.getMessage(), ex);
                return false;
            }
            throw ex;
        }
    }

    public static class StartJmxManagerFunction
    implements Function,
    InternalEntity {
        private static final long serialVersionUID = -2860286061903069789L;
        public static final String ID = StartJmxManagerFunction.class.getName();

        @Override
        public void execute(FunctionContext context) {
            try {
                ManagementService ms;
                Cache cache = CacheFactory.getAnyInstance();
                if (cache != null && (ms = ManagementService.getExistingManagementService(cache)) != null) {
                    if (!ms.isManager()) {
                        ms.startManager();
                    }
                    context.getResultSender().lastResult(Boolean.TRUE);
                }
                context.getResultSender().lastResult(Boolean.FALSE);
            }
            catch (AlreadyRunningException ok) {
                context.getResultSender().lastResult(Boolean.TRUE);
            }
            catch (Exception e) {
                context.getResultSender().lastResult("Exception in StartJmxManager =" + e.getMessage());
            }
        }

        @Override
        public String getId() {
            return ID;
        }

        @Override
        public boolean hasResult() {
            return true;
        }

        @Override
        public boolean optimizeForWrite() {
            return false;
        }

        @Override
        public boolean isHA() {
            return false;
        }
    }
}

