/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.ClassLoadUtil;
import com.gemstone.gemfire.management.AsyncEventQueueMXBean;
import com.gemstone.gemfire.management.CacheServerMXBean;
import com.gemstone.gemfire.management.DiskStoreMXBean;
import com.gemstone.gemfire.management.DistributedLockServiceMXBean;
import com.gemstone.gemfire.management.DistributedRegionMXBean;
import com.gemstone.gemfire.management.DistributedSystemMXBean;
import com.gemstone.gemfire.management.GatewayReceiverMXBean;
import com.gemstone.gemfire.management.GatewaySenderMXBean;
import com.gemstone.gemfire.management.LocatorMXBean;
import com.gemstone.gemfire.management.LockServiceMXBean;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagerMXBean;
import com.gemstone.gemfire.management.MemberMXBean;
import com.gemstone.gemfire.management.RegionMXBean;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class MBeanJMXAdapter
implements ManagementConstants {
    public static MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
    private Map<ObjectName, Object> localGemFireMBean = new ConcurrentHashMap<ObjectName, Object>();
    private DistributedMember distMember = InternalDistributedSystem.getConnectedInstance().getDistributedMember();
    public static int VALUE_NOT_AVAILABLE = -1;

    public ObjectName registerMBean(Object object, ObjectName objectName, boolean isGemFireMBean) {
        ObjectName newObjectName = objectName;
        try {
            if (!isGemFireMBean) {
                String member = MBeanJMXAdapter.getMemberNameOrId(this.distMember);
                String objectKeyProperty = objectName.getKeyPropertyListString();
                newObjectName = ObjectName.getInstance("GemFire:" + objectKeyProperty + "," + "member=" + member);
            }
            mbeanServer.registerMBean(object, newObjectName);
            this.localGemFireMBean.put(newObjectName, object);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ManagementException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new ManagementException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new ManagementException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new ManagementException(e);
        }
        catch (NullPointerException e) {
            throw new ManagementException(e);
        }
        return newObjectName;
    }

    public boolean hasNotificationSupport(ObjectName objectName) {
        try {
            if (!this.isRegistered(objectName)) {
                return false;
            }
            ObjectInstance instance = mbeanServer.getObjectInstance(objectName);
            String className = instance.getClassName();
            Class cls = ClassLoadUtil.classFromName(className);
            Type[] intfTyps = cls.getGenericInterfaces();
            for (int i = 0; i < intfTyps.length; ++i) {
                Class intfTyp = (Class)intfTyps[i];
                if (!intfTyp.equals(NotificationEmitter.class)) continue;
                return true;
            }
            Class supreClassTyp = (Class)cls.getGenericSuperclass();
            if (supreClassTyp != null && supreClassTyp.equals(NotificationBroadcasterSupport.class)) {
                return true;
            }
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementException(e);
        }
        catch (ClassNotFoundException e) {
            throw new ManagementException(e);
        }
        return false;
    }

    public void registerMBeanProxy(Object object, ObjectName objectName) {
        try {
            mbeanServer.registerMBean(object, objectName);
        }
        catch (InstanceAlreadyExistsException e) {
            throw new ManagementException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new ManagementException(e);
        }
        catch (NotCompliantMBeanException e) {
            throw new ManagementException(e);
        }
        catch (NullPointerException e) {
            throw new ManagementException(e);
        }
    }

    public void unregisterMBean(ObjectName objectName) {
        try {
            if (!this.isRegistered(objectName)) {
                return;
            }
            mbeanServer.unregisterMBean(objectName);
            if (this.localGemFireMBean.get(objectName) != null) {
                this.localGemFireMBean.remove(objectName);
            }
        }
        catch (NullPointerException e) {
            throw new ManagementException(e);
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementException(e);
        }
        catch (MBeanRegistrationException e) {
            throw new ManagementException(e);
        }
    }

    public Object getMBeanObject(ObjectName objectName) {
        return this.localGemFireMBean.get(objectName);
    }

    public <T> T findMBeanByName(ObjectName objectName, Class<T> interfaceClass) {
        Object mbeanInstance = this.localGemFireMBean.get(objectName);
        if (mbeanInstance != null) {
            return interfaceClass.cast(mbeanInstance);
        }
        return null;
    }

    public boolean isLocalMBean(ObjectName objectName) {
        return this.localGemFireMBean.containsKey(objectName);
    }

    public void unregisterAll() {
        try {
            ObjectName name = new ObjectName("GemFire:*");
            Set<ObjectName> gemFireObjects = mbeanServer.queryNames(name, null);
            for (ObjectName objectName : gemFireObjects) {
                this.unregisterMBean(objectName);
            }
        }
        catch (MalformedObjectNameException e) {
            throw new ManagementException(e);
        }
        catch (NullPointerException e) {
            throw new ManagementException(e);
        }
    }

    public void cleanJMXResource() {
        this.localGemFireMBean.clear();
        this.unregisterAll();
    }

    public boolean isRegistered(ObjectName objectName) {
        return mbeanServer.isRegistered(objectName);
    }

    public static String getMemberNameOrId(DistributedMember member) {
        if (member.getName() != null && !member.getName().equals("")) {
            return MBeanJMXAdapter.makeCompliantName(member.getName());
        }
        return MBeanJMXAdapter.makeCompliantName(member.getId());
    }

    public static String makeCompliantName(String value2) {
        value2 = value2.replace(':', '-');
        value2 = value2.replace(',', '-');
        value2 = value2.replace('=', '-');
        value2 = value2.replace('*', '-');
        if ((value2 = value2.replace('?', '-')).length() < 1) {
            value2 = "nothing";
        }
        return value2;
    }

    public static String makeCompliantRegionPath(String value2) {
        if (MBeanJMXAdapter.isQuoted(value2)) {
            value2 = ObjectName.unquote(value2);
        } else if (MBeanJMXAdapter.containsSpecialChar(value2)) {
            value2 = ObjectName.quote(value2);
        }
        return value2;
    }

    private static boolean containsSpecialChar(String value2) {
        if (value2.contains(":")) {
            return true;
        }
        if (value2.contains("@")) {
            return true;
        }
        if (value2.contains("-")) {
            return true;
        }
        if (value2.contains("#")) {
            return true;
        }
        if (value2.contains("+")) {
            return true;
        }
        return value2.contains("?");
    }

    private static boolean isQuoted(String value2) {
        int len = value2.length();
        return len >= 2 && value2.charAt(0) == '\"' && value2.charAt(len - 1) == '\"';
    }

    public static String makeCompliantRegionNameAppender(String value2) {
        return value2.replace("/", "-").replace(":", "");
    }

    public MemberMXBean getMemberMXBean() {
        ObjectName objName = MBeanJMXAdapter.getMemberMBeanName(this.distMember);
        return (MemberMXBean)this.localGemFireMBean.get(objName);
    }

    public RegionMXBean getLocalRegionMXBean(String regionPath) {
        ObjectName objName = MBeanJMXAdapter.getRegionMBeanName(this.distMember, regionPath);
        return (RegionMXBean)this.localGemFireMBean.get(objName);
    }

    public LockServiceMXBean getLocalLockServiceMXBean(String lockServiceName) {
        ObjectName objName = MBeanJMXAdapter.getLockServiceMBeanName(this.distMember, lockServiceName);
        return (LockServiceMXBean)this.localGemFireMBean.get(objName);
    }

    public DiskStoreMXBean getLocalDiskStoreMXBean(String disStoreName) {
        ObjectName objName = MBeanJMXAdapter.getDiskStoreMBeanName(this.distMember, disStoreName);
        return (DiskStoreMXBean)this.localGemFireMBean.get(objName);
    }

    public CacheServerMXBean getClientServiceMXBean(int serverPort) {
        ObjectName objName = MBeanJMXAdapter.getClientServiceMBeanName(serverPort, this.distMember);
        return (CacheServerMXBean)this.localGemFireMBean.get(objName);
    }

    public DistributedLockServiceMXBean getDistributedLockServiceMXBean(String lockServiceName) {
        ObjectName objName = MBeanJMXAdapter.getDistributedLockServiceName(lockServiceName);
        return (DistributedLockServiceMXBean)this.localGemFireMBean.get(objName);
    }

    public DistributedRegionMXBean getDistributedRegionMXBean(String regionPath) {
        ObjectName objName = MBeanJMXAdapter.getDistributedRegionMbeanName(regionPath);
        return (DistributedRegionMXBean)this.localGemFireMBean.get(objName);
    }

    public ManagerMXBean getManagerMXBean() {
        ObjectName objName = MBeanJMXAdapter.getManagerName();
        return (ManagerMXBean)this.localGemFireMBean.get(objName);
    }

    public DistributedSystemMXBean getDistributedSystemMXBean() {
        ObjectName objName = MBeanJMXAdapter.getDistributedSystemName();
        return (DistributedSystemMXBean)this.localGemFireMBean.get(objName);
    }

    public GatewayReceiverMXBean getGatewayReceiverMXBean() {
        ObjectName objName = MBeanJMXAdapter.getGatewayReceiverMBeanName(this.distMember);
        return (GatewayReceiverMXBean)this.localGemFireMBean.get(objName);
    }

    public GatewaySenderMXBean getGatewaySenderMXBean(String senderId) {
        ObjectName objName = MBeanJMXAdapter.getGatewaySenderMBeanName(this.distMember, senderId);
        return (GatewaySenderMXBean)this.localGemFireMBean.get(objName);
    }

    public AsyncEventQueueMXBean getAsyncEventQueueMXBean(String queueId) {
        ObjectName objName = MBeanJMXAdapter.getAsycnEventQueueMBeanName(this.distMember, queueId);
        return (AsyncEventQueueMXBean)this.localGemFireMBean.get(objName);
    }

    public LocatorMXBean getLocatorMXBean() {
        ObjectName objName = MBeanJMXAdapter.getLocatorMBeanName(this.distMember);
        return (LocatorMXBean)this.localGemFireMBean.get(objName);
    }

    public static ObjectName getObjectName(String name) {
        try {
            return ObjectName.getInstance(name);
        }
        catch (MalformedObjectNameException e) {
            throw new ManagementException(e);
        }
        catch (NullPointerException e) {
            throw new ManagementException(e);
        }
    }

    public static ObjectName getMemberMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:type=Member,member={0}", MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getMemberMBeanName(String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:type=Member,member={0}", MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getRegionMBeanName(DistributedMember member, String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", MBeanJMXAdapter.makeCompliantRegionPath(regionPath), MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getRegionMBeanName(String member, String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", MBeanJMXAdapter.makeCompliantRegionPath(regionPath), MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getRegionMBeanName(ObjectName memberMBeanName, String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Member,member={1}", MBeanJMXAdapter.makeCompliantRegionPath(regionPath), memberMBeanName.getKeyProperty("member")));
    }

    public static ObjectName getDiskStoreMBeanName(DistributedMember member, String diskName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=DiskStore,name={0},type=Member,member={1}", diskName, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getDiskStoreMBeanName(String member, String diskName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=DiskStore,name={0},type=Member,member={1}", diskName, MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getClientServiceMBeanName(int serverPort, DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=CacheServer,port={0},type=Member,member={1}", String.valueOf(serverPort), MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getClientServiceMBeanName(int serverPort, String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=CacheServer,port={0},type=Member,member={1}", String.valueOf(serverPort), MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getLockServiceMBeanName(DistributedMember member, String lockServiceName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=LockService,name={0},type=Member,member={1}", lockServiceName, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getLockServiceMBeanName(String member, String lockServiceName) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=LockService,name={0},type=Member,member={1}", lockServiceName, MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getGatewayReceiverMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewayReceiver,type=Member,member={0}", MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getGatewayReceiverMBeanName(String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewayReceiver,type=Member,member={0}", MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getGatewaySenderMBeanName(DistributedMember member, String id) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewaySender,gatewaySender={0},type=Member,member={1}", id, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getGatewaySenderMBeanName(String member, String id) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=GatewaySender,gatewaySender={0},type=Member,member={1}", id, MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getAsycnEventQueueMBeanName(DistributedMember member, String queueId) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=AsyncEventQueue,queue={0},type=Member,member={1}", queueId, MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getAsycnEventQueueMBeanName(String member, String queueId) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=AsyncEventQueue,queue={0},type=Member,member={1}", queueId, MBeanJMXAdapter.makeCompliantName(member)));
    }

    public static ObjectName getDistributedRegionMbeanName(String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Distributed", MBeanJMXAdapter.makeCompliantRegionPath(regionPath)));
    }

    public static ObjectName getDistributedRegionMbeanNameInternal(String regionPath) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Region,name={0},type=Distributed", regionPath));
    }

    public static ObjectName getDistributedLockServiceName(String lockService) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=LockService,name={0},type=Distributed", lockService));
    }

    public static ObjectName getDistributedSystemName() {
        return MBeanJMXAdapter.getObjectName("GemFire:service=System,type=Distributed");
    }

    public static ObjectName getManagerName() {
        String member = MBeanJMXAdapter.getMemberNameOrId(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Manager,type=Member,member={0}", member));
    }

    public static ObjectName getLocatorMBeanName(DistributedMember member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Locator,type=Member,member={0}", MBeanJMXAdapter.getMemberNameOrId(member)));
    }

    public static ObjectName getLocatorMBeanName(String member) {
        return MBeanJMXAdapter.getObjectName(MessageFormat.format("GemFire:service=Locator,type=Member,member={0}", MBeanJMXAdapter.makeCompliantName(member)));
    }

    public Map<ObjectName, Object> getLocalGemFireMBean() {
        return this.localGemFireMBean;
    }

    public static String getUniqueIDForMember(DistributedMember member) {
        InternalDistributedMember iMember = (InternalDistributedMember)member;
        StringBuilder sb = new StringBuilder();
        sb.append(iMember.getIpAddress().getHostAddress());
        sb.append("<v" + iMember.getVmViewId() + ">");
        sb.append(iMember.getPort());
        return MBeanJMXAdapter.makeCompliantName(sb.toString().toLowerCase());
    }

    public static boolean isAttributeAvailable(String attributeName, String objectName) {
        try {
            ObjectName objName = new ObjectName(objectName);
            mbeanServer.getAttribute(objName, attributeName);
        }
        catch (MalformedObjectNameException e) {
            return false;
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (AttributeNotFoundException e) {
            return false;
        }
        catch (InstanceNotFoundException e) {
            return false;
        }
        catch (MBeanException e) {
            return false;
        }
        catch (ReflectionException e) {
            return false;
        }
        return true;
    }
}

