/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.distributed.internal.DistributionConfig;
import com.gemstone.gemfire.internal.SocketCreator;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.tcp.TCPConduit;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.ManagementService;
import com.gemstone.gemfire.management.ManagerMXBean;
import com.gemstone.gemfire.management.internal.JettyHelper;
import com.gemstone.gemfire.management.internal.RestAgent;
import com.gemstone.gemfire.management.internal.SystemManagementService;
import com.gemstone.gemfire.management.internal.unsafe.ReadOpFileAccessController;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.AlreadyBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.HashMap;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;

public class ManagementAgent {
    private static final Logger logger = LogService.getLogger();
    private boolean running = false;
    private Registry registry;
    private JMXConnectorServer cs;
    private final DistributionConfig config;
    private boolean isHttpServiceRunning = false;
    private static final String PULSE_EMBEDDED_PROP = "pulse.embedded";
    private Server httpServer;

    public ManagementAgent(DistributionConfig config) {
        this.config = config;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized boolean isHttpServiceRunning() {
        return this.isHttpServiceRunning;
    }

    public synchronized void setHttpServiceRunning(boolean isHttpServiceRunning) {
        this.isHttpServiceRunning = isHttpServiceRunning;
    }

    private boolean isAPIRestServiceRunning(GemFireCacheImpl cache) {
        return cache != null && cache.getRestAgent() != null && cache.getRestAgent().isRunning();
    }

    private boolean isServerNode(GemFireCacheImpl cache) {
        return cache.getDistributedSystem().getDistributedMember().getVmKind() != 11 && cache.getDistributedSystem().getDistributedMember().getVmKind() != 12 && !cache.isClient();
    }

    public synchronized void startAgent(GemFireCacheImpl cache) {
        if (!this.isAPIRestServiceRunning(cache)) {
            this.startHttpService(this.isServerNode(cache));
        } else if (logger.isDebugEnabled()) {
            logger.debug("Developer REST APIs webapp is already running, Not Starting M&M REST and pulse!");
        }
        if (!this.running && this.config.getJmxManagerPort() != 0) {
            try {
                this.configureAndStart();
            }
            catch (IOException e) {
                throw new ManagementException(e);
            }
            this.running = true;
        }
    }

    public synchronized void stopAgent() {
        this.stopHttpService();
        if (!this.running) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping jmx manager agent");
        }
        try {
            this.cs.stop();
            UnicastRemoteObject.unexportObject(this.registry, true);
        }
        catch (IOException e) {
            throw new ManagementException(e);
        }
        this.running = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void startHttpService(boolean isServer) {
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(CacheFactory.getAnyInstance());
        ManagerMXBean managerBean = managementService.getManagerMXBean();
        if (this.config.getHttpServicePort() != 0) {
            String gemfireAPIWar;
            String pulseWar;
            String gemfireHome;
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to start HTTP service on port ({}) at bind-address ({})...", this.config.getHttpServicePort(), this.config.getHttpServiceBindAddress());
            }
            if (StringUtils.isBlank(gemfireHome = System.getenv("GEMFIRE"))) {
                String message = "GEMFIRE environment variable not set; HTTP service will not start.";
                this.setStatusMessage(managerBean, "GEMFIRE environment variable not set; HTTP service will not start.");
                if (!logger.isDebugEnabled()) return;
                logger.debug("GEMFIRE environment variable not set; HTTP service will not start.");
                return;
            }
            String gemfireWar = this.getGemFireWarLocation(gemfireHome);
            if (gemfireWar == null && logger.isDebugEnabled()) {
                logger.debug("Unable to find GemFire REST API WAR file; the REST API to GemFire will not be exported and accessible.");
            }
            if ((pulseWar = this.getPulseWarLocation(gemfireHome)) == null) {
                String message = "Unable to find Pulse web application WAR file; Pulse will not start in embeded mode";
                this.setStatusMessage(managerBean, "Unable to find Pulse web application WAR file; Pulse will not start in embeded mode");
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to find Pulse web application WAR file; Pulse will not start in embeded mode");
                }
            }
            if ((gemfireAPIWar = this.getGemFireAPIWarLocation(gemfireHome)) == null) {
                String message = "Unable to find developer REST web application WAR file; developer REST will not start in embeded mode";
                this.setStatusMessage(managerBean, "Unable to find developer REST web application WAR file; developer REST will not start in embeded mode");
                if (logger.isDebugEnabled()) {
                    logger.debug("Unable to find developer REST web application WAR file; developer REST will not start in embeded mode");
                }
            }
            try {
                if (!this.isWebApplicationAvailable(gemfireWar, pulseWar, gemfireAPIWar)) return;
                String bindAddress = this.config.getHttpServiceBindAddress();
                int port = this.config.getHttpServicePort();
                boolean isRestWebAppAdded = false;
                this.httpServer = JettyHelper.initJetty(bindAddress, port, this.config.getHttpServiceSSLEnabled(), this.config.getHttpServiceSSLRequireAuthentication(), this.config.getHttpServiceSSLProtocols(), this.config.getHttpServiceSSLCiphers(), this.config.getHttpServiceSSLProperties());
                if (this.isWebApplicationAvailable(gemfireWar)) {
                    this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/gemfire", gemfireWar);
                }
                if (this.isWebApplicationAvailable(pulseWar)) {
                    this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/pulse", pulseWar);
                }
                if (isServer && this.config.getStartDevRestApi()) {
                    if (this.isWebApplicationAvailable(gemfireAPIWar)) {
                        this.httpServer = JettyHelper.addWebApplication(this.httpServer, "/gemfire-api", gemfireAPIWar);
                        isRestWebAppAdded = true;
                    }
                } else {
                    String message = "developer REST web application will not start when start-dev-rest-api is not set and node is not server";
                    this.setStatusMessage(managerBean, "developer REST web application will not start when start-dev-rest-api is not set and node is not server");
                    if (logger.isDebugEnabled()) {
                        logger.debug("developer REST web application will not start when start-dev-rest-api is not set and node is not server");
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Starting HTTP embedded server on port ({}) at bind-address ({})...", ((ServerConnector)this.httpServer.getConnectors()[0]).getPort(), bindAddress);
                }
                System.setProperty(PULSE_EMBEDDED_PROP, "true");
                this.httpServer = JettyHelper.startJetty(this.httpServer);
                if (this.isWebApplicationAvailable(pulseWar)) {
                    managerBean.setPulseURL("http://".concat(this.getHost(bindAddress)).concat(":").concat(String.valueOf(port)).concat("/pulse/"));
                }
                if (isRestWebAppAdded) {
                    GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
                    cache.setRESTServiceRunning(true);
                    RestAgent.createParameterizedQueryRegion();
                }
                this.setHttpServiceRunning(true);
                return;
            }
            catch (Exception e) {
                this.stopHttpService();
                this.setStatusMessage(managerBean, "HTTP service failed to start with " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'");
                throw new ManagementException("HTTP service failed to start", e);
            }
        } else {
            this.setStatusMessage(managerBean, "Embedded HTTP server configured not to start (http-service-port=0) or (jmx-manager-http-port=0)");
        }
    }

    private String getHost(String bindAddress) throws UnknownHostException {
        if (!StringUtils.isBlank(this.config.getJmxManagerHostnameForClients())) {
            return this.config.getJmxManagerHostnameForClients();
        }
        if (!StringUtils.isBlank(bindAddress)) {
            return InetAddress.getByName(bindAddress).getHostAddress();
        }
        return SocketCreator.getLocalHost().getHostAddress();
    }

    private String getGemFireWarLocation(String gemfireHome) {
        assert (!StringUtils.isBlank(gemfireHome)) : "The GEMFIRE environment variable must be set!";
        if (new File(gemfireHome + "/tools/Extensions/gemfire.war").isFile()) {
            return gemfireHome + "/tools/Extensions/gemfire.war";
        }
        if (new File(gemfireHome + "/lib/gemfire.war").isFile()) {
            return gemfireHome + "/lib/gemfire.war";
        }
        return null;
    }

    private String getPulseWarLocation(String gemfireHome) {
        assert (!StringUtils.isBlank(gemfireHome)) : "The GEMFIRE environment variable must be set!";
        if (new File(gemfireHome + "/tools/Pulse/pulse.war").isFile()) {
            return gemfireHome + "/tools/Pulse/pulse.war";
        }
        if (new File(gemfireHome + "/lib/pulse.war").isFile()) {
            return gemfireHome + "/lib/pulse.war";
        }
        return null;
    }

    private String getGemFireAPIWarLocation(String gemfireHome) {
        assert (!StringUtils.isBlank(gemfireHome)) : "The GEMFIRE environment variable must be set!";
        if (new File(gemfireHome + "/tools/Extensions/gemfire-api.war").isFile()) {
            return gemfireHome + "/tools/Extensions/gemfire-api.war";
        }
        if (new File(gemfireHome + "/lib/gemfire-api.war").isFile()) {
            return gemfireHome + "/lib/gemfire-api.war";
        }
        return null;
    }

    private boolean isRunningInTomcat() {
        return System.getProperty("catalina.base") != null || System.getProperty("catalina.home") != null;
    }

    private boolean isWebApplicationAvailable(String warFileLocation) {
        return !StringUtils.isBlank(warFileLocation);
    }

    private boolean isWebApplicationAvailable(String ... warFileLocations) {
        for (String warFileLocation : warFileLocations) {
            if (!this.isWebApplicationAvailable(warFileLocation)) continue;
            return true;
        }
        return false;
    }

    private void setStatusMessage(ManagerMXBean mBean, String message) {
        mBean.setPulseURL("");
        mBean.setStatusMessage(message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void stopHttpService() {
        if (this.httpServer != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Stopping the HTTP service...");
            }
            this.httpServer.stop();
            try {
                this.httpServer.destroy();
            }
            catch (Exception ignore) {
                logger.error("Failed to properly release resources held by the HTTP service: {}", ignore.getMessage(), ignore);
            }
            finally {
                this.httpServer = null;
                System.clearProperty("catalina.base");
                System.clearProperty("catalina.home");
            }
            catch (Exception e) {
                try {
                    logger.warn("Failed to stop the HTTP service because: {}", e.getMessage(), e);
                }
                catch (Throwable throwable) {
                    try {
                        this.httpServer.destroy();
                    }
                    catch (Exception ignore) {
                        logger.error("Failed to properly release resources held by the HTTP service: {}", ignore.getMessage(), ignore);
                    }
                    finally {
                        this.httpServer = null;
                        System.clearProperty("catalina.base");
                        System.clearProperty("catalina.home");
                    }
                    throw throwable;
                }
                try {
                    this.httpServer.destroy();
                }
                catch (Exception ignore) {
                    logger.error("Failed to properly release resources held by the HTTP service: {}", ignore.getMessage(), ignore);
                }
                finally {
                    this.httpServer = null;
                    System.clearProperty("catalina.base");
                    System.clearProperty("catalina.home");
                }
            }
        }
    }

    private void configureAndStart() throws IOException {
        String accessFile;
        InetAddress bindAddr;
        String hostname;
        int port = this.config.getJmxManagerPort();
        if (this.config.getJmxManagerBindAddress().equals("")) {
            hostname = SocketCreator.getLocalHost().getHostName();
            bindAddr = null;
        } else {
            hostname = this.config.getJmxManagerBindAddress();
            bindAddr = InetAddress.getByName(hostname);
        }
        boolean ssl = this.config.getJmxManagerSSLEnabled();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting jmx manager agent on port {}{}", port, (bindAddr != null ? " bound to " + bindAddr : "") + (ssl ? " using SSL" : ""));
        }
        SocketCreator sc = SocketCreator.createNonDefaultInstance(ssl, this.config.getJmxManagerSSLRequireAuthentication(), this.config.getJmxManagerSSLProtocols(), this.config.getJmxManagerSSLCiphers(), this.config.getJmxSSLProperties());
        SslRMIClientSocketFactory csf = ssl ? new SslRMIClientSocketFactory() : null;
        GemFireRMIServerSocketFactory ssf = new GemFireRMIServerSocketFactory(sc, bindAddr);
        System.setProperty("sun.rmi.dgc.server.gcInterval", Long.toString(0x7FFFFFFFFFFFFFFEL));
        this.registry = LocateRegistry.createRegistry(port, csf, ssf);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        HashMap<String, String> env = new HashMap<String, String>();
        String pwFile = this.config.getJmxManagerPasswordFile();
        if (pwFile != null && pwFile.length() > 0) {
            env.put("jmx.remote.x.password.file", pwFile);
        }
        if ((accessFile = this.config.getJmxManagerAccessFile()) != null && accessFile.length() > 0) {
            ReadOpFileAccessController controller = new ReadOpFileAccessController(accessFile);
            controller.setMBeanServer(mbs);
            mbs = controller;
        }
        final RMIJRMPServerImpl stub = new RMIJRMPServerImpl(port, csf, ssf, env);
        final JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + hostname + ":" + port + "/jndi/rmi://" + hostname + ":" + port + "/jmxrmi");
        this.cs = new RMIConnectorServer(new JMXServiceURL("rmi", hostname, port), env, stub, mbs){

            @Override
            public JMXServiceURL getAddress() {
                return url;
            }

            @Override
            public synchronized void start() throws IOException {
                try {
                    ManagementAgent.this.registry.bind("jmxrmi", stub);
                }
                catch (AlreadyBoundException x) {
                    IOException io = new IOException(x.getMessage());
                    io.initCause(x);
                    throw io;
                }
                super.start();
            }
        };
        this.cs.start();
        if (logger.isDebugEnabled()) {
            logger.debug("Finished starting jmx manager agent.");
        }
    }

    private static class GemFireRMIServerSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        private static final long serialVersionUID = -811909050641332716L;
        private transient SocketCreator sc;
        private final InetAddress bindAddr;

        public GemFireRMIServerSocketFactory(SocketCreator sc, InetAddress bindAddr) {
            this.sc = sc;
            this.bindAddr = bindAddr;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.sc.createServerSocket(port, TCPConduit.getBackLog(), this.bindAddr);
        }
    }

    private static class GemFireRMIClientSocketFactory
    implements RMIClientSocketFactory,
    Serializable {
        private static final long serialVersionUID = -7604285019188827617L;
        private transient SocketCreator sc;

        public GemFireRMIClientSocketFactory(SocketCreator sc) {
            this.sc = sc;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.sc.connectForClient(host, port, 0);
        }
    }
}

