/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.management.internal.MBeanProxyFactory;
import com.gemstone.gemfire.management.internal.NotificationHubClient;
import com.gemstone.gemfire.management.internal.NotificationKey;
import javax.management.Notification;

public class NotificationCacheListener
implements CacheListener<NotificationKey, Notification> {
    private NotificationHubClient notifClient;
    private volatile boolean readyForEvents;

    public NotificationCacheListener(MBeanProxyFactory proxyHelper) {
        this.notifClient = new NotificationHubClient(proxyHelper);
        this.readyForEvents = false;
    }

    @Override
    public void afterCreate(EntryEvent<NotificationKey, Notification> event) {
        if (!this.readyForEvents) {
            return;
        }
        this.notifClient.sendNotification(event);
    }

    @Override
    public void afterDestroy(EntryEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterInvalidate(EntryEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionClear(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionCreate(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionDestroy(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionInvalidate(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterRegionLive(RegionEvent<NotificationKey, Notification> event) {
    }

    @Override
    public void afterUpdate(EntryEvent<NotificationKey, Notification> event) {
        if (!this.readyForEvents) {
            return;
        }
        this.notifClient.sendNotification(event);
    }

    @Override
    public void close() {
    }

    public void markReady() {
        this.readyForEvents = true;
    }
}

