/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal;

import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.management.ManagementException;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.ManagementResourceRepo;
import com.gemstone.gemfire.management.internal.NotificationKey;
import java.util.HashMap;
import java.util.Map;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;

public class NotificationHub {
    private LogWriterI18n logger;
    protected ManagementResourceRepo repo;
    private MBeanServer mbeanServer = MBeanJMXAdapter.mbeanServer;
    private Map<ObjectName, NotificationHubListener> listenerObjectMap;
    private String memberSource;

    public NotificationHub(ManagementResourceRepo repo) {
        this.repo = repo;
        this.logger = InternalDistributedSystem.getLoggerI18n();
        this.listenerObjectMap = new HashMap<ObjectName, NotificationHubListener>();
        this.memberSource = MBeanJMXAdapter.getMemberNameOrId(InternalDistributedSystem.getConnectedInstance().getDistributedMember());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHubNotificationListener(String memberName, ObjectName objectName) {
        try {
            Map<ObjectName, NotificationHubListener> map = this.listenerObjectMap;
            synchronized (map) {
                NotificationHubListener listener = this.listenerObjectMap.get(objectName);
                if (listener == null) {
                    listener = new NotificationHubListener(objectName);
                    listener.incNumCounter();
                    this.mbeanServer.addNotificationListener(objectName, listener, null, null);
                    this.listenerObjectMap.put(objectName, listener);
                } else {
                    listener.incNumCounter();
                }
            }
        }
        catch (InstanceNotFoundException e) {
            throw new ManagementException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHubNotificationListener(String memberName, ObjectName objectName) {
        try {
            Map<ObjectName, NotificationHubListener> map = this.listenerObjectMap;
            synchronized (map) {
                NotificationHubListener listener;
                if (this.listenerObjectMap.get(objectName) != null && (listener = this.listenerObjectMap.get(objectName)).decNumCounter() == 0) {
                    this.listenerObjectMap.remove(objectName);
                    this.mbeanServer.removeNotificationListener(objectName, listener);
                }
            }
        }
        catch (ListenerNotFoundException e) {
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanUpListeners() {
        Map<ObjectName, NotificationHubListener> map = this.listenerObjectMap;
        synchronized (map) {
            for (ObjectName objectName : this.listenerObjectMap.keySet()) {
                NotificationHubListener listener = this.listenerObjectMap.get(objectName);
                if (listener == null) continue;
                try {
                    this.mbeanServer.removeNotificationListener(objectName, listener);
                }
                catch (ListenerNotFoundException e) {
                }
                catch (InstanceNotFoundException e) {}
            }
        }
        this.listenerObjectMap.clear();
    }

    public Map<ObjectName, NotificationHubListener> getListenerObjectMap() {
        return this.listenerObjectMap;
    }

    public class NotificationHubListener
    implements NotificationListener {
        private ObjectName name;
        private int numCounter = 0;

        protected NotificationHubListener(ObjectName name) {
            this.name = name;
        }

        public int incNumCounter() {
            return ++this.numCounter;
        }

        public int decNumCounter() {
            return --this.numCounter;
        }

        public int getNumCounter() {
            return this.numCounter;
        }

        @Override
        public void handleNotification(Notification notification, Object handback) {
            NotificationKey key2 = new NotificationKey(this.name);
            notification.setUserData(NotificationHub.this.memberSource);
            NotificationHub.this.repo.putEntryInLocalNotificationRegion(key2, notification);
        }
    }
}

