/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.query.CqClosedException;
import com.gemstone.gemfire.cache.query.CqException;
import com.gemstone.gemfire.cache.query.CqQuery;
import com.gemstone.gemfire.cache.query.Index;
import com.gemstone.gemfire.cache.query.QueryService;
import com.gemstone.gemfire.cache.query.RegionNotFoundException;
import com.gemstone.gemfire.cache.query.internal.CqQueryImpl;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.cache.server.CacheServer;
import com.gemstone.gemfire.cache.server.ServerLoad;
import com.gemstone.gemfire.cache.server.ServerLoadProbe;
import com.gemstone.gemfire.cache.server.internal.ServerMetricsImpl;
import com.gemstone.gemfire.cache.util.BridgeMembershipListener;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.internal.admin.ClientHealthMonitoringRegion;
import com.gemstone.gemfire.internal.admin.remote.ClientHealthStats;
import com.gemstone.gemfire.internal.cache.BridgeServerImpl;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.ha.HARegionQueue;
import com.gemstone.gemfire.internal.cache.tier.InternalBridgeMembership;
import com.gemstone.gemfire.internal.cache.tier.sockets.AcceptorImpl;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.internal.cache.tier.sockets.ClientProxyMembershipID;
import com.gemstone.gemfire.internal.cache.tier.sockets.ServerConnection;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.process.PidUnavailableException;
import com.gemstone.gemfire.internal.process.ProcessUtils;
import com.gemstone.gemfire.management.ClientHealthStatus;
import com.gemstone.gemfire.management.ClientQueueDetail;
import com.gemstone.gemfire.management.ServerLoadData;
import com.gemstone.gemfire.management.internal.ManagementConstants;
import com.gemstone.gemfire.management.internal.beans.MemberMBeanBridge;
import com.gemstone.gemfire.management.internal.beans.ServerBridge;
import com.gemstone.gemfire.management.internal.beans.stats.StatType;
import com.gemstone.gemfire.management.internal.beans.stats.StatsAverageLatency;
import com.gemstone.gemfire.management.internal.beans.stats.StatsRate;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class CacheServerBridge
extends ServerBridge {
    private static final Logger logger = LogService.getLogger();
    private CacheServer cacheServer;
    private GemFireCacheImpl cache;
    private QueryService qs;
    private StatsRate clientNotificationRate;
    private StatsAverageLatency clientNotificatioAvgLatency;
    protected StatsRate queryRequestRate;
    private MemberMBeanBridge memberMBeanBridge;
    private BridgeMembershipListener membershipListener;
    public static ThreadLocal<Version> clientVersion = new ThreadLocal();

    protected static int identifyPid() {
        try {
            return ProcessUtils.identifyPid();
        }
        catch (PidUnavailableException e) {
            if (logger.isDebugEnabled()) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
    }

    public CacheServerBridge(CacheServer cacheServer, GemFireCacheImpl cache) {
        super(cacheServer);
        this.cacheServer = cacheServer;
        this.cache = cache;
        this.qs = cache.getQueryService();
        this.initializeCacheServerStats();
    }

    public CacheServerBridge() {
        this.initializeCacheServerStats();
    }

    public void setMemberMBeanBridge(MemberMBeanBridge memberMBeanBridge) {
        this.memberMBeanBridge = memberMBeanBridge;
    }

    @Override
    public void stopMonitor() {
        super.stopMonitor();
        this.monitor.stopListener();
    }

    private void initializeCacheServerStats() {
        this.clientNotificationRate = new StatsRate("clientNotificationRequests", StatType.INT_TYPE, this.monitor);
        this.clientNotificatioAvgLatency = new StatsAverageLatency("clientNotificationRequests", StatType.INT_TYPE, "processClientNotificationTime", this.monitor);
        this.queryRequestRate = new StatsRate("queryRequests", StatType.INT_TYPE, this.monitor);
    }

    public int getSocketBufferSize() {
        return this.cacheServer.getSocketBufferSize();
    }

    public boolean getTcpNoDelay() {
        return this.cacheServer.getTcpNoDelay();
    }

    public int getPort() {
        return this.cacheServer.getPort();
    }

    public int getCapacity() {
        if (this.cacheServer.getClientSubscriptionConfig() != null) {
            return this.cacheServer.getClientSubscriptionConfig().getCapacity();
        }
        return 0;
    }

    public String getDiskStoreName() {
        if (this.cacheServer.getClientSubscriptionConfig() != null) {
            return this.cacheServer.getClientSubscriptionConfig().getDiskStoreName();
        }
        return null;
    }

    public int getMaxConnections() {
        return this.cacheServer.getMaxConnections();
    }

    public long getLoadPollInterval() {
        return this.cacheServer.getLoadPollInterval();
    }

    public ServerLoadData fetchLoadProbe() {
        ServerLoadProbe probe = this.cacheServer.getLoadProbe();
        ServerLoad load = probe.getLoad(new ServerMetricsImpl(this.cacheServer.getMaxConnections()));
        ServerLoadData data = new ServerLoadData(load.getConnectionLoad(), load.getSubscriptionConnectionLoad(), load.getLoadPerConnection(), load.getLoadPerSubscriptionConnection());
        return data;
    }

    public int getMaxThreads() {
        return this.cacheServer.getMaxThreads();
    }

    public int getMaximumMessageCount() {
        return this.cacheServer.getMaximumMessageCount();
    }

    public int getMaximumTimeBetweenPings() {
        return this.cacheServer.getMaximumTimeBetweenPings();
    }

    public int getMessageTimeToLive() {
        return this.cacheServer.getMessageTimeToLive();
    }

    public boolean isRunning() {
        return this.cacheServer.isRunning();
    }

    public String getEvictionPolicy() {
        if (this.cacheServer.getClientSubscriptionConfig() != null) {
            return this.cacheServer.getClientSubscriptionConfig().getEvictionPolicy();
        }
        return null;
    }

    public String getHostnameForClients() {
        return this.cacheServer.getHostnameForClients();
    }

    public String getBindAddress() {
        return this.cacheServer.getBindAddress();
    }

    public String[] getContinuousQueryList() {
        CqQuery[] allCqs;
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null && (allCqs = cqService.getAllCqs()) != null && allCqs.length > 0) {
            String[] allCqStr = new String[allCqs.length];
            for (int i = 0; i < allCqs.length; ++i) {
                allCqStr[i] = allCqs[i].getName();
            }
            return allCqStr;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public long getRegisteredCQCount() {
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null) {
            CqQuery[] allCqs = cqService.getAllCqs();
            return allCqs != null && allCqs.length > 0 ? (long)allCqs.length : 0L;
        }
        return 0L;
    }

    public String[] getIndexList() {
        Collection<Index> idxs = this.qs.getIndexes();
        if (!idxs.isEmpty()) {
            Iterator<Index> idx = idxs.iterator();
            String[] indexList = new String[idxs.size()];
            int i = 0;
            while (idx.hasNext()) {
                Index index2 = idx.next();
                indexList[i] = index2.getName();
                ++i;
            }
            return indexList;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    public String[] listClientIds() throws Exception {
        String[] allConnectedClientStr = null;
        Map<String, ClientConnInfo> uniqueIds = this.getUniqueClientIds();
        if (uniqueIds.size() > 0) {
            allConnectedClientStr = new String[uniqueIds.size()];
            int j = 0;
            Iterator<String> i$ = uniqueIds.keySet().iterator();
            while (i$.hasNext()) {
                String clientId;
                allConnectedClientStr[j] = clientId = i$.next();
                ++j;
            }
            return allConnectedClientStr;
        }
        return new String[0];
    }

    private Map<String, ClientConnInfo> getUniqueClientIds() {
        HashMap<String, ClientConnInfo> uniqueIds = null;
        ServerConnection[] serverConnections = this.acceptor.getAllServerConnectionList();
        Collection<CacheClientProxy> clientProxies = this.acceptor.getCacheClientNotifier().getClientProxies();
        if (clientProxies.size() > 0) {
            uniqueIds = new HashMap<String, ClientConnInfo>();
            for (CacheClientProxy p : clientProxies) {
                ClientConnInfo clientConInfo = new ClientConnInfo(p.getProxyID(), p.getSocketHost(), p.getRemotePort(), p.isPrimary());
                uniqueIds.put(p.getProxyID().getDSMembership(), clientConInfo);
            }
        }
        if (serverConnections != null && serverConnections.length > 0) {
            if (uniqueIds == null) {
                uniqueIds = new HashMap();
            }
            for (ServerConnection conn : serverConnections) {
                ClientProxyMembershipID clientId = conn.getProxyID();
                if (uniqueIds.get(clientId.getDSMembership()) != null) continue;
                ClientConnInfo clientConInfo = new ClientConnInfo(conn.getProxyID(), conn.getSocketHost(), conn.getSocketPort(), false);
                uniqueIds.put(clientId.getDSMembership(), clientConInfo);
            }
        }
        if (uniqueIds == null) {
            return Collections.emptyMap();
        }
        return uniqueIds;
    }

    public Version getClientVersion(ClientConnInfo connInfo) {
        GemFireCacheImpl cache = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        if (cache.getCacheServers().size() == 0) {
            return null;
        }
        BridgeServerImpl server = (BridgeServerImpl)cache.getCacheServers().iterator().next();
        if (server == null) {
            return null;
        }
        AcceptorImpl acceptorImpl = server.getAcceptor();
        if (acceptorImpl == null) {
            return null;
        }
        ServerConnection[] serverConnections = acceptorImpl.getAllServerConnectionList();
        boolean flag = false;
        if (connInfo.toString().contains("primary=true")) {
            flag = true;
        }
        for (ServerConnection conn : serverConnections) {
            ClientProxyMembershipID cliIdFrmProxy = conn.getProxyID();
            ClientConnInfo cci = new ClientConnInfo(conn.getProxyID(), conn.getSocketHost(), conn.getSocketPort(), flag);
            if (!connInfo.toString().equals(cci.toString())) continue;
            return cliIdFrmProxy.getClientVersion();
        }
        ClientProxyMembershipID proxyId = connInfo.getClientId();
        CacheClientProxy proxy = CacheClientNotifier.getInstance().getClientProxy(proxyId);
        if (proxy != null) {
            return proxy.getVersion();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHealthStatus showClientStats(String clientId) throws Exception {
        try {
            ClientHealthStatus status;
            Map<String, ClientConnInfo> uniqueClientIds = this.getUniqueClientIds();
            ClientConnInfo clientConnInfo = uniqueClientIds.get(clientId);
            ClientHealthStatus clientHealthStatus = status = this.getClientHealthStatus(clientConnInfo);
            return clientHealthStatus;
        }
        finally {
            clientVersion.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientHealthStatus[] showAllClientStats() throws Exception {
        try {
            ArrayList<ClientHealthStatus> clientHealthStatusList = null;
            Map<String, ClientConnInfo> uniqueClientIds = this.getUniqueClientIds();
            if (!uniqueClientIds.isEmpty()) {
                clientHealthStatusList = new ArrayList<ClientHealthStatus>();
                for (Map.Entry<String, ClientConnInfo> p : uniqueClientIds.entrySet()) {
                    ClientHealthStatus status = this.getClientHealthStatus(p.getValue());
                    if (status == null) continue;
                    clientHealthStatusList.add(status);
                }
                ClientHealthStatus[] statusArr = new ClientHealthStatus[clientHealthStatusList.size()];
                ClientHealthStatus[] clientHealthStatusArray = clientHealthStatusList.toArray(statusArr);
                return clientHealthStatusArray;
            }
            ClientHealthStatus[] clientHealthStatusArray = new ClientHealthStatus[]{};
            return clientHealthStatusArray;
        }
        finally {
            clientVersion.set(null);
        }
    }

    private ClientHealthStatus getClientHealthStatus(ClientConnInfo connInfo) {
        ClientProxyMembershipID proxyId = connInfo.getClientId();
        CacheClientProxy proxy = CacheClientNotifier.getInstance().getClientProxy(proxyId);
        if (proxy != null && !proxy.isConnected() && !proxyId.isDurable()) {
            return null;
        }
        clientVersion.set(this.getClientVersion(connInfo));
        int clientCQCount = 0;
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null) {
            List<CqQueryImpl> cqs = cqService.getAllClientCqs(proxyId);
            clientCQCount = cqs.size();
        }
        ClientHealthStatus status = new ClientHealthStatus();
        Region clientHealthMonitoringRegion = ClientHealthMonitoringRegion.getInstance(this.cache);
        String clientName = proxyId.getDSMembership();
        status.setClientId(connInfo.toString());
        status.setName(clientName);
        status.setHostName(connInfo.getHostName());
        status.setClientCQCount(clientCQCount);
        if (proxy != null) {
            status.setUpTime(proxy.getUpTime());
            status.setQueueSize(proxy.getQueueSizeStat());
            status.setConnected(proxy.isConnected());
            status.setSubscriptionEnabled(true);
        } else {
            status.setConnected(true);
            status.setSubscriptionEnabled(false);
        }
        ClientHealthStats stats = (ClientHealthStats)clientHealthMonitoringRegion.get(clientName);
        if (stats != null) {
            status.setCpus(stats.getCpus());
            status.setNumOfCacheListenerCalls(stats.getNumOfCacheListenerCalls());
            status.setNumOfGets(stats.getNumOfGets());
            status.setNumOfMisses(stats.getNumOfMisses());
            status.setNumOfPuts(stats.getNumOfPuts());
            status.setNumOfThreads(stats.getNumOfThreads());
            status.setProcessCpuTime(stats.getProcessCpuTime());
            status.setPoolStats(stats.getPoolStats());
        }
        return status;
    }

    public void closeContinuousQuery(String queryName) throws Exception {
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null) {
            CqQuery[] allCqs;
            for (CqQuery query : allCqs = cqService.getAllCqs()) {
                if (!query.getName().equals(queryName)) continue;
                try {
                    query.close();
                    return;
                }
                catch (CqClosedException e) {
                    throw new Exception(e.getMessage());
                }
                catch (CqException e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
    }

    public void executeContinuousQuery(String queryName) throws Exception {
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null) {
            CqQuery[] allCqs;
            for (CqQuery query : allCqs = cqService.getAllCqs()) {
                if (!query.getName().equals(queryName)) continue;
                try {
                    query.execute();
                    return;
                }
                catch (CqClosedException e) {
                    throw new Exception(e.getMessage());
                }
                catch (CqException e) {
                    throw new Exception(e.getMessage());
                }
                catch (RegionNotFoundException e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
    }

    public void stopContinuousQuery(String queryName) throws Exception {
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null) {
            CqQuery[] allCqs;
            for (CqQuery query : allCqs = cqService.getAllCqs()) {
                if (!query.getName().equals(queryName)) continue;
                try {
                    query.stop();
                    return;
                }
                catch (CqClosedException e) {
                    throw new Exception(e.getMessage());
                }
                catch (CqException e) {
                    throw new Exception(e.getMessage());
                }
            }
        }
    }

    public void removeIndex(String indexName) throws Exception {
        try {
            Iterator<Index> idx;
            Collection<Index> idxs = this.qs.getIndexes();
            if (!idxs.isEmpty() && (idx = idxs.iterator()).hasNext()) {
                Index index2 = idx.next();
                if (index2.getName().equals(indexName)) {
                    this.qs.removeIndex(index2);
                }
                return;
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    public int getIndexCount() {
        return this.qs.getIndexes().size();
    }

    public int getNumClientNotificationRequests() {
        return this.getStatistic("clientNotificationRequests").intValue();
    }

    public long getClientNotificationAvgLatency() {
        return this.clientNotificatioAvgLatency.getAverageLatency();
    }

    public float getClientNotificationRate() {
        return this.clientNotificationRate.getRate();
    }

    public float getQueryRequestRate() {
        return this.queryRequestRate.getRate();
    }

    public long getTotalIndexMaintenanceTime() {
        return this.memberMBeanBridge.getTotalIndexMaintenanceTime();
    }

    public long getActiveCQCount() {
        CqService cqService = CqService.getRunningCqService();
        if (cqService != null) {
            return cqService.getCqStatistics().numCqsActive();
        }
        return 0L;
    }

    public int getNumSubscriptions() {
        Map clientProxyMembershipIDMap = InternalBridgeMembership.getClientQueueSizes();
        return clientProxyMembershipIDMap.keySet().size();
    }

    public void setBridgeMembershipListener(BridgeMembershipListener membershipListener) {
        this.membershipListener = membershipListener;
    }

    public BridgeMembershipListener getBridgeMembershipListener() {
        return this.membershipListener;
    }

    public ClientQueueDetail[] getClientQueueDetails() throws Exception {
        ArrayList<ClientQueueDetail> clientQueueDetailList = null;
        try {
            if (this.acceptor != null && this.acceptor.getCacheClientNotifier() != null) {
                Collection<CacheClientProxy> clientProxies = this.acceptor.getCacheClientNotifier().getClientProxies();
                if (clientProxies.size() <= 0) {
                    return new ClientQueueDetail[0];
                }
                clientQueueDetailList = new ArrayList<ClientQueueDetail>();
                for (CacheClientProxy p : clientProxies) {
                    ClientQueueDetail status = this.getClientQueueDetail(p);
                    if (status == null) continue;
                    clientQueueDetailList.add(status);
                }
                ClientQueueDetail[] queueDetailArr = new ClientQueueDetail[clientQueueDetailList.size()];
                return clientQueueDetailList.toArray(queueDetailArr);
            }
            return new ClientQueueDetail[0];
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
    }

    private ClientQueueDetail getClientQueueDetail(CacheClientProxy p) {
        ClientQueueDetail queueDetail = new ClientQueueDetail();
        ClientProxyMembershipID proxyID = p.getProxyID();
        if (!p.isConnected() && !proxyID.isDurable()) {
            return null;
        }
        queueDetail.setClientId(CliUtil.getClientIdFromCacheClientProxy(p));
        HARegionQueue queue = p.getHARegionQueue();
        if (queue == null) {
            return queueDetail;
        }
        queueDetail.setQueueSize(p.getQueueSizeStat());
        queueDetail.setEventsConflated(queue.getStatistics().getEventsConflated());
        queueDetail.setEventsEnqued(queue.getStatistics().getEventsEnqued());
        queueDetail.setEventsExpired(queue.getStatistics().getEventsExpired());
        queueDetail.setEventsRemoved(queue.getStatistics().getEventsRemoved());
        queueDetail.setEventsRemovedByQrm(queue.getStatistics().getEventsRemovedByQrm());
        queueDetail.setEventsTaken(queue.getStatistics().getEventsTaken());
        queueDetail.setMarkerEventsConflated(queue.getStatistics().getMarkerEventsConflated());
        queueDetail.setNumVoidRemovals(queue.getStatistics().getNumVoidRemovals());
        return queueDetail;
    }

    public ClientQueueDetail getClientQueueDetail(String clientId) throws Exception {
        try {
            if (this.acceptor != null && this.acceptor.getCacheClientNotifier() != null) {
                Collection<CacheClientProxy> clientProxies = this.acceptor.getCacheClientNotifier().getClientProxies();
                for (CacheClientProxy p : clientProxies) {
                    String buffer = CliUtil.getClientIdFromCacheClientProxy(p);
                    if (!buffer.equals(clientId)) continue;
                    ClientQueueDetail queueDetail = this.getClientQueueDetail(p);
                    return queueDetail;
                }
            }
        }
        catch (Exception e) {
            throw new Exception(e.getMessage());
        }
        return null;
    }

    private static class ClientConnInfo {
        private ClientProxyMembershipID clientId;
        private String hostName;
        private int port;
        boolean isPrimary;

        public ClientConnInfo(ClientProxyMembershipID clientId, String hostName, int port, boolean isPrimary) {
            this.clientId = clientId;
            this.hostName = hostName;
            this.port = port;
            this.isPrimary = isPrimary;
        }

        public String getHostName() {
            return this.hostName;
        }

        public ClientProxyMembershipID getClientId() {
            return this.clientId;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("[").append(this.clientId).append("; port=").append(this.port).append("; primary=").append(this.isPrimary).append("]");
            return buffer.toString();
        }
    }
}

