/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans.stats;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.Statistics;
import com.gemstone.gemfire.internal.statistics.StatisticId;
import com.gemstone.gemfire.internal.statistics.StatisticNotFoundException;
import com.gemstone.gemfire.internal.statistics.StatisticsListener;
import com.gemstone.gemfire.internal.statistics.StatisticsNotification;
import com.gemstone.gemfire.internal.statistics.ValueMonitor;
import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;
import java.util.HashMap;
import java.util.Map;

public class AggregateRegionStatsMonitor
extends MBeanStatsMonitor {
    private volatile int primaryBucketCount = 0;
    private volatile int bucketCount = 0;
    private volatile int totalBucketSize = 0;
    private volatile long lruDestroys = 0L;
    private volatile long lruEvictions = 0L;
    private volatile long diskSpace = 0L;
    private Map<Statistics, ValueMonitor> monitors = new HashMap<Statistics, ValueMonitor>();
    private Map<Statistics, MemberLevelRegionStatisticsListener> listeners = new HashMap<Statistics, MemberLevelRegionStatisticsListener>();

    public AggregateRegionStatsMonitor(String name) {
        super(name);
    }

    @Override
    public void addStatisticsToMonitor(Statistics stats) {
        ValueMonitor regionMonitor = new ValueMonitor();
        MemberLevelRegionStatisticsListener listener = new MemberLevelRegionStatisticsListener();
        regionMonitor.addListener(listener);
        regionMonitor.addStatistics(stats);
        this.monitors.put(stats, regionMonitor);
        this.listeners.put(stats, listener);
    }

    public void removePartitionStatistics(Statistics stats) {
        MemberLevelRegionStatisticsListener listener = this.removeListener(stats);
        if (listener != null) {
            listener.decreaseParStats(stats);
        }
    }

    public void removeLRUStatistics(Statistics stats) {
        this.removeListener(stats);
    }

    public void removeDirectoryStatistics(Statistics stats) {
        this.removeListener(stats);
    }

    @Override
    public void stopListener() {
        for (Statistics stat : this.listeners.keySet()) {
            ValueMonitor monitor = this.monitors.get(stat);
            monitor.removeListener(this.listeners.get(stat));
            monitor.removeStatistics(stat);
        }
        this.listeners.clear();
        this.monitors.clear();
    }

    private MemberLevelRegionStatisticsListener removeListener(Statistics stats) {
        MemberLevelRegionStatisticsListener listener;
        ValueMonitor monitor = this.monitors.remove(stats);
        if (monitor != null) {
            monitor.removeStatistics(stats);
        }
        if ((listener = this.listeners.remove(stats)) != null) {
            monitor.removeListener(listener);
        }
        return listener;
    }

    @Override
    public Number getStatistic(String name) {
        if (name.equals("lruEvictions")) {
            return this.getLruEvictions();
        }
        if (name.equals("lruDestroys")) {
            return this.getLruDestroys();
        }
        if (name.equals("primaryBucketCount")) {
            return this.getTotalPrimaryBucketCount();
        }
        if (name.equals("bucketCount")) {
            return this.getTotalBucketCount();
        }
        if (name.equals("dataStoreEntryCount")) {
            return this.getTotalBucketSize();
        }
        if (name.equals("diskSpace")) {
            return this.getDiskSpace();
        }
        return 0;
    }

    private Number computeDelta(MBeanStatsMonitor.DefaultHashMap statsMap, String name, Number currentValue) {
        if (name.equals("primaryBucketCount")) {
            Integer prevValue = statsMap.get("primaryBucketCount").intValue();
            Integer deltaValue = currentValue.intValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("bucketCount")) {
            Integer prevValue = statsMap.get("bucketCount").intValue();
            Integer deltaValue = currentValue.intValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("dataStoreEntryCount")) {
            Integer prevValue = statsMap.get("dataStoreEntryCount").intValue();
            Integer deltaValue = currentValue.intValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("lruEvictions")) {
            Long prevValue = statsMap.get("lruEvictions").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("lruDestroys")) {
            Long prevValue = statsMap.get("lruDestroys").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        if (name.equals("diskSpace")) {
            Long prevValue = statsMap.get("diskSpace").longValue();
            Long deltaValue = currentValue.longValue() - prevValue;
            return deltaValue;
        }
        return 0;
    }

    private void increaseStats(String name, Number value2) {
        if (name.equals("primaryBucketCount")) {
            this.primaryBucketCount += value2.intValue();
            return;
        }
        if (name.equals("bucketCount")) {
            this.bucketCount += value2.intValue();
            return;
        }
        if (name.equals("dataStoreEntryCount")) {
            this.totalBucketSize += value2.intValue();
            return;
        }
        if (name.equals("lruEvictions")) {
            this.lruEvictions += value2.longValue();
            return;
        }
        if (name.equals("lruDestroys")) {
            this.lruDestroys += value2.longValue();
            return;
        }
        if (name.equals("diskSpace")) {
            this.diskSpace += value2.longValue();
            return;
        }
    }

    public int getTotalPrimaryBucketCount() {
        return this.primaryBucketCount;
    }

    public int getTotalBucketCount() {
        return this.bucketCount;
    }

    public int getTotalBucketSize() {
        return this.totalBucketSize;
    }

    public long getLruDestroys() {
        return this.lruDestroys;
    }

    public long getLruEvictions() {
        return this.lruEvictions;
    }

    public long getDiskSpace() {
        return this.diskSpace;
    }

    @Override
    public void removeStatisticsFromMonitor(Statistics stats) {
    }

    private class MemberLevelRegionStatisticsListener
    implements StatisticsListener {
        MBeanStatsMonitor.DefaultHashMap statsMap = new MBeanStatsMonitor.DefaultHashMap();
        private boolean removed = false;

        private MemberLevelRegionStatisticsListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(StatisticsNotification notification) {
            MBeanStatsMonitor.DefaultHashMap defaultHashMap = this.statsMap;
            synchronized (defaultHashMap) {
                if (this.removed) {
                    return;
                }
                for (StatisticId statId : notification) {
                    Number value2;
                    StatisticDescriptor descriptor = statId.getStatisticDescriptor();
                    String name = descriptor.getName();
                    try {
                        value2 = notification.getValue(statId);
                    }
                    catch (StatisticNotFoundException e) {
                        value2 = 0;
                    }
                    AggregateRegionStatsMonitor.this.log(name, value2);
                    Number deltaValue = AggregateRegionStatsMonitor.this.computeDelta(this.statsMap, name, value2);
                    this.statsMap.put(name, value2);
                    AggregateRegionStatsMonitor.this.increaseStats(name, deltaValue);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void decreaseParStats(Statistics stats) {
            MBeanStatsMonitor.DefaultHashMap defaultHashMap = this.statsMap;
            synchronized (defaultHashMap) {
                AggregateRegionStatsMonitor.this.primaryBucketCount -= this.statsMap.get("primaryBucketCount").intValue();
                AggregateRegionStatsMonitor.this.bucketCount -= this.statsMap.get("bucketCount").intValue();
                AggregateRegionStatsMonitor.this.totalBucketSize -= this.statsMap.get("dataStoreEntryCount").intValue();
                this.removed = true;
            }
        }
    }
}

