/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans.stats;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.internal.statistics.StatisticId;
import com.gemstone.gemfire.internal.statistics.StatisticNotFoundException;
import com.gemstone.gemfire.internal.statistics.StatisticsNotification;
import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;

public class GCStatsMonitor
extends MBeanStatsMonitor {
    private volatile long collections = 0L;
    private volatile long collectionTime = 0L;

    public GCStatsMonitor(String name) {
        super(name);
    }

    @Override
    public Number getStatistic(String statName) {
        if (statName.equals("collections")) {
            return this.getCollections();
        }
        if (statName.equals("collectionTime")) {
            return this.getCollectionTime();
        }
        return 0;
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        this.decreasePrevValues(this.statsMap);
        for (StatisticId statId : notification) {
            Number value2;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value2 = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value2 = 0;
            }
            this.log(name, value2);
            this.increaseStats(name, value2);
            this.statsMap.put(name, value2);
        }
    }

    private void decreasePrevValues(MBeanStatsMonitor.DefaultHashMap statsMap) {
        this.collections -= (long)statsMap.get("collections").intValue();
        this.collectionTime -= (long)statsMap.get("collectionTime").intValue();
    }

    private void increaseStats(String name, Number value2) {
        if (name.equals("collections")) {
            this.collections += value2.longValue();
            return;
        }
        if (name.equals("collectionTime")) {
            this.collectionTime += value2.longValue();
            return;
        }
    }

    public long getCollections() {
        return this.collections;
    }

    public long getCollectionTime() {
        return this.collectionTime;
    }
}

