/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans.stats;

import com.gemstone.gemfire.management.internal.FederationComponent;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLongArray;

public class LongStatsDeltaAggregator {
    private AtomicLongArray prevCounters;
    private AtomicLongArray currCounters;
    private List<String> keys;

    public LongStatsDeltaAggregator(List<String> keys) {
        this.keys = keys;
        this.prevCounters = new AtomicLongArray(keys.size());
        this.currCounters = new AtomicLongArray(keys.size());
        this.initializeArray(this.currCounters);
    }

    public void aggregate(FederationComponent newState, FederationComponent oldState) {
        this.incData(newState, oldState);
    }

    private void incData(FederationComponent newComp, FederationComponent oldComp) {
        Map<String, Object> oldState;
        Map<String, Object> newState;
        Map<String, Object> map = newState = newComp != null ? newComp.getObjectState() : null;
        if (oldComp != null && oldComp.getOldState().size() > 0) {
            oldState = oldComp.getOldState();
        } else {
            Map<String, Object> map2 = oldState = oldComp != null ? oldComp.getObjectState() : null;
        }
        if (newState != null) {
            for (int index2 = 0; index2 < this.keys.size(); ++index2) {
                Object val;
                this.prevCounters.set(index2, this.currCounters.get(index2));
                Long newVal = (Long)newState.get(this.keys.get(index2));
                if (newVal == null) continue;
                Long oldVal = 0L;
                if (oldState != null && (val = oldState.get(this.keys.get(index2))) != null) {
                    oldVal = (Long)val;
                }
                this.currCounters.addAndGet(index2, newVal - oldVal);
            }
        }
    }

    public long getDelta(String key2) {
        int index2 = this.keys.indexOf(key2);
        if (index2 == -1) {
            return 0L;
        }
        return this.currCounters.get(this.keys.indexOf(key2)) - this.prevCounters.get(this.keys.indexOf(key2));
    }

    private void initializeArray(AtomicLongArray arr) {
        for (int i = 0; i < arr.length(); ++i) {
            arr.set(i, 0L);
        }
    }
}

