/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.beans.stats;

import com.gemstone.gemfire.StatisticDescriptor;
import com.gemstone.gemfire.internal.statistics.StatisticId;
import com.gemstone.gemfire.internal.statistics.StatisticNotFoundException;
import com.gemstone.gemfire.internal.statistics.StatisticsNotification;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.beans.stats.MBeanStatsMonitor;

public final class VMStatsMonitor
extends MBeanStatsMonitor {
    private volatile float cpuUsage = 0.0f;
    private static String processCPUTimeAttr = "ProcessCpuTime";
    private long lastSystemTime = 0L;
    private long lastProcessCpuTime = 0L;
    private boolean processCPUTimeAvailable = MBeanJMXAdapter.isAttributeAvailable(processCPUTimeAttr, "java.lang:type=OperatingSystem");

    public VMStatsMonitor(String name) {
        super(name);
        if (!this.processCPUTimeAvailable) {
            this.cpuUsage = MBeanJMXAdapter.VALUE_NOT_AVAILABLE;
        }
    }

    @Override
    public void handleNotification(StatisticsNotification notification) {
        for (StatisticId statId : notification) {
            Number value2;
            StatisticDescriptor descriptor = statId.getStatisticDescriptor();
            String name = descriptor.getName();
            try {
                value2 = notification.getValue(statId);
            }
            catch (StatisticNotFoundException e) {
                value2 = 0;
            }
            this.log(name, value2);
            this.statsMap.put(name, value2);
        }
        this.refreshStats();
    }

    private void refreshStats() {
        if (this.processCPUTimeAvailable) {
            Number processCpuTime = this.statsMap.get("processCpuTime");
            if (processCpuTime == null) {
                this.cpuUsage = MBeanJMXAdapter.VALUE_NOT_AVAILABLE;
                return;
            }
            if (this.lastSystemTime == 0L) {
                this.lastSystemTime = System.currentTimeMillis();
                return;
            }
            long cpuTime = processCpuTime.longValue();
            if (this.lastProcessCpuTime == 0L) {
                this.lastProcessCpuTime = cpuTime;
                return;
            }
            long systemTime = System.currentTimeMillis();
            long denom = (systemTime - this.lastSystemTime) * 10000L;
            float processCpuUsage = (float)(cpuTime - this.lastProcessCpuTime) / (float)denom;
            this.lastSystemTime = systemTime;
            this.lastProcessCpuTime = cpuTime;
            this.cpuUsage = processCpuUsage;
        }
    }

    public float getCpuUsage() {
        return this.cpuUsage;
    }
}

