/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.commands;

import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.internal.DSFIDFactory;
import com.gemstone.gemfire.internal.lang.Initializer;
import com.gemstone.gemfire.internal.lang.StringUtils;
import com.gemstone.gemfire.internal.lang.SystemUtils;
import com.gemstone.gemfire.internal.util.IOUtils;
import com.gemstone.gemfire.internal.util.PasswordUtil;
import com.gemstone.gemfire.management.cli.CliMetaData;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorRequest;
import com.gemstone.gemfire.management.internal.JmxManagerLocatorResponse;
import com.gemstone.gemfire.management.internal.SSLUtil;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.annotation.CliArgument;
import com.gemstone.gemfire.management.internal.cli.domain.ConnectToLocatorResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.ErrorResultData;
import com.gemstone.gemfire.management.internal.cli.result.InfoResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import com.gemstone.gemfire.management.internal.cli.shell.JMXConnectionException;
import com.gemstone.gemfire.management.internal.cli.shell.JmxOperationInvoker;
import com.gemstone.gemfire.management.internal.cli.shell.OperationInvoker;
import com.gemstone.gemfire.management.internal.cli.shell.jline.GfshHistory;
import com.gemstone.gemfire.management.internal.cli.util.CauseFinder;
import com.gemstone.gemfire.management.internal.cli.util.ConnectionEndpoint;
import com.gemstone.gemfire.management.internal.web.domain.LinkIndex;
import com.gemstone.gemfire.management.internal.web.http.support.SimpleHttpRequester;
import com.gemstone.gemfire.management.internal.web.shell.RestHttpOperationInvoker;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.ConnectIOException;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.ServiceUnavailableException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.shell.core.CommandMarker;
import org.springframework.shell.core.ExitShellRequest;
import org.springframework.shell.core.annotation.CliAvailabilityIndicator;
import org.springframework.shell.core.annotation.CliCommand;
import org.springframework.shell.core.annotation.CliOption;

public class ShellCommands
implements CommandMarker {
    private static final int CONNECT_LOCATOR_TIMEOUT_MS = 60000;

    private Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }

    @CliCommand(value={"exit", "quit"}, help="Exit GFSH and return control back to the calling process.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public ExitShellRequest exit() throws IOException {
        Gfsh gfshInstance = this.getGfsh();
        gfshInstance.stop();
        ExitShellRequest exitShellRequest = gfshInstance.getExitShellRequest();
        if (exitShellRequest == null) {
            exitShellRequest = ExitShellRequest.NORMAL_EXIT;
        }
        return exitShellRequest;
    }

    public static int getConnectLocatorTimeoutInMS() {
        return 60000;
    }

    @CliCommand(value={"connect"}, help="Connect to a jmx-manager either directly or via a Locator. If connecting via a Locator, and a jmx-manager doesn't already exist, the Locator will start one.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX", "Manager"})
    public Result connect(@CliOption(key={"locator"}, unspecifiedDefaultValue="localhost[10334]", optionContext="__locator__", help="Network address of the Locator in the form: host[port].") ConnectionEndpoint locatorTcpHostPort, @CliOption(key={"jmx-manager"}, unspecifiedDefaultValue="__NULL__", optionContext="__jmx-manager__", help="Network address of the jmx-manager in the form: host[port].") ConnectionEndpoint memberRmiHostPort, @CliOption(key={"use-http"}, mandatory=false, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Connects to Manager by sending HTTP requests to HTTP service hostint the Management REST API.  You must first 'disconnect' in order to reconnect to the Manager via locator or jmx-manager using JMX.") boolean useHttp, @CliOption(key={"url"}, mandatory=false, unspecifiedDefaultValue="http://localhost:7070/gemfire/v1", help="Indicates the base URL to the Manager's HTTP service.  For example: 'http://<host>:<port>/gemfire/v1' Default is 'http://localhost:7070/gemfire/v1'") String url, @CliOption(key={"user"}, unspecifiedDefaultValue="__NULL__", help="User name to securely connect to the jmx-manager. If the --password parameter is not specified then it will be prompted for.") String userName, @CliOption(key={"password"}, unspecifiedDefaultValue="__NULL__", help="Password to securely connect to the jmx-manager.") String password, @CliOption(key={"key-store"}, unspecifiedDefaultValue="__NULL__", help="Java keystore file containing this application's certificate and private key. If the --key-store-password parameter is not specified then it will be prompted for.") String keystore, @CliOption(key={"key-store-password"}, unspecifiedDefaultValue="__NULL__", help="Password to access the private key from the keystore file specified by --key-store.") String keystorePassword, @CliOption(key={"trust-store"}, unspecifiedDefaultValue="__NULL__", help="Java keystore file containing the collection of CA certificates trusted by this application. If the --trust-store-password parameter is not specified then it will be prompted for.") String truststore, @CliOption(key={"trust-store-password"}, unspecifiedDefaultValue="__NULL__", help="Password to unlock the keystore file specified by --trust-store") String truststorePassword, @CliOption(key={"ciphers"}, unspecifiedDefaultValue="__NULL__", help="SSL/TLS ciphers used when encrypting the connection. The default is \"any\".") String sslCiphers, @CliOption(key={"protocols"}, unspecifiedDefaultValue="__NULL__", help="SSL/TLS protocol versions to enable when encrypting the connection. The default is \"any\".") String sslProtocols, @CliOption(key={"security-properties-file"}, optionContext="converter.hint.file.path.string", unspecifiedDefaultValue="__NULL__", help="The gfsecurity.properties file for configuring gfsh to connect to the Locator/Manager. The file's path can be absolute or relative to gfsh directory.") String gfSecurityPropertiesPath, @CliOption(key={"use-ssl"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to use SSL for communication with Locator and/or JMX Manager. If set to \"true\", will also read \"gfsecurity.properties\". SSL Options take precedence over proeprties file. If none are specified, defaults will be used. The default value for this options is \"false\".") boolean useSsl) {
        Result result;
        String passwordToUse = password;
        String keystoreToUse = keystore;
        String keystorePasswordToUse = keystorePassword;
        String truststoreToUse = truststore;
        String truststorePasswordToUse = truststorePassword;
        String sslCiphersToUse = sslCiphers;
        String sslProtocolsToUse = sslProtocols;
        if (this.getGfsh() != null && this.getGfsh().isConnectedAndReady()) {
            try {
                result = ResultBuilder.createInfoResult("Already connected to: " + this.getGfsh().getOperationInvoker().toString());
            }
            catch (Exception e) {
                result = ResultBuilder.buildResult(ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage()));
            }
        } else if (useHttp) {
            try {
                Map<String, String> sslConfigProps = this.readSSLConfiguration(useSsl, keystoreToUse, keystorePasswordToUse, truststoreToUse, truststorePasswordToUse, sslCiphersToUse, sslProtocolsToUse, gfSecurityPropertiesPath);
                if (useSsl) {
                    this.configureHttpsURLConnection(sslConfigProps);
                    if (url.startsWith("http:")) {
                        url = url.replace("http:", "https:");
                    }
                }
                LogWrapper.getInstance().warning(String.format("Sending HTTP request for Link Index at (%1$s)...", url.concat("/index")));
                LinkIndex linkIndex = (LinkIndex)new SimpleHttpRequester(60000).get(url.concat("/index"), LinkIndex.class, new Object[0]);
                LogWrapper.getInstance().warning(String.format("Received Link Index (%1$s)", linkIndex.toString()));
                Gfsh gemfireShell = this.getGfsh();
                RestHttpOperationInvoker operationInvoker = new RestHttpOperationInvoker(linkIndex, gemfireShell, url);
                Initializer.init(operationInvoker);
                gemfireShell.setOperationInvoker((OperationInvoker)operationInvoker);
                LogWrapper.getInstance().info(CliStrings.format("Successfully connected to: {0}", (Object)operationInvoker.toString()));
                Gfsh.redirectInternalJavaLoggers();
                result = ResultBuilder.createInfoResult(CliStrings.format("Successfully connected to: {0}", (Object)operationInvoker.toString()));
            }
            catch (IOException ioe) {
                String errorMessage = ioe.getMessage();
                result = ResultBuilder.createConnectionErrorResult(errorMessage);
                ioe.printStackTrace();
            }
            catch (Exception e) {
                String errorMessage = e.getMessage();
                result = ResultBuilder.createConnectionErrorResult(errorMessage);
                e.printStackTrace();
            }
        } else {
            boolean isConnectingViaLocator = false;
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            ConnectionEndpoint hostPortToConnect = null;
            try {
                Gfsh gfshInstance = this.getGfsh();
                if (userName != null && userName.length() > 0) {
                    if (passwordToUse == null || passwordToUse.length() == 0) {
                        passwordToUse = gfshInstance.readWithMask("jmx password: ", Character.valueOf('*'));
                    }
                    if (passwordToUse == null || passwordToUse.length() == 0) {
                        throw new IllegalArgumentException("jmx password must be specified.");
                    }
                }
                Map<String, String> sslConfigProps = this.readSSLConfiguration(useSsl, keystoreToUse, keystorePasswordToUse, truststoreToUse, truststorePasswordToUse, sslCiphersToUse, sslProtocolsToUse, gfSecurityPropertiesPath);
                if (memberRmiHostPort != null) {
                    hostPortToConnect = memberRmiHostPort;
                    Gfsh.println(CliStrings.format("Connecting to Manager at {0} ..", new Object[]{memberRmiHostPort.toString(false)}));
                } else {
                    isConnectingViaLocator = true;
                    hostPortToConnect = locatorTcpHostPort;
                    Gfsh.println(CliStrings.format("Connecting to Locator at {0} ..", new Object[]{locatorTcpHostPort.toString(false)}));
                    if (useSsl || !sslConfigProps.isEmpty()) {
                        if (!sslConfigProps.containsKey("cluster-ssl-enabled")) {
                            sslConfigProps.put("ssl-enabled", String.valueOf(true));
                        }
                        sslConfigProps.put("mcast-port", String.valueOf(0));
                        sslConfigProps.put("locators", "");
                        String sslInfoLogMsg = "Connecting to Locator via SSL.";
                        if (useSsl) {
                            sslInfoLogMsg = "use-ssl is set to true. " + sslInfoLogMsg;
                        }
                        gfshInstance.logToFile(sslInfoLogMsg, null);
                    }
                    ConnectToLocatorResult connectToLocatorResult = ShellCommands.connectToLocator(locatorTcpHostPort.getHost(), locatorTcpHostPort.getPort(), 60000, sslConfigProps);
                    hostPortToConnect = memberRmiHostPort = connectToLocatorResult.getMemberEndpoint();
                    Gfsh.printlnErr(connectToLocatorResult.getResultMessage());
                    if (!(!useSsl && sslConfigProps.isEmpty() || connectToLocatorResult.isJmxManagerSslEnabled())) {
                        gfshInstance.logInfo("use-ssl is set to true. But JMX Manager doesn't support SSL, connecting without SSL.", null);
                        sslConfigProps.clear();
                    }
                }
                if (!sslConfigProps.isEmpty()) {
                    gfshInstance.logToFile("Connecting to manager via SSL.", null);
                }
                JmxOperationInvoker operationInvoker = new JmxOperationInvoker(memberRmiHostPort.getHost(), memberRmiHostPort.getPort(), userName, passwordToUse, sslConfigProps);
                gfshInstance.setOperationInvoker(operationInvoker);
                infoResultData.addLine(CliStrings.format("Successfully connected to: {0}", (Object)memberRmiHostPort.toString(false)));
                LogWrapper.getInstance().info(CliStrings.format("Successfully connected to: {0}", (Object)memberRmiHostPort.toString(false)));
                result = ResultBuilder.buildResult(infoResultData);
            }
            catch (Exception e) {
                Gfsh gfshInstance = Gfsh.getCurrentInstance();
                String errorMessage = e.getMessage();
                boolean logAsFine = false;
                if (CauseFinder.indexOfCause(e, ServiceUnavailableException.class, false) != -1) {
                    errorMessage = CliStrings.format("Could not find a GemFire jmx-manager service at {0}.", (Object)hostPortToConnect.toString(false));
                } else if (e instanceof JMXConnectionException) {
                    JMXConnectionException jce = (JMXConnectionException)e;
                    if (jce.getExceptionType() == 2) {
                        errorMessage = CliStrings.format("Could not find a GemFire jmx-manager service at {0}.", (Object)hostPortToConnect.toString(false));
                    }
                } else if (e instanceof ConnectException && isConnectingViaLocator) {
                    errorMessage = CliStrings.format("Could not connect to GemFire Locator service at {0}.", (Object)hostPortToConnect.toString(false));
                } else if (e instanceof IllegalStateException && isConnectingViaLocator) {
                    Throwable causeByType = CauseFinder.causeByType(e, ClassCastException.class, false);
                    if (causeByType != null) {
                        errorMessage = CliStrings.format(CliStrings.CONNECT__MSG__COULD_NOT_CONNECT_TO_LOCATOR_0_POSSIBLY_SSL_CONFIG_ERROR, new Object[]{hostPortToConnect.toString(false)});
                        if (gfshInstance.isLoggingEnabled()) {
                            errorMessage = errorMessage + " " + ShellCommands.getGfshLogsCheckMessage(gfshInstance.getLogFilePath());
                        }
                    } else if (errorMessage == null) {
                        errorMessage = CliStrings.format("Could not connect to GemFire Locator service at {0}.", (Object)locatorTcpHostPort.toString(false));
                        if (gfshInstance.isLoggingEnabled()) {
                            errorMessage = errorMessage + " " + ShellCommands.getGfshLogsCheckMessage(gfshInstance.getLogFilePath());
                        }
                    }
                } else if (e instanceof IOException) {
                    Throwable causeByType = CauseFinder.causeByType(e, ConnectIOException.class, false);
                    if (causeByType != null) {
                        if (String.valueOf(causeByType.getMessage()).contains("non-JRMP server")) {
                            errorMessage = CliStrings.format(CliStrings.CONNECT__MSG__COULD_NOT_CONNECT_TO_MANAGER_0_POSSIBLY_SSL_CONFIG_ERROR, new Object[]{memberRmiHostPort.toString(false)});
                            logAsFine = true;
                        } else {
                            errorMessage = CliStrings.format("Could not connect to : {0}. {1}", memberRmiHostPort.toString(false), "");
                        }
                        if (gfshInstance.isLoggingEnabled()) {
                            errorMessage = errorMessage + " " + ShellCommands.getGfshLogsCheckMessage(gfshInstance.getLogFilePath());
                        }
                    }
                } else if (e instanceof SecurityException) {
                    String msgPart = StringUtils.isBlank(userName) && StringUtils.isBlank(passwordToUse) ? "" : "appropriate ";
                    errorMessage = errorMessage + ". Please specify " + msgPart + "values for --" + "user" + " and --" + "password";
                } else {
                    errorMessage = CliStrings.format("Could not connect to : {0}. {1}", hostPortToConnect.toString(false), errorMessage);
                }
                result = ResultBuilder.createConnectionErrorResult(errorMessage);
                if (logAsFine) {
                    LogWrapper.getInstance().fine(e.getMessage(), e);
                }
                LogWrapper.getInstance().severe(e.getMessage(), e);
            }
            Gfsh.redirectInternalJavaLoggers();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureHttpsURLConnection(Map<String, String> sslConfigProps) throws Exception {
        String keystoreToUse = sslConfigProps.get("javax.net.ssl.keyStore");
        String keystorePasswordToUse = sslConfigProps.get("javax.net.ssl.keyStorePassword");
        String truststoreToUse = sslConfigProps.get("javax.net.ssl.trustStore");
        String truststorePasswordToUse = sslConfigProps.get("javax.net.ssl.trustStorePassword");
        String sslCiphersToUse = sslConfigProps.get("cluster-ssl-ciphers");
        String sslProtocolsToUse = sslConfigProps.get("cluster-ssl-protocols");
        FileInputStream keyStoreStream = null;
        FileInputStream trustStoreStream = null;
        try {
            KeyManagerFactory keyManagerFactory = null;
            if (!StringUtils.isBlank(keystoreToUse)) {
                KeyStore clientKeys = KeyStore.getInstance("JKS");
                keyStoreStream = new FileInputStream(keystoreToUse);
                clientKeys.load(keyStoreStream, keystorePasswordToUse.toCharArray());
                keyManagerFactory = KeyManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                keyManagerFactory.init(clientKeys, keystorePasswordToUse.toCharArray());
            }
            TrustManagerFactory trustManagerFactory = null;
            if (!StringUtils.isBlank(truststoreToUse)) {
                KeyStore serverPub = KeyStore.getInstance("JKS");
                trustStoreStream = new FileInputStream(truststoreToUse);
                serverPub.load(trustStoreStream, truststorePasswordToUse.toCharArray());
                trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(serverPub);
            }
            SSLContext ssl = SSLContext.getInstance(SSLUtil.getSSLAlgo(SSLUtil.readArray(sslProtocolsToUse)));
            ssl.init(keyManagerFactory != null ? keyManagerFactory.getKeyManagers() : null, trustManagerFactory != null ? trustManagerFactory.getTrustManagers() : null, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(ssl.getSocketFactory());
        }
        finally {
            if (keyStoreStream != null) {
                keyStoreStream.close();
            }
            if (trustStoreStream != null) {
                trustStoreStream.close();
            }
        }
    }

    private Map<String, String> readSSLConfiguration(boolean useSsl, String keystoreToUse, String keystorePasswordToUse, String truststoreToUse, String truststorePasswordToUse, String sslCiphersToUse, String sslProtocolsToUse, String gfSecurityPropertiesPath) throws IOException {
        Gfsh gfshInstance = this.getGfsh();
        LinkedHashMap<String, String> sslConfigProps = new LinkedHashMap<String, String>();
        if (useSsl || gfSecurityPropertiesPath != null) {
            String gfSecurityPropertiesPathToUse = CliUtil.resolvePathname(gfSecurityPropertiesPath);
            URL gfSecurityPropertiesUrl = null;
            if (!StringUtils.isBlank(gfSecurityPropertiesPathToUse)) {
                if (!IOUtils.isExistingPathname(gfSecurityPropertiesPathToUse)) {
                    gfshInstance.printAsSevere(CliStrings.format("Warning: The GemFire {0}properties file {1} could not be found.", "Security ", gfSecurityPropertiesPathToUse));
                } else {
                    gfSecurityPropertiesUrl = new File(gfSecurityPropertiesPathToUse).toURI().toURL();
                }
            } else if (useSsl && gfSecurityPropertiesPath == null) {
                gfSecurityPropertiesUrl = ShellCommands.getFileUrl("gfsecurity.properties");
            }
            if (gfSecurityPropertiesUrl != null) {
                gfshInstance.logToFile("Using security properties file : " + CliUtil.decodeWithDefaultCharSet(gfSecurityPropertiesUrl.getPath()), null);
                Map<String, String> gfsecurityProps = ShellCommands.loadPropertiesFromURL(gfSecurityPropertiesUrl);
                sslConfigProps.putAll(gfsecurityProps);
            }
        }
        int numTimesPrompted = 0;
        do {
            if (numTimesPrompted > 0) {
                Gfsh.println("Please specify these SSL Configuration properties: ");
            }
            if (numTimesPrompted > 0) {
                keystoreToUse = this.readText(gfshInstance, "key-store: ");
            }
            if (keystoreToUse != null && keystoreToUse.length() > 0) {
                if (keystorePasswordToUse == null || keystorePasswordToUse.length() == 0) {
                    keystorePasswordToUse = (String)sslConfigProps.get("javax.net.ssl.keyStorePassword");
                    if (keystorePasswordToUse == null || keystorePasswordToUse.length() == 0) {
                        keystorePasswordToUse = this.readPassword(gfshInstance, "key-store-password: ");
                        sslConfigProps.put("javax.net.ssl.keyStorePassword", keystorePasswordToUse);
                    }
                } else {
                    sslConfigProps.put("javax.net.ssl.keyStorePassword", keystorePasswordToUse);
                }
                sslConfigProps.put("javax.net.ssl.keyStore", keystoreToUse);
            }
            if (numTimesPrompted > 0) {
                truststoreToUse = this.readText(gfshInstance, "trust-store: ");
            }
            if (truststoreToUse != null && truststoreToUse.length() > 0) {
                if (truststorePasswordToUse == null || truststorePasswordToUse.length() == 0) {
                    truststorePasswordToUse = (String)sslConfigProps.get("javax.net.ssl.trustStorePassword");
                    if (truststorePasswordToUse == null || truststorePasswordToUse.length() == 0) {
                        truststorePasswordToUse = this.readPassword(gfshInstance, "trust-store-password: ");
                        sslConfigProps.put("javax.net.ssl.trustStorePassword", truststorePasswordToUse);
                    }
                } else {
                    sslConfigProps.put("javax.net.ssl.trustStorePassword", truststorePasswordToUse);
                }
                sslConfigProps.put("javax.net.ssl.trustStore", truststoreToUse);
            }
            if (numTimesPrompted > 0) {
                sslCiphersToUse = this.readText(gfshInstance, "ciphers: ");
            }
            if (sslCiphersToUse != null && sslCiphersToUse.length() > 0) {
                sslConfigProps.put("cluster-ssl-ciphers", sslCiphersToUse);
            }
            if (numTimesPrompted > 0) {
                sslProtocolsToUse = this.readText(gfshInstance, "protocols: ");
            }
            if (sslProtocolsToUse == null || sslProtocolsToUse.length() <= 0) continue;
            sslConfigProps.put("cluster-ssl-protocols", sslProtocolsToUse);
        } while (useSsl && sslConfigProps.isEmpty() && 0 == numTimesPrompted++ && !gfshInstance.isQuietMode());
        return sslConfigProps;
    }

    private static String getGfshLogsCheckMessage(String logFilePath) {
        return CliStrings.format("Please check logs {0}", (Object)logFilePath);
    }

    private String readText(Gfsh gfsh, String textToPrompt) throws IOException {
        if (!gfsh.isHeadlessMode() || !gfsh.isQuietMode()) {
            return gfsh.interact(textToPrompt);
        }
        return null;
    }

    private String readPassword(Gfsh gfsh, String textToPrompt) throws IOException {
        if (!gfsh.isHeadlessMode() || !gfsh.isQuietMode()) {
            return gfsh.readWithMask(textToPrompt, Character.valueOf('*'));
        }
        return null;
    }

    static Map<String, String> loadPropertiesFromURL(URL gfSecurityPropertiesUrl) {
        Map<String, String> propsMap = Collections.emptyMap();
        if (gfSecurityPropertiesUrl != null) {
            InputStream inputStream;
            block7: {
                inputStream = null;
                try {
                    Properties props = new Properties();
                    inputStream = gfSecurityPropertiesUrl.openStream();
                    props.load(inputStream);
                    if (props.isEmpty()) break block7;
                    HashSet<String> jmxSpecificProps = new HashSet<String>();
                    propsMap = new LinkedHashMap<String, String>();
                    Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
                    for (Map.Entry<Object, Object> entry : entrySet) {
                        String key2 = (String)entry.getKey();
                        if (key2.endsWith("-jmx")) {
                            key2 = key2.substring(0, key2.length() - "-jmx".length());
                            jmxSpecificProps.add(key2);
                            propsMap.put(key2, (String)entry.getValue());
                            continue;
                        }
                        if (jmxSpecificProps.contains(key2)) continue;
                        propsMap.put(key2, (String)entry.getValue());
                    }
                    props.clear();
                    jmxSpecificProps.clear();
                }
                catch (IOException io) {
                    try {
                        throw new RuntimeException(CliStrings.format("Could not read config from {0}.", (Object)CliUtil.decodeWithDefaultCharSet(gfSecurityPropertiesUrl.getPath())), io);
                    }
                    catch (Throwable throwable) {
                        IOUtils.close(inputStream);
                        throw throwable;
                    }
                }
            }
            IOUtils.close(inputStream);
        }
        return propsMap;
    }

    private static URL getFileUrl(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            try {
                return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(file).toURI().toURL();
            }
            catch (MalformedURLException ignore) {
                // empty catch block
            }
        }
        if ((file = new File(System.getProperty("user.home"), fileName)).exists()) {
            try {
                return IOUtils.tryGetCanonicalFileElseGetAbsoluteFile(file).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return ClassPathLoader.getLatest().getResource(ShellCommands.class, fileName);
    }

    public static ConnectToLocatorResult connectToLocator(String host, int port, int timeout, Map<String, String> props) throws IOException {
        DSFIDFactory.registerTypes();
        JmxManagerLocatorResponse locatorResponse = JmxManagerLocatorRequest.send(host, port, timeout, props);
        if (StringUtils.isBlank(locatorResponse.getHost()) || locatorResponse.getPort() == 0) {
            Throwable locatorResponseException = locatorResponse.getException();
            String exceptionMessage = "Locator could not find a JMX Manager";
            if (locatorResponseException != null) {
                String locatorResponseExceptionMessage = locatorResponseException.getMessage();
                locatorResponseExceptionMessage = !StringUtils.isBlank(locatorResponseExceptionMessage) ? locatorResponseExceptionMessage : locatorResponseException.toString();
                exceptionMessage = "Exception caused JMX Manager startup to fail because: '".concat(locatorResponseExceptionMessage).concat("'");
            }
            throw new IllegalStateException(exceptionMessage, locatorResponseException);
        }
        ConnectionEndpoint memberEndpoint = new ConnectionEndpoint(locatorResponse.getHost(), locatorResponse.getPort());
        String resultMessage = CliStrings.format("Connecting to Manager at {0} ..", (Object)memberEndpoint.toString(false));
        return new ConnectToLocatorResult(memberEndpoint, resultMessage, locatorResponse.isJmxManagerSslEnabled());
    }

    @CliCommand(value={"disconnect"}, help="Close the current connection, if one is open.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX", "Manager"})
    public Result disconnect() {
        Result result = null;
        if (this.getGfsh() != null && !this.getGfsh().isConnectedAndReady()) {
            result = ResultBuilder.createInfoResult("Not connected.");
        } else {
            InfoResultData infoResultData = ResultBuilder.createInfoResultData();
            try {
                Gfsh gfshInstance = this.getGfsh();
                if (gfshInstance.isConnectedAndReady()) {
                    OperationInvoker operationInvoker = gfshInstance.getOperationInvoker();
                    Gfsh.println("Disconnecting from: " + operationInvoker);
                    operationInvoker.stop();
                    infoResultData.addLine(CliStrings.format("Disconnected from : {0}", (Object)operationInvoker.toString()));
                    LogWrapper.getInstance().info(CliStrings.format("Disconnected from : {0}", (Object)operationInvoker.toString()));
                    gfshInstance.setPromptPath("");
                } else {
                    infoResultData.addLine("Not connected!");
                }
                result = ResultBuilder.buildResult(infoResultData);
            }
            catch (Exception e) {
                result = ResultBuilder.createConnectionErrorResult(CliStrings.format("Error occurred while disconnecting: {0}", (Object)e.getMessage()));
            }
        }
        return result;
    }

    @CliCommand(value={"describe connection"}, help="Display information about the current connection.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "JMX"})
    public Result describeConnection() {
        Result result = null;
        try {
            TabularResultData tabularResultData = ResultBuilder.createTabularResultData();
            Gfsh gfshInstance = this.getGfsh();
            if (gfshInstance.isConnectedAndReady()) {
                OperationInvoker operationInvoker = gfshInstance.getOperationInvoker();
                tabularResultData.accumulate("Connection Endpoints", operationInvoker.toString());
            } else {
                tabularResultData.accumulate("Connection Endpoints", "Not connected");
            }
            result = ResultBuilder.buildResult(tabularResultData);
        }
        catch (Exception e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
        }
        return result;
    }

    @CliCommand(value={"echo"}, help="Echo the given text which may include system and user variables.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result echo(@CliOption(key={"string", ""}, unspecifiedDefaultValue="__NULL__", specifiedDefaultValue="", mandatory=true, help="String to be echoed. For example, \"SYS_USER variable is set to ${SYS_USER}\".") String stringToEcho) {
        Result result = null;
        if (stringToEcho.equals("$*")) {
            Gfsh gfshInstance = this.getGfsh();
            Map<String, String> envMap = gfshInstance.getEnv();
            Set<Map.Entry<String, String>> setEnvMap = envMap.entrySet();
            TabularResultData resultData = this.buildResultForEcho(setEnvMap);
            result = ResultBuilder.buildResult(resultData);
        } else {
            result = ResultBuilder.createInfoResult(stringToEcho);
        }
        return result;
    }

    TabularResultData buildResultForEcho(Set<Map.Entry<String, String>> propertyMap) {
        TabularResultData resultData = ResultBuilder.createTabularResultData();
        for (Map.Entry<String, String> setEntry : propertyMap) {
            resultData.accumulate("Property", setEntry.getKey());
            resultData.accumulate("Value", String.valueOf(setEntry.getValue()));
        }
        return resultData;
    }

    @CliCommand(value={"set variable"}, help="Set GFSH variables that can be used by commands. For example: if variable \"CACHE_SERVERS_GROUP\" is set then to use it with \"list members\", use \"list members --group=${CACHE_SERVERS_GROUP}\". The \"echo\" command can be used to know the value of a variable.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result setVariable(@CliOption(key={"name"}, mandatory=true, help="Name for the variable. Name must only be composed of letters, numbers and the \"_\" character and may not start with a number.") String var, @CliOption(key={"value"}, mandatory=true, help="Value that the variable will be set to.") String value2) {
        Result result = null;
        try {
            this.getGfsh().setEnvProperty(var, String.valueOf(value2));
            result = ResultBuilder.createInfoResult("Value for variable " + var + " is now: " + value2 + ".");
        }
        catch (IllegalArgumentException e) {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData();
            errorResultData.addLine(e.getMessage());
            result = ResultBuilder.buildResult(errorResultData);
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CliCommand(value={"debug"}, help="Enable/Disable debugging output in GFSH.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH", "Debug-Utility"})
    public Result debug(@CliOption(key={"state"}, unspecifiedDefaultValue="OFF", mandatory=true, optionContext="debug", help="ON or OFF to enable or disable debugging output.") String state) {
        Gfsh gfshInstance = Gfsh.getCurrentInstance();
        if (gfshInstance != null) {
            if (state.equalsIgnoreCase("ON")) {
                gfshInstance.setDebug(true);
                return ResultBuilder.createInfoResult("Debug is " + state);
            } else {
                if (!state.equalsIgnoreCase("OFF")) return ResultBuilder.createUserErrorResult(CliStrings.format("Invalid state value : {0}. It should be \"ON\" or \"OFF\" ", (Object)state));
                gfshInstance.setDebug(false);
            }
            return ResultBuilder.createInfoResult("Debug is " + state);
        } else {
            ErrorResultData errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Could not get GFSH Instance");
            return ResultBuilder.buildResult(errorResultData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CliCommand(value={"history"}, help="Display or export previously executed GFSH commands.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result history(@CliOption(key={"file"}, unspecifiedDefaultValue="__NULL__", help="File to which the history will be written.") String saveHistoryTo, @CliOption(key={"clear"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Clears the history of GFSH commands. Takes value as true or false") Boolean clearHistory) {
        if (clearHistory.booleanValue()) {
            return this.executeClearHistory();
        }
        Gfsh gfsh = Gfsh.getCurrentInstance();
        ErrorResultData errorResultData = null;
        StringBuilder contents = new StringBuilder();
        Writer output = null;
        int historySize = gfsh.getHistorySize();
        String historySizeString = String.valueOf(historySize);
        int historySizeWordLength = historySizeString.length();
        GfshHistory gfshHistory = gfsh.getGfshHistory();
        List gfshHistoryList = gfshHistory.getHistoryList();
        Iterator it = gfshHistoryList.iterator();
        boolean flagForLineNumbers = saveHistoryTo == null || saveHistoryTo.length() <= 0;
        long lineNumber = 0L;
        while (it.hasNext()) {
            String line = (String)it.next();
            if (line.isEmpty()) continue;
            if (flagForLineNumbers) {
                contents.append(String.format("%" + historySizeWordLength + "s  ", ++lineNumber));
            }
            contents.append(line);
            contents.append(GfshParser.LINE_SEPARATOR);
        }
        try {
            if (saveHistoryTo != null && saveHistoryTo.length() > 0) {
                File saveHistoryToFile = new File(saveHistoryTo);
                output = new BufferedWriter(new FileWriter(saveHistoryToFile));
                if (!saveHistoryToFile.exists()) {
                    errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("File does not exist");
                    Result result = ResultBuilder.buildResult(errorResultData);
                    return result;
                }
                if (!saveHistoryToFile.isFile()) {
                    errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("File Should not be a directory");
                    Result result = ResultBuilder.buildResult(errorResultData);
                    return result;
                }
                if (!saveHistoryToFile.canWrite()) {
                    errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("Unable to write to the specified file");
                    Result result = ResultBuilder.buildResult(errorResultData);
                    return result;
                }
                output.write(contents.toString());
            }
        }
        catch (IOException ex) {
            Result result = ResultBuilder.createInfoResult("File error " + ex.getMessage() + " for file " + saveHistoryTo);
            return result;
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException e) {
                errorResultData = ResultBuilder.createErrorResultData().setErrorCode(400).addLine("exception in closing file");
                return ResultBuilder.buildResult(errorResultData);
            }
        }
        if (saveHistoryTo != null && saveHistoryTo.length() > 0) {
            return ResultBuilder.createInfoResult("Wrote successfully to file " + saveHistoryTo);
        }
        return ResultBuilder.createInfoResult(contents.toString());
    }

    Result executeClearHistory() {
        try {
            Gfsh gfsh = Gfsh.getCurrentInstance();
            GfshHistory gfshHistory = gfsh.getGfshHistory();
            gfshHistory.clear();
        }
        catch (Exception e) {
            LogWrapper.getInstance().info(CliUtil.stackTraceAsString(e));
            return ResultBuilder.createGemFireErrorResult("Exception occured while clearing history " + e.getMessage());
        }
        return ResultBuilder.createInfoResult("Successfully deleted history");
    }

    @CliCommand(value={"run"}, help="Execute a set of GFSH commands. Commands that normally prompt for additional input will instead use default values.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result executeScript(@CliOption(key={"file"}, optionContext="converter.hint.file", mandatory=true, help="File containing the GFSH commands to execute.") File file, @CliOption(key={"quiet"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to show command output.") boolean quiet, @CliOption(key={"continue-on-error"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether command execution should continue if an error is received.") boolean continueOnError) {
        Result result = null;
        Gfsh gfsh = Gfsh.getCurrentInstance();
        try {
            result = gfsh.executeScript(file, quiet, continueOnError);
        }
        catch (IllegalArgumentException e) {
            result = ResultBuilder.createShellClientErrorResult(e.getMessage());
        }
        return result;
    }

    @CliCommand(value={"encrypt password"}, help="Encrypt a password for use in data source configuration.")
    @CliMetaData(shellOnly=true, relatedTopic={"Debug-Utility"})
    public Result encryptPassword(@CliOption(key={"password"}, help="Password to be encrypted.", mandatory=true) String stringToEncrypt) {
        return ResultBuilder.createInfoResult(PasswordUtil.encrypt(stringToEncrypt, false));
    }

    @CliCommand(value={"version"}, help="Display product version information.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result version(@CliOption(key={"full"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Whether to show the full version information.") boolean full) {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        return ResultBuilder.createInfoResult(gfsh.getVersion(full));
    }

    @CliCommand(value={"sleep"}, help="Delay for a specified amount of time in seconds - floating point values are allowed.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result sleep(@CliOption(key={"time"}, unspecifiedDefaultValue="3", help="Number of Seconds to sleep for.") double time) {
        try {
            LogWrapper.getInstance().fine("Sleeping for " + time + "seconds.");
            Thread.sleep(Math.round(time * 1000.0));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return ResultBuilder.createInfoResult("");
    }

    @CliCommand(value={"sh"}, help="Allows execution of operating system (OS) commands. Use '&' to return to gfsh prompt immediately. NOTE: Commands which pass output to another shell command are not currently supported.")
    @CliMetaData(shellOnly=true, relatedTopic={"GFSH"})
    public Result sh(@CliArgument(name="command", mandatory=true, help="The command to execute.") String command, @CliOption(key={"use-console"}, specifiedDefaultValue="true", unspecifiedDefaultValue="false", help="Useful on Unix systems for applications which need handle of console. Adds \"</dev/tty >/dev/tty\" to the user specified command.") boolean useConsole) {
        Result result = null;
        try {
            result = ResultBuilder.buildResult(ShellCommands.executeCommand(Gfsh.getCurrentInstance(), command, useConsole));
        }
        catch (IllegalStateException e) {
            result = ResultBuilder.createUserErrorResult(e.getMessage());
            LogWrapper.getInstance().warning("Unable to execute command \"" + command + "\". Reason:" + e.getMessage() + ".");
        }
        catch (IOException e) {
            result = ResultBuilder.createUserErrorResult(e.getMessage());
            LogWrapper.getInstance().warning("Unable to execute command \"" + command + "\". Reason:" + e.getMessage() + ".");
        }
        return result;
    }

    private static InfoResultData executeCommand(Gfsh gfsh, String userCommand, boolean useConsole) throws IOException {
        InfoResultData infoResultData = ResultBuilder.createInfoResultData();
        String cmdToExecute = userCommand;
        String cmdExecutor = "/bin/sh";
        String cmdExecutorOpt = "-c";
        if (SystemUtils.isWindows()) {
            cmdExecutor = "cmd";
            cmdExecutorOpt = "/c";
        } else if (useConsole) {
            cmdToExecute = cmdToExecute + " </dev/tty >/dev/tty";
        }
        String[] commandArray = new String[]{cmdExecutor, cmdExecutorOpt, cmdToExecute};
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        builder.command(commandArray);
        builder.directory();
        builder.redirectErrorStream();
        Process proc = builder.start();
        BufferedReader input = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        String lineRead = "";
        while ((lineRead = input.readLine()) != null) {
            infoResultData.addLine(lineRead);
        }
        proc.getOutputStream().close();
        try {
            if (proc.waitFor() != 0) {
                gfsh.logWarning("The command '" + userCommand + "' did not complete successfully", null);
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
        return infoResultData;
    }

    @CliAvailabilityIndicator(value={"connect", "disconnect", "describe connection"})
    public boolean isAvailable() {
        return true;
    }
}

