/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class BooleanConverter
implements Converter<Boolean> {
    public boolean supports(Class<?> requiredType, String optionContext) {
        return Boolean.class.isAssignableFrom(requiredType) || Boolean.TYPE.isAssignableFrom(requiredType);
    }

    public Boolean convertFromText(String value2, Class<?> requiredType, String optionContext) {
        if ("true".equalsIgnoreCase(value2)) {
            return true;
        }
        if ("false".equalsIgnoreCase(value2)) {
            return false;
        }
        throw new IllegalArgumentException("Cannot convert " + value2 + " to type Boolean.");
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String existingData, String optionContext, MethodTarget target) {
        completions.add(new Completion("true"));
        completions.add(new Completion("false"));
        return false;
    }
}

