/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import com.gemstone.gemfire.management.internal.cli.util.ConnectionEndpoint;
import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class ConnectionEndpointConverter
implements Converter<ConnectionEndpoint> {
    static final String DEFAULT_JMX_HOST = "localhost";
    static final int DEFAULT_JMX_PORT = 1099;
    static final String DEFAULT_JMX_ENDPOINTS = "localhost[1099]";
    public static final String DEFAULT_LOCATOR_HOST = "localhost";
    public static final int DEFAULT_LOCATOR_PORT = 10334;
    public static final String DEFAULT_LOCATOR_ENDPOINTS = "localhost[10334]";

    public boolean supports(Class<?> type, String optionContext) {
        return ConnectionEndpoint.class == type;
    }

    public ConnectionEndpoint convertFromText(String value2, Class<?> targetType, String optionContext) {
        String endpointStr = value2.trim();
        String hostStr = "localhost";
        String portStr = "";
        int port = 1099;
        if (!endpointStr.isEmpty()) {
            int openIndex = endpointStr.indexOf("[");
            int closeIndex = endpointStr.indexOf("]");
            if (openIndex != -1) {
                if (closeIndex == -1) {
                    throw new IllegalArgumentException("Expected input: host[port] or host. Invalid value specified endpoints : " + value2);
                }
                hostStr = endpointStr.substring(0, openIndex);
                portStr = endpointStr.substring(openIndex + 1, closeIndex);
                if (portStr.isEmpty()) {
                    throw new IllegalArgumentException("Expected input: host[port] or host. Invalid value specified endpoints : " + value2);
                }
                try {
                    port = Integer.valueOf(portStr);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Expected input: host[port], Port should be a valid number between 1024-65536. Invalid value specified endpoints : " + value2);
                }
            } else {
                if (closeIndex != -1) {
                    throw new IllegalArgumentException("Expected input: host[port] or host. Invalid value specified endpoints : " + value2);
                }
                hostStr = endpointStr;
            }
        }
        return new ConnectionEndpoint(hostStr, port);
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> targetType, String existingData, String optionContext, MethodTarget target) {
        if ("__jmx-manager__".equals(optionContext)) {
            completions.add(new Completion(DEFAULT_JMX_ENDPOINTS));
        } else if ("__locator__".equals(optionContext)) {
            completions.add(new Completion(DEFAULT_LOCATOR_ENDPOINTS));
        }
        return completions.size() > 0;
    }

    public static void main(String[] args) {
        ConnectionEndpointConverter cec = new ConnectionEndpointConverter();
        try {
            System.out.println(cec.convertFromText("halibut[2555]", (Class)null, (String)null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println(cec.convertFromText("halibut.pune.gemstone.com[2555]", (Class)null, (String)null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println(cec.convertFromText("halibut[]", (Class)null, (String)null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println(cec.convertFromText("halibut2555]", (Class)null, (String)null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println(cec.convertFromText("halibut[", (Class)null, (String)null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println(cec.convertFromText("halibut", (Class)null, (String)null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

