/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.converters;

import java.util.List;
import org.springframework.shell.core.Completion;
import org.springframework.shell.core.Converter;
import org.springframework.shell.core.MethodTarget;

public class EnumConverter
implements Converter<Enum> {
    public Enum convertFromText(String value2, Class<?> requiredType, String optionContext) {
        Class<?> enumClass = requiredType;
        return Enum.valueOf(enumClass, value2);
    }

    public boolean getAllPossibleValues(List<Completion> completions, Class<?> requiredType, String existingData, String optionContext, MethodTarget target) {
        Class<?> enumClass = requiredType;
        for (Enum enumValue : (Enum[])enumClass.getEnumConstants()) {
            String candidate = enumValue.name();
            if (!"".equals(existingData) && existingData != null && !candidate.startsWith(existingData) && !existingData.startsWith(candidate) && !candidate.toUpperCase().startsWith(existingData.toUpperCase()) && !existingData.toUpperCase().startsWith(candidate.toUpperCase())) continue;
            completions.add(new Completion(candidate));
        }
        return true;
    }

    public boolean supports(Class<?> requiredType, String optionContext) {
        return Enum.class.isAssignableFrom(requiredType);
    }
}

