/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.domain;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ClassPathLoader;
import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonArray;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.gemfire.management.internal.cli.multistep.CLIMultiStepHelper;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.result.TabularResultData;
import com.gemstone.gemfire.management.internal.cli.util.JsonUtil;
import com.gemstone.org.json.JSONObject;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataCommandResult
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String command;
    private Object putResult;
    private Object getResult;
    private List<SelectResultRow> selectResult;
    private String queryTraceString;
    public static final String QUERY_PAGE_START = "startCount";
    public static final String QUERY_PAGE_END = "endCount";
    public static final String QUERY_TRACE = "Query Trace";
    public static final String RESULT_FLAG = "Result";
    public static final String NUM_ROWS = "Rows";
    private List<KeyInfo> locateEntryLocations;
    private KeyInfo locateEntryResult;
    private boolean hasResultForAggregation;
    private Object removeResult;
    private Object inputKey;
    private Object inputValue;
    private Object inputQuery;
    private Throwable error;
    private String errorString;
    private String infoString;
    private String keyClass;
    private String valueClass;
    private int limit;
    private boolean operationCompletedSuccessfully;
    public static final String NEW_LINE = GfshParser.LINE_SEPARATOR;
    public static final int ROW_TYPE_STRUCT_RESULT = 100;
    public static final int ROW_TYPE_BEAN = 200;
    public static final int ROW_TYPE_PRIMITIVE = 300;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.isGet()) {
            sb.append(" Type  : Get").append(NEW_LINE);
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.getResult != null) {
                sb.append(" ReturnValue Class : ").append(this.getResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue : ").append(this.getResult).append(NEW_LINE);
        } else if (this.isPut()) {
            sb.append(" Type  : Put");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.putResult != null) {
                sb.append(" ReturnValue Class : ").append(this.putResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue  : ").append(this.putResult).append(NEW_LINE);
            sb.append(" Value  : ").append(this.inputValue).append(NEW_LINE);
        } else if (this.isRemove()) {
            sb.append(" Type  : Remove");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            if (this.removeResult != null) {
                sb.append(" ReturnValue Class : ").append(this.removeResult.getClass()).append(NEW_LINE);
            }
            sb.append(" ReturnValue  : ").append(this.removeResult).append(NEW_LINE);
        } else if (this.isLocateEntry()) {
            sb.append(" Type  : Locate Entry");
            sb.append(" Key  : ").append(this.inputKey).append(NEW_LINE);
            sb.append(" Results  : ").append(this.locateEntryResult).append(NEW_LINE);
            sb.append(" Locations  : ").append(this.locateEntryLocations).append(NEW_LINE);
        }
        if (this.errorString != null) {
            sb.append(" ERROR ").append(this.errorString);
        }
        return sb.toString();
    }

    public boolean isGet() {
        return "get".equals(this.command);
    }

    public boolean isPut() {
        return "put".equals(this.command);
    }

    public boolean isRemove() {
        return "remove".equals(this.command);
    }

    public boolean isLocateEntry() {
        return "locate entry".equals(this.command);
    }

    public boolean isSelect() {
        return "query".equals(this.command);
    }

    public List<SelectResultRow> getSelectResult() {
        return this.selectResult;
    }

    public static DataCommandResult createGetResult(Object inputKey, Object value2, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "get";
        result.inputKey = inputKey;
        result.getResult = value2;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createGetInfoResult(Object inputKey, Object value2, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "get";
        result.inputKey = inputKey;
        result.getResult = value2;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createLocateEntryResult(Object inputKey, KeyInfo locationResult, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "locate entry";
        result.inputKey = inputKey;
        if (flag) {
            result.hasResultForAggregation = true;
        }
        result.locateEntryResult = locationResult;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createLocateEntryInfoResult(Object inputKey, KeyInfo locationResult, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "locate entry";
        result.inputKey = inputKey;
        if (flag) {
            result.hasResultForAggregation = true;
        }
        result.locateEntryResult = locationResult;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createPutResult(Object inputKey, Object value2, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "put";
        result.inputKey = inputKey;
        result.putResult = value2;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createPutInfoResult(Object inputKey, Object value2, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "put";
        result.inputKey = inputKey;
        result.putResult = value2;
        result.error = error;
        result.infoString = infoString;
        return result;
    }

    public static DataCommandResult createRemoveResult(Object inputKey, Object value2, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "remove";
        result.inputKey = inputKey;
        result.removeResult = value2;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createRemoveInfoResult(Object inputKey, Object value2, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "remove";
        result.inputKey = inputKey;
        result.removeResult = value2;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createSelectResult(Object inputQuery, List<SelectResultRow> value2, String queryTraceString, Throwable error, String errorString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "query";
        result.inputQuery = inputQuery;
        result.queryTraceString = queryTraceString;
        result.selectResult = value2;
        result.error = error;
        result.errorString = errorString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public static DataCommandResult createSelectInfoResult(Object inputQuery, List<SelectResultRow> value2, int limit, Throwable error, String infoString, boolean flag) {
        DataCommandResult result = new DataCommandResult();
        result.command = "query";
        result.inputQuery = inputQuery;
        result.limit = limit;
        result.selectResult = value2;
        result.error = error;
        result.infoString = infoString;
        result.operationCompletedSuccessfully = flag;
        return result;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public Object getPutResult() {
        return this.putResult;
    }

    public void setPutResult(Object putResult) {
        this.putResult = putResult;
    }

    public Object getGetResult() {
        return this.getResult;
    }

    public void setGetResult(Object getResult) {
        this.getResult = getResult;
    }

    public Object getRemoveResult() {
        return this.removeResult;
    }

    public void setRemoveResult(Object removeResult) {
        this.removeResult = removeResult;
    }

    public Object getInputKey() {
        return this.inputKey;
    }

    public void setInputKey(Object inputKey) {
        this.inputKey = inputKey;
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    public void setInputValue(Object inputValue) {
        this.inputValue = inputValue;
    }

    public Throwable getErorr() {
        return this.error;
    }

    public void setErorr(Throwable erorr) {
        this.error = erorr;
    }

    public String getErrorString() {
        return this.errorString;
    }

    public void setErrorString(String errorString) {
        this.errorString = errorString;
    }

    public String getInfoString() {
        return this.infoString;
    }

    public void setInfoString(String infoString) {
        this.infoString = infoString;
    }

    public String getKeyClass() {
        return this.keyClass;
    }

    public void setKeyClass(String keyClass) {
        this.keyClass = keyClass;
    }

    public String getValueClass() {
        return this.valueClass;
    }

    public void setValueClass(String valueClass) {
        this.valueClass = valueClass;
    }

    public List<KeyInfo> getLocateEntryLocations() {
        return this.locateEntryLocations;
    }

    public void setLocateEntryLocations(List<KeyInfo> locateEntryLocations) {
        this.locateEntryLocations = locateEntryLocations;
    }

    public Result toCommandResult() {
        if (this.keyClass == null || this.keyClass.isEmpty()) {
            this.keyClass = "java.lang.String";
        }
        if (this.valueClass == null || this.valueClass.isEmpty()) {
            this.valueClass = "java.lang.String";
        }
        if (this.errorString != null) {
            CompositeResultData data = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = data.addSection();
            section.addData("Message", this.errorString);
            section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
            return ResultBuilder.buildResult(data);
        }
        CompositeResultData data = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = data.addSection();
        TabularResultData table = section.addTable();
        section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
        if (this.infoString != null) {
            section.addData("Message", this.infoString);
        }
        if (this.isGet()) {
            section.addData("Key Class", this.getKeyClass());
            if (!this.isDeclaredPrimitive(this.keyClass)) {
                this.addJSONStringToTable(table, this.inputKey);
            } else {
                section.addData("Key", this.inputKey);
            }
            section.addData("Value Class", this.getValueClass());
            if (!this.isDeclaredPrimitive(this.valueClass)) {
                this.addJSONStringToTable(table, this.getResult);
            } else {
                section.addData("Value", this.getResult);
            }
        } else if (this.isLocateEntry()) {
            section.addData("Key Class", this.getKeyClass());
            if (!this.isDeclaredPrimitive(this.keyClass)) {
                this.addJSONStringToTable(table, this.inputKey);
            } else {
                section.addData("Key", this.inputKey);
            }
            if (this.locateEntryLocations != null) {
                TabularResultData locationTable = section.addTable();
                int totalLocations = 0;
                for (KeyInfo info : this.locateEntryLocations) {
                    List<Object[]> locations = info.getLocations();
                    if (locations == null) continue;
                    if (locations.size() == 1) {
                        Object[] array = locations.get(0);
                        boolean found = (Boolean)array[1];
                        if (!found) continue;
                        ++totalLocations;
                        boolean primary = (Boolean)array[3];
                        String bucketId = (String)array[4];
                        locationTable.accumulate("MemberName", info.getMemberName());
                        locationTable.accumulate("MemberId", info.getMemberId());
                        if (bucketId == null) continue;
                        if (primary) {
                            locationTable.accumulate("Primary", "*Primary PR*");
                        } else {
                            locationTable.accumulate("Primary", "No");
                        }
                        locationTable.accumulate("BucketId", bucketId);
                        continue;
                    }
                    for (Object[] array : locations) {
                        String regionPath = (String)array[0];
                        boolean found = (Boolean)array[1];
                        if (!found) continue;
                        ++totalLocations;
                        boolean primary = (Boolean)array[3];
                        String bucketId = (String)array[4];
                        locationTable.accumulate("MemberName", info.getMemberName());
                        locationTable.accumulate("MemberId", info.getMemberId());
                        locationTable.accumulate("RegionPath", regionPath);
                        if (bucketId == null) continue;
                        if (primary) {
                            locationTable.accumulate("Primary", "*Primary PR*");
                        } else {
                            locationTable.accumulate("Primary", "No");
                        }
                        locationTable.accumulate("BucketId", bucketId);
                    }
                }
                section.addData("Locations Found", totalLocations);
            } else {
                section.addData("Location Info ", "Could not find location information");
            }
        } else if (this.isPut()) {
            section.addData("Key Class", this.getKeyClass());
            if (!this.isDeclaredPrimitive(this.keyClass)) {
                this.addJSONStringToTable(table, this.inputKey);
            } else {
                section.addData("Key", this.inputKey);
            }
            section.addData("Value Class", this.getValueClass());
            if (!this.isDeclaredPrimitive(this.valueClass)) {
                this.addJSONStringToTable(table, this.putResult);
            } else {
                section.addData("Old Value", this.putResult);
            }
        } else if (this.isRemove()) {
            if (this.inputKey != null) {
                section.addData("Key Class", this.getKeyClass());
                if (!this.isDeclaredPrimitive(this.keyClass)) {
                    this.addJSONStringToTable(table, this.inputKey);
                } else {
                    section.addData("Key", this.inputKey);
                }
            }
        } else if (this.isSelect()) {
            // empty if block
        }
        return ResultBuilder.buildResult(data);
    }

    public CompositeResultData toSelectCommandResult() {
        if (this.errorString != null) {
            CompositeResultData data = ResultBuilder.createCompositeResultData();
            CompositeResultData.SectionResultData section = data.addSection();
            section.addData("Message", this.errorString);
            section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
            return data;
        }
        CompositeResultData data = ResultBuilder.createCompositeResultData();
        CompositeResultData.SectionResultData section = data.addSection();
        TabularResultData table = section.addTable();
        section.addData(RESULT_FLAG, this.operationCompletedSuccessfully);
        if (this.infoString != null) {
            section.addData("Message", this.infoString);
        }
        if (this.inputQuery != null) {
            if (this.limit != -1) {
                section.addData("Limit", this.limit);
            }
            if (this.selectResult != null) {
                section.addData(NUM_ROWS, this.selectResult.size());
                if (this.queryTraceString != null) {
                    section.addData(QUERY_TRACE, this.queryTraceString);
                }
                this.buildTable(table, 0, this.selectResult.size());
            }
        }
        return data;
    }

    public Result pageResult(int startCount, int endCount, String step) {
        ArrayList<String> fields = new ArrayList<String>();
        ArrayList<Object> values = new ArrayList<Object>();
        fields.add(RESULT_FLAG);
        values.add(this.operationCompletedSuccessfully);
        fields.add(QUERY_PAGE_START);
        values.add(startCount);
        fields.add(QUERY_PAGE_END);
        values.add(endCount);
        if (this.errorString != null) {
            fields.add("Message");
            values.add(this.errorString);
            return CLIMultiStepHelper.createBannerResult(fields, values, step);
        }
        if (this.infoString != null) {
            fields.add("Message");
            values.add(this.infoString);
        }
        if (this.selectResult != null) {
            try {
                TabularResultData table = ResultBuilder.createTabularResultData();
                String[] headers = null;
                Object[][] rows = null;
                int rowCount = this.buildTable(table, startCount, endCount);
                GfJsonArray array = table.getHeaders();
                headers = new String[array.size()];
                rows = new Object[rowCount][array.size()];
                for (int i = 0; i < array.size(); ++i) {
                    headers[i] = (String)array.get(i);
                    List<String> list = table.retrieveAllValues(headers[i]);
                    for (int j = 0; j < list.size(); ++j) {
                        rows[j][i] = list.get(j);
                    }
                }
                fields.add(NUM_ROWS);
                values.add(this.selectResult == null ? 0 : this.selectResult.size());
                if (this.queryTraceString != null) {
                    fields.add(QUERY_TRACE);
                    values.add(this.queryTraceString);
                }
                return CLIMultiStepHelper.createPageResult(fields, values, step, headers, rows);
            }
            catch (GfJsonException e) {
                String[] headers = new String[]{"Error"};
                Object[][] rows = new Object[][]{{e.getMessage()}};
                String[] fieldsArray = new String[]{QUERY_PAGE_START, QUERY_PAGE_END};
                Object[] valuesArray = new Object[]{startCount, endCount};
                return CLIMultiStepHelper.createPageResult(fieldsArray, valuesArray, step, headers, rows);
            }
        }
        return CLIMultiStepHelper.createBannerResult(fields, values, step);
    }

    private int buildTable(TabularResultData table, int startCount, int endCount) {
        int rowCount = 0;
        block5: for (int i = startCount; i <= endCount && i < this.selectResult.size(); ++i) {
            ++rowCount;
            SelectResultRow row = this.selectResult.get(i);
            switch (row.type) {
                case 200: {
                    this.addJSONStringToTable(table, row.value);
                    continue block5;
                }
                case 100: {
                    this.addJSONStringToTable(table, row.value);
                    continue block5;
                }
                case 300: {
                    table.accumulate(RESULT_FLAG, row.value);
                }
            }
        }
        return rowCount;
    }

    private boolean isDeclaredPrimitive(String keyClass2) {
        try {
            Class<?> klass = ClassPathLoader.getLatest().forName(keyClass2);
            return JsonUtil.isPrimitiveOrWrapper(klass);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void addJSONStringToTable(TabularResultData table, Object object) {
        if (object == null || "<NULL>".equals(object)) {
            table.accumulate("Value", "<NULL>");
        } else {
            try {
                Class<?> klass = object.getClass();
                GfJsonObject jsonObject = null;
                if (String.class.equals(klass)) {
                    String json = (String)object;
                    String newString = json.replaceAll("'", "\"");
                    if (newString.charAt(0) == '(') {
                        int len = newString.length();
                        StringBuilder sb = new StringBuilder();
                        sb.append("{").append(newString.substring(1, len - 1)).append("}");
                        newString = sb.toString();
                    }
                    jsonObject = new GfJsonObject(newString);
                } else {
                    jsonObject = new GfJsonObject(object, true);
                }
                Iterator<String> keys = jsonObject.keys();
                while (keys.hasNext()) {
                    Object value2;
                    String k = keys.next();
                    if ("type-class".equals(k) || (value2 = jsonObject.get(k)) == null) continue;
                    table.accumulate(k, this.getDomainValue(value2));
                }
            }
            catch (Exception e) {
                table.accumulate("Value", "Error getting bean properties " + e.getMessage());
            }
        }
    }

    private Object getDomainValue(Object value2) {
        if (value2 instanceof String) {
            String str = (String)value2;
            if (str.contains("{") && str.contains("}")) {
                try {
                    JSONObject json = new JSONObject(str);
                    return json.get("type-class");
                }
                catch (Exception e) {
                    return str;
                }
            }
            return str;
        }
        return value2;
    }

    public Object getInputQuery() {
        return this.inputQuery;
    }

    public void setInputQuery(Object inputQuery) {
        this.inputQuery = inputQuery;
    }

    public void aggregate(DataCommandResult result) {
        if (this.isLocateEntry()) {
            if (this.locateEntryLocations == null) {
                this.locateEntryLocations = new ArrayList<KeyInfo>();
            }
            if (result == null) {
                if (this.locateEntryResult != null) {
                    this.locateEntryLocations.add(this.locateEntryResult);
                }
                return;
            }
            if (result.errorString != null && !result.errorString.equals(this.errorString)) {
                String newString;
                this.errorString = newString = result.errorString + " " + this.errorString;
            }
            if (!this.operationCompletedSuccessfully && result.infoString != null && !result.infoString.equals(this.infoString)) {
                this.infoString = result.infoString;
            }
            if (result.hasResultForAggregation) {
                this.operationCompletedSuccessfully = true;
                this.infoString = result.infoString;
                if (result.locateEntryResult != null) {
                    this.locateEntryLocations.add(result.locateEntryResult);
                }
            }
        }
    }

    public void toData(DataOutput out) throws IOException {
        DataSerializer.writeString(this.command, out);
        out.writeUTF(this.command);
        DataSerializer.writeObject(this.putResult, out);
        DataSerializer.writeObject(this.getResult, out);
        DataSerializer.writeObject(this.locateEntryResult, out);
        DataSerializer.writeArrayList((ArrayList)this.locateEntryLocations, out);
        DataSerializer.writeBoolean(this.hasResultForAggregation, out);
        DataSerializer.writeObject(this.removeResult, out);
        DataSerializer.writeObject(this.inputKey, out);
        DataSerializer.writeObject(this.inputValue, out);
        DataSerializer.writeObject(this.error, out);
        DataSerializer.writeString(this.errorString, out);
        DataSerializer.writeString(this.infoString, out);
        DataSerializer.writeString(this.keyClass, out);
        DataSerializer.writeString(this.valueClass, out);
        DataSerializer.writeBoolean(this.operationCompletedSuccessfully, out);
    }

    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.command = DataSerializer.readString(in);
        this.putResult = DataSerializer.readObject(in);
        this.getResult = DataSerializer.readObject(in);
        this.locateEntryLocations = DataSerializer.readArrayList(in);
        this.locateEntryResult = (KeyInfo)DataSerializer.readObject(in);
        this.hasResultForAggregation = DataSerializer.readBoolean(in);
        this.removeResult = DataSerializer.readObject(in);
        this.inputKey = DataSerializer.readObject(in);
        this.inputValue = DataSerializer.readObject(in);
        this.error = (Throwable)DataSerializer.readObject(in);
        this.errorString = DataSerializer.readString(in);
        this.infoString = DataSerializer.readString(in);
        this.keyClass = DataSerializer.readString(in);
        this.valueClass = DataSerializer.readString(in);
        this.operationCompletedSuccessfully = DataSerializer.readBoolean(in);
    }

    public static class SelectResultRow
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private int type;
        private Object value;

        public SelectResultRow(int type, Object value2) {
            this.type = type;
            this.value = value2;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value2) {
            this.value = value2;
        }
    }

    public static class KeyInfo
    implements Serializable {
        private String memberId;
        private String memberName;
        private String host;
        private int pid;
        private ArrayList<Object[]> locations = null;

        public void addLocation(Object[] locationArray) {
            if (this.locations == null) {
                this.locations = new ArrayList();
            }
            this.locations.add(locationArray);
        }

        public List<Object[]> getLocations() {
            return this.locations;
        }

        public String getMemberId() {
            return this.memberId;
        }

        public void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public String getMemberName() {
            return this.memberName;
        }

        public void setMemberName(String memberName) {
            this.memberName = memberName;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public int getPid() {
            return this.pid;
        }

        public void setPid(int pid) {
            this.pid = pid;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("{ Member : ").append(this.host).append("(").append(this.memberId).append(") , ");
            for (Object[] array : this.locations) {
                boolean primary = (Boolean)array[3];
                String bucketId = (String)array[4];
                sb.append(" [ Primary : ").append(primary).append(" , BucketId : ").append(bucketId).append(" ]");
            }
            sb.append(" }");
            return sb.toString();
        }

        public boolean hasLocation() {
            if (this.locations == null) {
                return false;
            }
            for (Object[] array : this.locations) {
                boolean found = (Boolean)array[1];
                if (!found) continue;
                return true;
            }
            return false;
        }

        public void toData(DataOutput out) throws IOException {
            DataSerializer.writeString(this.memberId, out);
            DataSerializer.writeString(this.memberName, out);
            DataSerializer.writeString(this.host, out);
            DataSerializer.writePrimitiveInt(this.pid, out);
            DataSerializer.writeArrayList(this.locations, out);
        }

        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            this.memberId = DataSerializer.readString(in);
            this.memberName = DataSerializer.readString(in);
            this.host = DataSerializer.readString(in);
            this.pid = DataSerializer.readPrimitiveInt(in);
            this.locations = DataSerializer.readArrayList(in);
        }
    }
}

