/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.domain;

import com.gemstone.gemfire.cache.CacheListener;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.DataPolicy;
import com.gemstone.gemfire.cache.EvictionAttributes;
import com.gemstone.gemfire.cache.ExpirationAction;
import com.gemstone.gemfire.cache.PartitionAttributes;
import com.gemstone.gemfire.cache.RegionAttributes;
import com.gemstone.gemfire.cache.Scope;
import com.gemstone.gemfire.compression.Compressor;
import com.gemstone.gemfire.internal.cache.AbstractRegion;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.domain.EvictionAttributesInfo;
import com.gemstone.gemfire.management.internal.cli.domain.PartitionAttributesInfo;
import com.gemstone.gemfire.management.internal.cli.util.RegionAttributesDefault;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RegionAttributesInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Scope scope = AbstractRegion.DEFAULT_SCOPE;
    private boolean cloningEnabled = false;
    private boolean concurrencyChecksEnabled = false;
    private int concurrencyLevel = 16;
    private DataPolicy dataPolicy = DataPolicy.DEFAULT;
    private String diskStoreName = "";
    private boolean enableAsyncConflation = false;
    private boolean enableGateway = false;
    private boolean enableSubscriptionConflation = false;
    private String gatewayHubId = "";
    private boolean ignoreJTA = false;
    private boolean indexMaintenanceSynchronous = true;
    private int initialCapacity = 16;
    private float loadFactor = 0.75f;
    private boolean multicastEnabled = false;
    private String poolName = "";
    private boolean statisticsEnabled = false;
    private boolean isLockGrantor = false;
    private List<String> cacheListenerClassNames;
    private String cacheLoaderClassName = "";
    private String cacheWriterClassName = "";
    private String compressorClassName = null;
    private PartitionAttributesInfo partitionAttributesInfo = null;
    private EvictionAttributesInfo evictionAttributesInfo = null;
    private int regionTimeToLive = 0;
    private int regionIdleTimeout = 0;
    private int entryIdleTimeout = 0;
    private int entryTimeToLive = 0;
    private String entryTimeToLiveAction = ExpirationAction.INVALIDATE.toString();
    private String regionTimeToLiveAction = ExpirationAction.INVALIDATE.toString();
    private String entryIdleTimeoutAction = ExpirationAction.INVALIDATE.toString();
    private String regionIdleTimeoutAction = ExpirationAction.INVALIDATE.toString();
    Map<String, String> nonDefaultAttributes;

    public RegionAttributesInfo(RegionAttributes<?, ?> ra) {
        CacheWriter<?, ?> cacheWriter;
        CacheLoader<?, ?> cacheLoader;
        CacheListener<?, ?>[] cacheListeners;
        ExpirationAction expAction;
        this.cloningEnabled = ra.getCloningEnabled();
        this.concurrencyChecksEnabled = ra.getConcurrencyChecksEnabled();
        this.concurrencyLevel = ra.getConcurrencyLevel();
        this.dataPolicy = ra.getDataPolicy();
        this.diskStoreName = ra.getDiskStoreName();
        this.enableAsyncConflation = ra.getEnableAsyncConflation();
        this.enableGateway = ra.getEnableGateway();
        this.enableSubscriptionConflation = ra.getEnableSubscriptionConflation();
        this.gatewayHubId = ra.getGatewayHubId();
        this.ignoreJTA = ra.getIgnoreJTA();
        this.indexMaintenanceSynchronous = ra.getIndexMaintenanceSynchronous();
        this.initialCapacity = ra.getInitialCapacity();
        this.loadFactor = ra.getLoadFactor();
        this.multicastEnabled = ra.getMulticastEnabled();
        this.poolName = ra.getPoolName();
        this.scope = ra.getScope();
        this.statisticsEnabled = ra.getStatisticsEnabled();
        this.entryTimeToLive = ra.getEntryTimeToLive().getTimeout();
        this.isLockGrantor = ra.isLockGrantor();
        this.entryIdleTimeout = ra.getEntryIdleTimeout().getTimeout();
        this.regionIdleTimeout = ra.getRegionIdleTimeout().getTimeout();
        this.regionTimeToLive = ra.getRegionTimeToLive().getTimeout();
        Compressor compressor = ra.getCompressor();
        if (compressor != null) {
            this.compressorClassName = compressor.getClass().getCanonicalName();
        }
        if ((expAction = ra.getEntryIdleTimeout().getAction()) != null) {
            this.entryIdleTimeoutAction = expAction.toString();
        }
        if ((expAction = ra.getEntryTimeToLive().getAction()) != null) {
            this.entryTimeToLiveAction = expAction.toString();
        }
        if ((expAction = ra.getRegionTimeToLive().getAction()) != null) {
            this.regionTimeToLiveAction = expAction.toString();
        }
        if ((expAction = ra.getRegionIdleTimeout().getAction()) != null) {
            this.regionIdleTimeoutAction = expAction.toString();
        }
        if ((cacheListeners = ra.getCacheListeners()).length > 0) {
            this.cacheListenerClassNames = new ArrayList<String>();
            for (CacheListener<?, ?> cacheListener : cacheListeners) {
                this.cacheListenerClassNames.add(cacheListener.getClass().getCanonicalName());
            }
            Collections.sort(this.cacheListenerClassNames);
        }
        if ((cacheLoader = ra.getCacheLoader()) != null) {
            this.cacheLoaderClassName = cacheLoader.getClass().getCanonicalName();
        }
        if ((cacheWriter = ra.getCacheWriter()) != null) {
            this.cacheWriterClassName = cacheWriter.getClass().getCanonicalName();
        }
        PartitionAttributes partitionAttributes = ra.getPartitionAttributes();
        EvictionAttributes evictionAttributes = ra.getEvictionAttributes();
        if (partitionAttributes != null) {
            this.partitionAttributesInfo = new PartitionAttributesInfo(partitionAttributes);
        }
        if (evictionAttributes != null) {
            this.evictionAttributesInfo = new EvictionAttributesInfo(evictionAttributes);
        }
    }

    public PartitionAttributesInfo getPartitionAttributesInfo() {
        return this.partitionAttributesInfo;
    }

    public EvictionAttributesInfo getEvictionAttributesInfo() {
        return this.evictionAttributesInfo;
    }

    public int getEntryIdleTimeout() {
        return this.entryIdleTimeout;
    }

    public String getEntryIdleTimeoutAction() {
        return this.entryIdleTimeoutAction;
    }

    public int getEntryTimeToLive() {
        return this.entryTimeToLive;
    }

    public String getEntryTimeToLiveAction() {
        return this.entryTimeToLiveAction;
    }

    public int getRegionIdleTimeout() {
        return this.regionIdleTimeout;
    }

    public String getRegionIdleTimeoutAction() {
        return this.regionIdleTimeoutAction;
    }

    public boolean getCloningEnabled() {
        return this.cloningEnabled;
    }

    public String getCompressorClassName() {
        return this.compressorClassName;
    }

    public boolean getConcurrencyChecksEnabled() {
        return this.concurrencyChecksEnabled;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public DataPolicy getDataPolicy() {
        return this.dataPolicy;
    }

    public String getDiskStoreName() {
        return this.diskStoreName;
    }

    public boolean getEnableSyncConflation() {
        return this.enableAsyncConflation;
    }

    public boolean getEnableGateway() {
        return this.enableGateway;
    }

    public boolean getEnableSubscriptionConflation() {
        return this.enableSubscriptionConflation;
    }

    public String getGatewayHubId() {
        return this.gatewayHubId;
    }

    public boolean getIgnoreJTA() {
        return this.ignoreJTA;
    }

    public boolean getIndexMaintenanceSynchronous() {
        return this.indexMaintenanceSynchronous;
    }

    public int getInitialCapacity() {
        return this.initialCapacity;
    }

    public float getLoadFactor() {
        return this.loadFactor;
    }

    public boolean getMulticastEnabled() {
        return this.multicastEnabled;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public Scope getScope() {
        return this.scope;
    }

    public boolean getStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public boolean isLockGrantor() {
        return this.isLockGrantor;
    }

    public List<String> getCacheListenerClassNames() {
        return this.cacheListenerClassNames;
    }

    public String getCacheLoaderClassName() {
        return this.cacheLoaderClassName;
    }

    public String getCacheWriterClassName() {
        return this.cacheWriterClassName;
    }

    public int getRegionTimeToLive() {
        return this.regionTimeToLive;
    }

    public String getRegionTimeToLiveAction() {
        return this.regionTimeToLiveAction;
    }

    public boolean equals(Object arg0) {
        return super.equals(arg0);
    }

    public int hashCode() {
        return 42;
    }

    public Map<String, String> getNonDefaultAttributes() {
        if (this.nonDefaultAttributes == null) {
            this.nonDefaultAttributes = new HashMap<String, String>();
            if (this.cloningEnabled) {
                this.nonDefaultAttributes.put("cloning-enabled", Boolean.toString(this.cloningEnabled));
            }
            if (this.compressorClassName != RegionAttributesDefault.COMPRESSOR_CLASS_NAME) {
                this.nonDefaultAttributes.put("compressor", this.compressorClassName);
            }
            if (!this.concurrencyChecksEnabled) {
                this.nonDefaultAttributes.put("concurrency-checks-enabled", Boolean.toString(this.concurrencyChecksEnabled));
            }
            if (this.concurrencyLevel != 16) {
                this.nonDefaultAttributes.put("concurrency-level", Integer.toString(this.concurrencyLevel));
            }
            if (this.dataPolicy.equals(RegionAttributesDefault.DATA_POLICY)) {
                this.nonDefaultAttributes.put("data-policy", this.dataPolicy.toString());
            }
            if (this.diskStoreName != null && this.diskStoreName.equals("")) {
                this.nonDefaultAttributes.put("disk-store-name", this.diskStoreName);
            }
            if (this.enableAsyncConflation) {
                this.nonDefaultAttributes.put("enable-async-conflation", Boolean.toString(this.enableAsyncConflation));
            }
            if (this.enableGateway) {
                this.nonDefaultAttributes.put("enable-gateway", Boolean.toString(this.enableGateway));
            }
            if (this.enableSubscriptionConflation) {
                this.nonDefaultAttributes.put("enable-subscription-conflation", Boolean.toString(this.enableSubscriptionConflation));
            }
            if (this.entryIdleTimeout != 0) {
                this.nonDefaultAttributes.put("entry-idle-time.timeout", Integer.toString(this.entryIdleTimeout));
            }
            if (this.gatewayHubId != null && !this.gatewayHubId.isEmpty() && !this.gatewayHubId.equals("")) {
                this.nonDefaultAttributes.put("gateway-hub-id", this.gatewayHubId);
            }
            if (this.ignoreJTA) {
                this.nonDefaultAttributes.put("ignore-jta", Boolean.toString(this.ignoreJTA));
            }
            if (!this.indexMaintenanceSynchronous) {
                this.nonDefaultAttributes.put("index-maintenance-synchronous", Boolean.toString(this.indexMaintenanceSynchronous));
            }
            if (this.initialCapacity != 16) {
                this.nonDefaultAttributes.put("initial-capacity", Integer.toString(this.initialCapacity));
            }
            if (this.loadFactor != 0.75f) {
                this.nonDefaultAttributes.put("load-factor", Float.toString(this.loadFactor));
            }
            if (this.multicastEnabled) {
                this.nonDefaultAttributes.put("multicast-enabled", Boolean.toString(this.multicastEnabled));
            }
            if (this.poolName != null && !this.poolName.equals("")) {
                this.nonDefaultAttributes.put("pool-name", this.poolName);
            }
            if (this.scope.equals(RegionAttributesDefault.SCOPE)) {
                this.nonDefaultAttributes.put("scope", this.scope.toString());
            }
            if (this.statisticsEnabled) {
                this.nonDefaultAttributes.put("statistics-enabled", Boolean.toString(this.statisticsEnabled));
            }
            if (this.isLockGrantor) {
                this.nonDefaultAttributes.put("is-lock-grantor", Boolean.toString(this.isLockGrantor));
            }
            if (this.entryIdleTimeout != 0) {
                this.nonDefaultAttributes.put("entry-idle-time.timeout", Integer.toString(this.entryIdleTimeout));
            }
            if (this.entryIdleTimeoutAction != null && !this.entryIdleTimeoutAction.equals(RegionAttributesDefault.ENTRY_IDLE_TIMEOUT_ACTION)) {
                this.nonDefaultAttributes.put("entry-idle-time.action", this.entryIdleTimeoutAction);
            }
            if (this.entryTimeToLive != 0) {
                this.nonDefaultAttributes.put("entry-time-to-live.timeout", Integer.toString(this.entryTimeToLive));
            }
            if (this.entryTimeToLiveAction != null && !this.entryTimeToLiveAction.equals(RegionAttributesDefault.ENTRY_TIME_TO_LIVE_ACTION)) {
                this.nonDefaultAttributes.put("entry-time-to-live.action", this.entryTimeToLiveAction);
            }
            if (this.regionIdleTimeout != 0) {
                this.nonDefaultAttributes.put("region-idle-time.timeout", Integer.toString(this.regionIdleTimeout));
            }
            if (this.regionIdleTimeoutAction != null && !this.regionIdleTimeoutAction.equals(RegionAttributesDefault.REGION_IDLE_TIMEOUT_ACTION)) {
                this.nonDefaultAttributes.put("region-idle-time.action", this.regionIdleTimeoutAction);
            }
            if (this.regionTimeToLive != 0) {
                this.nonDefaultAttributes.put("region-time-to-live.timeout", Integer.toString(this.regionTimeToLive));
            }
            if (this.regionTimeToLiveAction != null && !this.regionTimeToLiveAction.equals(RegionAttributesDefault.REGION_TIME_TO_LIVE_ACTION)) {
                this.nonDefaultAttributes.put("region-time-to-live.action", this.regionTimeToLiveAction);
            }
            if (this.cacheListenerClassNames != null && !this.cacheListenerClassNames.isEmpty()) {
                this.nonDefaultAttributes.put("cache-listeners", CliUtil.convertStringListToString(this.cacheListenerClassNames, ','));
            }
            if (this.cacheLoaderClassName != null && !this.cacheLoaderClassName.isEmpty()) {
                this.nonDefaultAttributes.put("cache-loader", this.cacheLoaderClassName);
            }
            if (this.cacheWriterClassName != null && !this.cacheWriterClassName.isEmpty()) {
                this.nonDefaultAttributes.put("cache-writer", this.cacheWriterClassName);
            }
        }
        return this.nonDefaultAttributes;
    }
}

