/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.internal.logging.log4j.LogMarker;
import com.gemstone.gemfire.internal.logging.log4j.LogWriterLogger;
import java.util.HashMap;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public class ChangeLogLevelFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = ChangeLogLevelFunction.class.getName();
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        Cache cache = CacheFactory.getAnyInstance();
        HashMap<String, String> result = new HashMap<String, String>();
        try {
            LogWriterLogger logwriterLogger = (LogWriterLogger)cache.getLogger();
            Object[] args = (Object[])context.getArguments();
            String logLevel = (String)args[0];
            Level log4jLevel = LogWriterLogger.logWriterNametoLog4jLevel(logLevel);
            logwriterLogger.setLevel(log4jLevel);
            System.setProperty("gemfire.log-level", logLevel);
            logger.info(LogMarker.CONFIG, "GFSH Changed log level to {}", log4jLevel);
            result.put(cache.getDistributedSystem().getDistributedMember().getId(), "New log level is " + log4jLevel);
            context.getResultSender().lastResult(result);
        }
        catch (Exception ex) {
            logger.info(LogMarker.CONFIG, "GFSH Changing log level exception {}", ex.getMessage(), ex);
            result.put(cache.getDistributedSystem().getDistributedMember().getId(), "ChangeLogLevelFunction exception " + ex.getMessage());
            context.getResultSender().lastResult(result);
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

