/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheClosedException;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.cli.domain.RegionInformation;
import java.util.HashSet;
import java.util.Set;

public class GetRegionsFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public String getId() {
        return GetRegionsFunction.class.toString();
    }

    @Override
    public void execute(FunctionContext functionContext) {
        try {
            Cache cache = CacheFactory.getAnyInstance();
            Set<Region<?, ?>> regions = cache.rootRegions();
            if (regions.isEmpty() || regions == null) {
                functionContext.getResultSender().lastResult(null);
            } else {
                HashSet<RegionInformation> regionInformationSet = new HashSet<RegionInformation>();
                for (Region<?, ?> region : regions) {
                    RegionInformation regInfo = new RegionInformation(region, true);
                    regionInformationSet.add(regInfo);
                }
                functionContext.getResultSender().lastResult(regionInformationSet.toArray());
            }
        }
        catch (CacheClosedException e) {
            functionContext.getResultSender().sendException(e);
        }
        catch (Exception e) {
            functionContext.getResultSender().sendException(e);
        }
    }
}

