/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.cache.query.internal.CqService;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientNotifier;
import com.gemstone.gemfire.internal.cache.tier.sockets.CacheClientProxy;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.cli.domain.DurableCqNamesResult;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import java.util.ArrayList;
import java.util.List;

public class ListDurableCqNamesFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    protected Cache getCache() {
        return CacheFactory.getAnyInstance();
    }

    @Override
    public String getId() {
        return ListDurableCqNamesFunction.class.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(FunctionContext context) {
        Cache cache = this.getCache();
        DistributedMember member = cache.getDistributedSystem().getDistributedMember();
        String memberNameOrId = CliUtil.getMemberNameOrId(member);
        DurableCqNamesResult result = new DurableCqNamesResult(memberNameOrId);
        String durableClientId = (String)context.getArguments();
        try {
            CacheClientNotifier ccn = CacheClientNotifier.getInstance();
            if (ccn != null) {
                CacheClientProxy ccp = ccn.getClientProxy(durableClientId);
                if (ccp != null) {
                    CqService cqService = CqService.getRunningCqService();
                    if (cqService != null) {
                        List<String> durableCqNames = cqService.getAllDurableClientCqs(ccp.getProxyID());
                        if (durableCqNames != null && !durableCqNames.isEmpty()) {
                            result.setCqNamesList(new ArrayList<String>(durableCqNames));
                        } else {
                            result.setErrorMessage(CliStrings.format("No durable cqs found for durable-client-id : \"{0}\".", (Object)durableClientId));
                        }
                    } else {
                        result.setErrorMessage("No durable cq's registered on this member.");
                    }
                } else {
                    result.setErrorMessage(CliStrings.format("No client found with client-id : {0}", (Object)durableClientId));
                }
            } else {
                result.setErrorMessage("No client found on this server");
            }
        }
        catch (Exception e) {
            result.setExceptionMessage(e.getMessage());
        }
        finally {
            context.getResultSender().lastResult(result);
        }
    }
}

