/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.functions;

import com.gemstone.gemfire.GemFireIOException;
import com.gemstone.gemfire.cache.Cache;
import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.MBeanJMXAdapter;
import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.i18n.CliStrings;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.util.ReadWriteFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.logging.log4j.Logger;

public class LogFileFunction
implements Function,
InternalEntity {
    private static final Logger logger = LogService.getLogger();
    public static final String ID = LogFileFunction.class.getName();
    private static final long serialVersionUID = 1L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(final FunctionContext context) {
        Thread waiting = new Thread(new Runnable(){

            @Override
            public void run() {
                block17: {
                    boolean isDebugEnabled = logger.isDebugEnabled();
                    try {
                        Cache cache = CacheFactory.getAnyInstance();
                        if (isDebugEnabled) {
                            logger.debug("Exporting logs LogFileFunction");
                        }
                        Object[] args = (Object[])context.getArguments();
                        String targetDirName = (String)args[0];
                        String logLevel = (String)args[1];
                        String onlyLogLevel = (String)args[2];
                        int numOfLogFilesForTesting = ((Number)args[5]).intValue();
                        InternalDistributedSystem ds = (InternalDistributedSystem)cache.getDistributedSystem();
                        if (ds != null && ds.isConnected()) {
                            File targetDir;
                            String filterString;
                            final String filterStr = filterString.substring(0, (filterString = ds.getConfig().getLogFile().getName()).lastIndexOf(".") > 0 ? filterString.lastIndexOf(".") : filterString.length() - 1);
                            File dir = ds.getConfig().getLogFile();
                            if (dir == null) {
                                context.getResultSender().lastResult(CliStrings.format("Could not export log files for member {0}", (Object)ds.getMemberId()));
                                return;
                            }
                            try {
                                dir = dir.getAbsoluteFile();
                            }
                            catch (SecurityException se) {
                                context.getResultSender().lastResult(se.getMessage());
                                return;
                            }
                            String logFileDir = dir.getParent();
                            if (logFileDir == null) {
                                logFileDir = "/";
                            }
                            if (isDebugEnabled) {
                                logger.debug("For member={}: Exporting logs LogFileFunction logFileDir={}, filterStr={}", ds.getMemberId(), logFileDir, filterStr);
                            }
                            dir = new File(logFileDir);
                            FilenameFilter filter = new FilenameFilter(){

                                @Override
                                public boolean accept(File dir, String name) {
                                    return name.startsWith(filterStr) && name.endsWith(".log");
                                }
                            };
                            if (isDebugEnabled) {
                                logger.debug("For member={}: Exporting logs LogFileFunction targetDirName={}", ds.getMemberId(), targetDirName);
                            }
                            if (!(targetDir = new File(targetDirName)).exists()) {
                                if (targetDir.mkdirs()) {
                                    String logsWritten = LogFileFunction.this.processLogs(dir, logFileDir, targetDirName, cache, logLevel, onlyLogLevel, filter, ((Number)args[3]).toString(), ((Number)args[4]).toString(), numOfLogFilesForTesting);
                                    if (isDebugEnabled) {
                                        logger.debug("For member={}: Done with Exporting logs LogFileFunction targetDirName={}", ds.getMemberId(), targetDirName);
                                    }
                                    context.getResultSender().lastResult(logsWritten);
                                } else {
                                    if (isDebugEnabled) {
                                        logger.debug("For member={}{} {}", ds.getMemberId(), "Target Directory {0} cannot be created", targetDirName);
                                    }
                                    context.getResultSender().lastResult(ResultBuilder.createInfoResult(CliStrings.format("Target Directory {0} cannot be created", (Object)targetDir)));
                                }
                            } else {
                                String logsWritten = LogFileFunction.this.processLogs(dir, logFileDir, targetDirName, cache, logLevel, onlyLogLevel, filter, ((Number)args[3]).toString(), ((Number)args[4]).toString(), numOfLogFilesForTesting);
                                if (isDebugEnabled) {
                                    logger.debug("For member={}: Done with Exporting logs LogFileFunction targetDirName={} logsWritten={}", ds.getMemberId(), targetDirName, logsWritten);
                                }
                                context.getResultSender().lastResult(logsWritten);
                            }
                            break block17;
                        }
                        context.getResultSender().lastResult(LocalizedStrings.InternalDistributedSystem_THIS_CONNECTION_TO_A_DISTRIBUTED_SYSTEM_HAS_BEEN_DISCONNECTED.toLocalizedString());
                    }
                    catch (Exception e) {
                        context.getResultSender().lastResult(e.getMessage());
                    }
                }
            }
        });
        try {
            boolean isDebugEnabled = logger.isDebugEnabled();
            if (isDebugEnabled) {
                logger.debug("For member={}: started copying log files", ((InternalDistributedSystem)CacheFactory.getAnyInstance().getDistributedSystem()).getMemberId());
            }
            waiting.start();
            waiting.join();
            if (isDebugEnabled) {
                logger.debug("For member={}: done with Exporting all log files", ((InternalDistributedSystem)CacheFactory.getAnyInstance().getDistributedSystem()).getMemberId());
            }
        }
        catch (Exception e) {
            context.getResultSender().lastResult(e.getMessage());
        }
        finally {
            if (waiting.isAlive()) {
                waiting.interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processLogs(File dir, String logFileDir, String targetDirName, Cache cache, String logLevel, String onlyLogLevel, FilenameFilter filter, String startTime, String endTime, int numOfLogFilesForTesting) {
        try {
            boolean isDebugEnabled = logger.isDebugEnabled();
            String[] logsInDir = dir.list(filter);
            if (isDebugEnabled) {
                logger.debug("LogFileFunction  processLogs logsInDir={} sample={}", logsInDir.length, logsInDir[0]);
            }
            StringBuilder logsWritten = new StringBuilder();
            if (logsInDir.length > 0) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss-ms");
                if (isDebugEnabled) {
                    logger.debug("LogFileFunction  before copy  numOfLogFilesForTesting={}", numOfLogFilesForTesting);
                }
                int i = 0;
                for (int j = 0; i < logsInDir.length && (j < numOfLogFilesForTesting || numOfLogFilesForTesting == 0); ++i, ++j) {
                    String fileName = new String(logFileDir + File.separator + logsInDir[i]);
                    String logToBeWritten = targetDirName + File.separator + MBeanJMXAdapter.getMemberNameOrId(cache.getDistributedSystem().getDistributedMember()) + "_" + logsInDir[i].substring(0, logsInDir[i].length() - 4) + "_" + sdf.format(new Date()) + logsInDir[i].substring(logsInDir[i].length() - 4, logsInDir[i].length());
                    if (isDebugEnabled) {
                        logger.debug("LogFileFunction  processLogs fileName={} logToBeWritten={}", fileName, logToBeWritten);
                    }
                    ArrayList<String> commandList = new ArrayList<String>();
                    commandList.add(System.getProperty("java.home") + File.separatorChar + "bin" + File.separatorChar + "java");
                    commandList.add("-classpath");
                    commandList.add(System.getProperty("java.class.path", "."));
                    commandList.add(ReadWriteFile.class.getName());
                    commandList.add(fileName);
                    commandList.add(logToBeWritten);
                    commandList.add(logLevel);
                    commandList.add(onlyLogLevel);
                    commandList.add(startTime);
                    commandList.add(endTime);
                    ProcessBuilder procBuilder = new ProcessBuilder(commandList);
                    StringBuilder output = new StringBuilder();
                    String errorString = new String();
                    String resultString = new String();
                    try {
                        Process copyLogProcess = procBuilder.redirectErrorStream(true).start();
                        if (isDebugEnabled) {
                            logger.debug("LogFileFunction  processLogs fileName before process waitfor");
                        }
                        int compacterProcessStatus = copyLogProcess.waitFor();
                        if (isDebugEnabled) {
                            logger.debug("LogFileFunction  processLogs fileName after process waitfor destroy compacterProcessStatus={}", compacterProcessStatus);
                        }
                        InputStream inputStream = copyLogProcess.getInputStream();
                        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            output.append(line).append(GfshParser.LINE_SEPARATOR);
                        }
                        copyLogProcess.destroy();
                        if (isDebugEnabled) {
                            logger.debug("LogFileFunction  processLogs fileName after process waitfor after destroy compacterProcessStatus={}", compacterProcessStatus);
                        }
                    }
                    catch (IOException e) {
                        errorString = new GemFireIOException(" Exception in LogFileFunction is " + e, e).toString();
                    }
                    finally {
                        if (errorString != null) {
                            output.append(errorString).append(GfshParser.LINE_SEPARATOR);
                        }
                        resultString = output.toString();
                    }
                    if (resultString.contains("Sucessfully written file")) {
                        if (isDebugEnabled) {
                            logger.debug("LogFileFunction wrote file logToBeWritten={}", logToBeWritten);
                        }
                        logsWritten.append(logToBeWritten + ";");
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    logger.debug("LogFileFunction wrote file logToBeWritten={} resultString={}", logToBeWritten, resultString);
                }
            } else if (isDebugEnabled) {
                logger.debug(CliStrings.format("No file was found for exporting in export logs function", new Object[0]));
            }
            if (isDebugEnabled) {
                logger.debug(CliStrings.format("logsWritten=" + logsWritten, new Object[0]));
            }
            return logsWritten.toString();
        }
        catch (Exception e) {
            return "Exception in LogFileFunction processLogs " + e.getMessage();
        }
    }

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public boolean hasResult() {
        return true;
    }

    @Override
    public boolean optimizeForWrite() {
        return false;
    }

    @Override
    public boolean isHA() {
        return false;
    }
}

