/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.parser;

import com.gemstone.gemfire.management.internal.cli.util.spring.Assert;
import com.gemstone.gemfire.management.internal.cli.util.spring.ObjectUtils;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;
import java.lang.reflect.Method;

public class GfshMethodTarget {
    private final Method method;
    private final Object target;
    private final String remainingBuffer;
    private final String key;

    public GfshMethodTarget(Method method, Object target) {
        this(method, target, null, null);
    }

    public GfshMethodTarget(Method method, Object target, String remainingBuffer, String key2) {
        Assert.notNull(method, "Method is required");
        Assert.notNull(target, "Target is required");
        this.key = StringUtils.trimToEmpty(key2);
        this.method = method;
        this.remainingBuffer = remainingBuffer;
        this.target = target;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        GfshMethodTarget gfshMethodTarget = (GfshMethodTarget)other;
        if (this.method == null ? gfshMethodTarget.getMethod() != null : !this.method.equals(gfshMethodTarget.getMethod())) {
            return false;
        }
        return !(this.target == null ? gfshMethodTarget.getTarget() != null : !this.target.equals(gfshMethodTarget.getTarget()));
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.method, this.target);
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(GfshMethodTarget.class.getSimpleName()).append("[key=" + this.key).append(",remainingBuffer=" + this.remainingBuffer + ",target=" + this.target + ",method=" + this.method + "]");
        return builder.toString();
    }

    public String getKey() {
        return this.key;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getRemainingBuffer() {
        return this.remainingBuffer;
    }

    public Object getTarget() {
        return this.target;
    }
}

