/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.parser.jopt;

import com.gemstone.gemfire.management.internal.cli.MultipleValueConverter;
import com.gemstone.gemfire.management.internal.cli.exceptions.CliCommandOptionException;
import com.gemstone.gemfire.management.internal.cli.exceptions.ExceptionGenerator;
import com.gemstone.gemfire.management.internal.cli.parser.Argument;
import com.gemstone.gemfire.management.internal.cli.parser.GfshOptionParser;
import com.gemstone.gemfire.management.internal.cli.parser.Option;
import com.gemstone.gemfire.management.internal.cli.parser.OptionSet;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.Preprocessor;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.PreprocessorUtils;
import com.gemstone.gemfire.management.internal.cli.parser.preprocessor.TrimmedInput;
import com.gemstone.gemfire.management.internal.cli.util.spring.StringUtils;
import com.gemstone.joptsimple.ArgumentAcceptingOptionSpec;
import com.gemstone.joptsimple.MultipleArgumentsForOptionException;
import com.gemstone.joptsimple.OptionException;
import com.gemstone.joptsimple.OptionParser;
import com.gemstone.joptsimple.OptionSpecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class JoptOptionParser
implements GfshOptionParser {
    private OptionParser parser;
    private LinkedList<Argument> arguments = new LinkedList();
    private LinkedList<Option> options;

    public JoptOptionParser() {
        this.parser = new OptionParser(true);
    }

    @Override
    public void setArguments(LinkedList<Argument> arguments) {
        LinkedList<Argument> optional = new LinkedList<Argument>();
        for (Argument argument : arguments) {
            if (argument.isRequired()) {
                this.arguments.add(argument);
                continue;
            }
            optional.add(argument);
        }
        for (Argument argument : optional) {
            this.arguments.add(argument);
        }
    }

    @Override
    public void setOptions(LinkedList<Option> options) {
        this.options = options;
        for (Option option : options) {
            this.addJoptOptionObject(option);
        }
    }

    private void addJoptOptionObject(Option option) {
        OptionSpecBuilder optionBuilder = null;
        optionBuilder = this.parser.acceptsAll(option.getAggregate(), option.getHelp());
        ArgumentAcceptingOptionSpec<String> argumentSpecs = null;
        argumentSpecs = option.isWithRequiredArgs() ? optionBuilder.withRequiredArg() : optionBuilder.withOptionalArg();
        if (option.isRequired()) {
            argumentSpecs.required();
        }
        if (option.getValueSeparator() != null) {
            argumentSpecs.withValuesSeparatedBy(option.getValueSeparator());
        }
    }

    @Override
    public OptionSet parse(String userInput) throws CliCommandOptionException {
        OptionSet optionSet = new OptionSet();
        optionSet.setUserInput(userInput != null ? userInput.trim() : "");
        if (userInput != null) {
            CliCommandOptionException ce;
            com.gemstone.joptsimple.OptionSet joptOptionSet;
            String[] preProcessedInput;
            TrimmedInput input;
            block21: {
                input = PreprocessorUtils.trim(userInput);
                preProcessedInput = this.preProcess(input.getString());
                joptOptionSet = null;
                ce = null;
                try {
                    joptOptionSet = this.parser.parse(preProcessedInput);
                }
                catch (Exception e) {
                    if (!(e instanceof OptionException)) break block21;
                    ce = this.processException(e);
                    joptOptionSet = ((OptionException)e).getDetected();
                }
            }
            if (joptOptionSet != null) {
                if (joptOptionSet.nonOptionArguments().size() > this.arguments.size()) {
                    String unknownString = joptOptionSet.nonOptionArguments().get(this.arguments.size());
                    if (unknownString.matches("^-*\\w+=.*$")) {
                        unknownString = unknownString.substring(0, unknownString.indexOf(61));
                    }
                    ce = this.processException(OptionException.createUnrecognizedOptionException(unknownString, joptOptionSet));
                }
                StringBuffer argument = new StringBuffer();
                int j = 0;
                for (int i = 0; i < joptOptionSet.nonOptionArguments().size() && j < this.arguments.size(); ++i) {
                    if (!PreprocessorUtils.isSyntaxValid((argument = argument.append(joptOptionSet.nonOptionArguments().get(i))).toString()).booleanValue()) continue;
                    optionSet.put(this.arguments.get(j), argument.toString());
                    ++j;
                    argument.delete(0, argument.length());
                }
                if (argument.length() > 0) {
                    optionSet.put(this.arguments.get(j), argument.toString());
                }
                block3: for (Option option : this.options) {
                    List<String> synonyms = option.getAggregate();
                    for (String string : synonyms) {
                        if (!joptOptionSet.has(string)) continue;
                        boolean present = false;
                        block5: for (String inputSplit : preProcessedInput) {
                            if (!inputSplit.startsWith("--")) continue;
                            inputSplit = StringUtils.removePrefix(inputSplit, "--");
                            if ((inputSplit = StringUtils.removeSuffix(inputSplit, "=")).equals("")) continue;
                            if (option.getLongOption().equals(inputSplit)) {
                                present = true;
                                break;
                            }
                            for (String optionSynonym : option.getSynonyms()) {
                                if (!optionSynonym.equals(inputSplit)) continue;
                                present = true;
                                break block5;
                            }
                        }
                        if (!present) continue;
                        if (joptOptionSet.hasArgument(string)) {
                            List<?> arguments = joptOptionSet.valuesOf(string);
                            if (arguments.size() > 1 && !(option.getConverter() instanceof MultipleValueConverter) && option.getValueSeparator() == null) {
                                ArrayList<String> optionList = new ArrayList<String>(1);
                                optionList.add(string);
                                ce = this.processException(new MultipleArgumentsForOptionException(optionList, joptOptionSet));
                                continue block3;
                            }
                            if (arguments.size() == 1 && !(option.getConverter() instanceof MultipleValueConverter) || option.getValueSeparator() == null) {
                                optionSet.put(option, arguments.get(0).toString().trim());
                                continue block3;
                            }
                            StringBuffer value2 = new StringBuffer();
                            String valueSeparator = option.getValueSeparator();
                            for (Object object : joptOptionSet.valuesOf(string)) {
                                if (value2.length() == 0) {
                                    value2.append((String)object);
                                    continue;
                                }
                                if (valueSeparator != null) {
                                    value2.append(valueSeparator + ((String)object).trim());
                                    continue;
                                }
                                value2.append(((String)object).trim());
                            }
                            optionSet.put(option, value2.toString());
                            continue block3;
                        }
                        optionSet.put(option, option.getSpecifiedDefaultValue());
                        continue block3;
                    }
                }
            }
            ArrayList<String> split = new ArrayList<String>();
            for (int i = 0; i < preProcessedInput.length; ++i) {
                split.add(preProcessedInput[i]);
            }
            optionSet.setNoOfSpacesRemoved(input.getNoOfSpacesRemoved());
            optionSet.setSplit(split);
            if (ce != null) {
                ce.setOptionSet(optionSet);
                throw ce;
            }
        }
        return optionSet;
    }

    private CliCommandOptionException processException(Exception e) {
        CliCommandOptionException ce = null;
        if (e instanceof OptionException && (ce = (CliCommandOptionException)ExceptionGenerator.generate((OptionException)e)) != null && ce instanceof CliCommandOptionException) {
            ce.setOption(this.getOption((OptionException)e));
        }
        return ce;
    }

    private Option getOption(OptionException oe) {
        Option exceptionOption = null;
        Iterator<String> iterator = oe.options().iterator();
        block0: for (Option option : this.options) {
            for (String string : option.getAggregate()) {
                while (iterator.hasNext()) {
                    String joptOption = iterator.next();
                    if (!string.equals(joptOption)) continue;
                    exceptionOption = option;
                    break block0;
                }
            }
        }
        if (exceptionOption == null && oe.options() != null && oe.options().size() > 0) {
            exceptionOption = new Option(oe.options().iterator().next());
        }
        return exceptionOption;
    }

    private String[] preProcess(String userInput) {
        return Preprocessor.split(userInput);
    }

    @Override
    public LinkedList<Argument> getArguments() {
        return this.arguments;
    }

    @Override
    public LinkedList<Option> getOptions() {
        return this.options;
    }
}

