/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.result;

import com.gemstone.gemfire.management.internal.cli.json.GfJsonArray;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonException;
import com.gemstone.gemfire.management.internal.cli.json.GfJsonObject;
import com.gemstone.gemfire.management.internal.cli.result.AbstractResultData;
import com.gemstone.gemfire.management.internal.cli.result.CliJsonSerializable;
import com.gemstone.gemfire.management.internal.cli.result.CliJsonSerializableFactory;
import com.gemstone.gemfire.management.internal.cli.result.ResultDataException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ObjectResultData<T extends CliJsonSerializable>
extends AbstractResultData {
    public static final String OBJECTS_ACCESSOR = "__objects__";

    ObjectResultData() {
    }

    ObjectResultData(GfJsonObject gfJsonObject) {
        super(gfJsonObject);
    }

    @Override
    public String getType() {
        return "object";
    }

    public ObjectResultData<T> addObject(T infoBean) {
        try {
            this.contentObject.accumulateAsJSONObject(OBJECTS_ACCESSOR, infoBean);
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return this;
    }

    public ObjectResultData<T> addCollection(Collection<T> infoBeans) {
        for (CliJsonSerializable infoBean : infoBeans) {
            try {
                this.contentObject.accumulateAsJSONObject(OBJECTS_ACCESSOR, infoBean);
            }
            catch (GfJsonException e) {
                throw new ResultDataException(e.getMessage());
            }
        }
        return this;
    }

    public List<CliJsonSerializable> getAllObjects() {
        ArrayList<CliJsonSerializable> list = new ArrayList<CliJsonSerializable>();
        try {
            GfJsonArray rootJsonArray = this.contentObject.getJSONArray(OBJECTS_ACCESSOR);
            int size2 = rootJsonArray.size();
            GfJsonObject jsonObject = null;
            CliJsonSerializable cliJsonSerializable = null;
            for (int i = 0; i < size2; ++i) {
                jsonObject = rootJsonArray.getJSONObject(i);
                cliJsonSerializable = CliJsonSerializableFactory.getCliJsonSerializable(jsonObject.getInt("JSId"));
                cliJsonSerializable.fromJson(jsonObject);
                list.add(cliJsonSerializable);
            }
        }
        catch (GfJsonException e) {
            throw new ResultDataException(e.getMessage());
        }
        return list;
    }
}

