/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.result;

import com.gemstone.gemfire.management.internal.cli.GfshParser;
import com.gemstone.gemfire.management.internal.cli.result.TableBuilderHelper;
import java.util.ArrayList;
import java.util.List;

public class TableBuilder {
    public static Table newTable() {
        return new Table();
    }

    private static class Column {
        private final Align align;
        private final String stringValue;

        private Column(Object value2, Align align) {
            this.stringValue = value2 == null ? "" : value2.toString();
            this.align = align;
        }

        private int getLength() {
            return this.stringValue.length();
        }

        private String buildColumn(int colWidth, boolean trimIt) {
            if (this.stringValue.length() > colWidth) {
                StringBuffer stringBuffer = new StringBuffer();
                int endIndex = colWidth - 2;
                if (endIndex < 0) {
                    return "";
                }
                return stringBuffer.append(this.stringValue.substring(0, endIndex)).append("..").toString();
            }
            int numSpaces = colWidth - this.stringValue.length();
            if (trimIt) {
                numSpaces = 0;
            }
            StringBuffer stringBuffer = new StringBuffer();
            switch (this.align) {
                case LEFT: {
                    stringBuffer.append(this.stringValue);
                    for (int i = 0; i < numSpaces; ++i) {
                        stringBuffer.append(" ");
                    }
                    break;
                }
                case RIGHT: {
                    for (int i = 0; i < numSpaces; ++i) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(this.stringValue);
                    break;
                }
                case CENTER: {
                    int i;
                    for (i = 0; i < numSpaces / 2; ++i) {
                        stringBuffer.append(" ");
                    }
                    stringBuffer.append(this.stringValue);
                    while (i < numSpaces) {
                        stringBuffer.append(" ");
                        ++i;
                    }
                    break;
                }
            }
            return stringBuffer.toString();
        }

        private String buildColumn(int colWidth) {
            return this.buildColumn(colWidth, false);
        }

        public String toString() {
            return "Column [align=" + (Object)((Object)this.align) + ", stringValue=" + this.stringValue + "]";
        }
    }

    private static enum Align {
        LEFT,
        RIGHT,
        CENTER;

    }

    public static class Row {
        private final RowGroup rowGroup;
        private final Character rowSeparator;
        private final List<Column> columns = new ArrayList<Column>();
        boolean isBlank;
        private boolean isTablewideSeparator;
        private String columnSeparator;

        private Row(RowGroup rowGroup) {
            this.rowGroup = rowGroup;
            this.rowSeparator = null;
        }

        private Row(RowGroup rowGroup, Character rowSeparator, boolean isTablewideSeparator) {
            this.rowGroup = rowGroup;
            this.rowSeparator = rowSeparator;
            this.isTablewideSeparator = isTablewideSeparator;
        }

        public Row newLeftCol(Object value2) {
            Column column = new Column(value2, Align.LEFT);
            this.columns.add(column);
            return this;
        }

        public Row newRightCol(Object value2) {
            Column column = new Column(value2, Align.RIGHT);
            this.columns.add(column);
            return this;
        }

        public Row newCenterCol(Object value2) {
            Column column = new Column(value2, Align.CENTER);
            this.columns.add(column);
            return this;
        }

        public boolean isEmpty() {
            return this.columns.isEmpty();
        }

        private int getNumCols() {
            return this.columns.size();
        }

        private int getMaxColLength(int colNum) {
            if (colNum >= this.columns.size()) {
                return 0;
            }
            return this.columns.get(colNum).getLength();
        }

        public void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        public String getColumnSeparator() {
            return this.columnSeparator != null ? this.columnSeparator : this.rowGroup.getColumnSeparator();
        }

        private String buildRow(boolean isTabularResult) {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.rowSeparator != null) {
                if (this.isTablewideSeparator) {
                    int maxColLength = this.rowGroup.getTable().getMaxLength();
                    if (isTabularResult) {
                        maxColLength = TableBuilderHelper.trimWidthForScreen(maxColLength);
                    }
                    for (int j = 0; j < maxColLength; ++j) {
                        stringBuffer.append(this.rowSeparator);
                    }
                } else {
                    int maxNumCols = this.rowGroup.getNumCols();
                    for (int i = 0; i < maxNumCols; ++i) {
                        int maxColLength = this.rowGroup.getColSize(i);
                        for (int j = 0; j < maxColLength; ++j) {
                            stringBuffer.append(this.rowSeparator);
                        }
                        if (i >= maxNumCols - 1) continue;
                        stringBuffer.append(this.rowGroup.getColumnSeparator());
                    }
                }
            } else {
                for (int i = 0; i < this.columns.size(); ++i) {
                    boolean lastColumn = i >= this.columns.size() - 1;
                    stringBuffer.append(this.columns.get(i).buildColumn(this.rowGroup.getColSize(i), lastColumn));
                    if (lastColumn) continue;
                    stringBuffer.append(this.getColumnSeparator());
                }
            }
            return stringBuffer.toString();
        }

        public String toString() {
            return "Row [columns=" + this.columns + "]";
        }
    }

    public static class RowGroup {
        private final Table table;
        private final List<Row> rows = new ArrayList<Row>();
        private int[] colSizes;
        private String columnSeparator;

        private RowGroup(Table table) {
            this.table = table;
        }

        private Table getTable() {
            return this.table;
        }

        public Row newRow() {
            Row row = new Row(this);
            this.rows.add(row);
            return row;
        }

        public void newRowSeparator(Character character, boolean isTablewideSeparator) {
            Row row = new Row(this, character, isTablewideSeparator);
            this.rows.add(row);
        }

        public void newBlankRow() {
            Row row = this.newRow();
            row.newCenterCol("");
            row.isBlank = true;
        }

        public String buildRowGroup(boolean isTabularResult) {
            this.colSizes = this.computeColSizes(isTabularResult);
            StringBuffer stringBuffer = new StringBuffer();
            for (Row row : this.rows) {
                String builtRow = row.buildRow(isTabularResult);
                stringBuffer.append(builtRow);
                if (builtRow.trim().isEmpty() && !row.isBlank) continue;
                stringBuffer.append(GfshParser.LINE_SEPARATOR);
            }
            return stringBuffer.toString();
        }

        private int getColSize(int colNum) {
            return this.colSizes[colNum];
        }

        private int[] computeColSizes(boolean isTabularResult) {
            int[] localColSizes = new int[this.getNumCols()];
            for (int i = 0; i < localColSizes.length; ++i) {
                localColSizes[i] = this.getMaxColLength(i);
            }
            if (isTabularResult) {
                localColSizes = TableBuilderHelper.recalculateColSizesForScreen(TableBuilderHelper.getScreenWidth(), localColSizes, this.getColumnSeparator());
            }
            return localColSizes;
        }

        private int getNumCols() {
            int maxNumCols = 0;
            for (Row row : this.rows) {
                int numCols = row.getNumCols();
                if (numCols <= maxNumCols) continue;
                maxNumCols = numCols;
            }
            return maxNumCols;
        }

        private int getMaxColLength(int colNum) {
            int maxLength = 0;
            for (Row row : this.rows) {
                int colLength = row.getMaxColLength(colNum);
                if (colLength <= maxLength) continue;
                maxLength = colLength;
            }
            return maxLength;
        }

        public void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        public String getColumnSeparator() {
            return this.columnSeparator != null ? this.columnSeparator : this.table.getColumnSeparator();
        }

        public String toString() {
            return "RowGroup [rows=" + this.rows + "]";
        }
    }

    public static class Table {
        private final List<RowGroup> rowGroups = new ArrayList<RowGroup>();
        private String columnSeparator = "   ";
        private boolean isTabularResult = false;

        public void setTabularResult(boolean isTabularResult) {
            this.isTabularResult = isTabularResult;
        }

        public void setColumnSeparator(String columnSeparator) {
            this.columnSeparator = columnSeparator;
        }

        public String getColumnSeparator() {
            return this.columnSeparator;
        }

        public RowGroup newRowGroup() {
            RowGroup rowGroup = new RowGroup(this);
            this.rowGroups.add(rowGroup);
            return rowGroup;
        }

        public Row newRow() {
            RowGroup rowGroup = this.newRowGroup();
            return rowGroup.newRow();
        }

        public void newBlankRow() {
            RowGroup rowGroup = this.newRowGroup();
            rowGroup.newBlankRow();
        }

        private int getMaxLength() {
            int rowGroupMaxTotalLength = 0;
            for (RowGroup rowGroup : this.rowGroups) {
                List rows = rowGroup.rows;
                int rowGroupTotalLength = 0;
                int rowMaxTotalLength = 0;
                for (Row row : rows) {
                    int rowTotalLength = 0;
                    for (int i = 0; i < row.getNumCols(); ++i) {
                        rowTotalLength += row.getMaxColLength(i);
                    }
                    if (rowGroup.getColumnSeparator() != null) {
                        rowTotalLength += row.getNumCols() * rowGroup.getColumnSeparator().length();
                    }
                    if (rowMaxTotalLength >= rowTotalLength) continue;
                    rowMaxTotalLength = rowTotalLength;
                }
                if (rowGroupMaxTotalLength >= (rowGroupTotalLength += rowMaxTotalLength)) continue;
                rowGroupMaxTotalLength = rowGroupTotalLength;
            }
            return (int)((double)rowGroupMaxTotalLength * 1.1);
        }

        public String buildTable() {
            StringBuffer stringBuffer = new StringBuffer();
            for (RowGroup rowGroup : this.rowGroups) {
                stringBuffer.append(rowGroup.buildRowGroup(this.isTabularResult));
            }
            return stringBuffer.toString();
        }

        public List<String> buildTableList() {
            ArrayList<String> list = new ArrayList<String>();
            for (RowGroup rowGroup : this.rowGroups) {
                list.add(rowGroup.buildRowGroup(this.isTabularResult));
            }
            return list;
        }

        public String toString() {
            return "Table [rowGroups=" + this.rowGroups + "]";
        }
    }
}

