/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.shell;

import com.gemstone.gemfire.management.cli.Result;
import com.gemstone.gemfire.management.internal.cli.LogWrapper;
import com.gemstone.gemfire.management.internal.cli.result.CompositeResultData;
import com.gemstone.gemfire.management.internal.cli.result.ResultBuilder;
import com.gemstone.gemfire.management.internal.cli.shell.Gfsh;
import java.util.ArrayList;
import java.util.List;

class ScriptExecutionDetails {
    private final String filePath;
    private final List<CommandAndStatus> commandAndStatusList;

    ScriptExecutionDetails(String filePath) {
        this.filePath = filePath;
        this.commandAndStatusList = new ArrayList<CommandAndStatus>();
    }

    void addCommandAndStatus(String command, String status) {
        this.commandAndStatusList.add(new CommandAndStatus(command, status));
    }

    Result getResult() {
        CompositeResultData compositeResultData = ResultBuilder.createCompositeResultData();
        compositeResultData.setHeader("************************* Execution Summary ***********************\nScript file: " + this.filePath);
        for (int i = 0; i < this.commandAndStatusList.size(); ++i) {
            int commandSrNo = i + 1;
            CompositeResultData.SectionResultData section = compositeResultData.addSection("" + (i + 1));
            CommandAndStatus commandAndStatus = this.commandAndStatusList.get(i);
            section.addData("Command-" + String.valueOf(commandSrNo), commandAndStatus.command);
            section.addData("Status", commandAndStatus.status);
            if (i == this.commandAndStatusList.size()) continue;
            section.setFooter(Gfsh.LINE_SEPARATOR);
        }
        return ResultBuilder.buildResult(compositeResultData);
    }

    void logScriptExecutionInfo(LogWrapper logWrapper, Result result) {
        logWrapper.info(ResultBuilder.resultAsString(result));
    }

    static class CommandAndStatus {
        private final String command;
        private final String status;

        public CommandAndStatus(String command, String status) {
            this.command = command;
            this.status = status;
        }

        public String toString() {
            return this.command + "     " + this.status;
        }
    }
}

