/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.shell.jline;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import jline.UnixTerminal;

public class CygwinMinttyTerminal
extends UnixTerminal {
    String encoding = System.getProperty("input.encoding", "UTF-8");
    ReplayPrefixOneCharInputStream replayStream = new ReplayPrefixOneCharInputStream(this.encoding);
    InputStreamReader replayReader;

    public CygwinMinttyTerminal() {
        try {
            this.replayReader = new InputStreamReader((InputStream)this.replayStream, this.encoding);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void initializeTerminal() throws IOException, InterruptedException {
    }

    public void restoreTerminal() throws Exception {
        CygwinMinttyTerminal.resetTerminal();
    }

    public int readVirtualKey(InputStream in) throws IOException {
        int c = this.readCharacter(in);
        if (c == 127) {
            c = 8;
        } else if (c == 8) {
            c = 127;
        }
        if (c == 27 && in.available() > 0) {
            while (c == 27) {
                c = this.readCharacter(in);
            }
            if (c == 91 || c == 79) {
                c = this.readCharacter(in);
                if (c == 65) {
                    return 16;
                }
                if (c == 66) {
                    return 14;
                }
                if (c == 68) {
                    return 2;
                }
                if (c == 67) {
                    return 6;
                }
                if (c == 72) {
                    return 1;
                }
                if (c == 70) {
                    return 5;
                }
                if (c == 51) {
                    c = this.readCharacter(in);
                    return 127;
                }
            }
        }
        if (c > 128) {
            this.replayStream.setInput(c, in);
            c = this.replayReader.read();
        }
        return c;
    }

    static class ReplayPrefixOneCharInputStream
    extends InputStream {
        byte firstByte;
        int byteLength;
        InputStream wrappedStream;
        int byteRead;
        final String encoding;

        public ReplayPrefixOneCharInputStream(String encoding) {
            this.encoding = encoding;
        }

        public void setInput(int recorded, InputStream wrapped) throws IOException {
            this.byteRead = 0;
            this.firstByte = (byte)recorded;
            this.wrappedStream = wrapped;
            this.byteLength = 1;
            if (this.encoding.equalsIgnoreCase("UTF-8")) {
                this.setInputUTF8(recorded, wrapped);
            } else if (this.encoding.equalsIgnoreCase("UTF-16")) {
                this.byteLength = 2;
            } else if (this.encoding.equalsIgnoreCase("UTF-32")) {
                this.byteLength = 4;
            }
        }

        public void setInputUTF8(int recorded, InputStream wrapped) throws IOException {
            if ((this.firstByte & 0xFFFFFFE0) == -64) {
                this.byteLength = 2;
            } else if ((this.firstByte & 0xFFFFFFF0) == -32) {
                this.byteLength = 3;
            } else if ((this.firstByte & 0xFFFFFFF8) == -16) {
                this.byteLength = 4;
            } else {
                throw new IOException("invalid UTF-8 first byte: " + this.firstByte);
            }
        }

        @Override
        public int read() throws IOException {
            if (this.available() == 0) {
                return -1;
            }
            ++this.byteRead;
            if (this.byteRead == 1) {
                return this.firstByte;
            }
            return this.wrappedStream.read();
        }

        @Override
        public int available() {
            return this.byteLength - this.byteRead;
        }
    }
}

