/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.cli.util.spring;

public class ObjectUtils {
    private static final int INITIAL_HASH = 7;
    private static final int MULTIPLIER = 31;

    public static int nullSafeHashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        if (obj.getClass().isArray()) {
            if (obj instanceof Object[]) {
                return ObjectUtils.nullSafeHashCode((Object[])obj);
            }
            if (obj instanceof boolean[]) {
                return ObjectUtils.nullSafeHashCode((boolean[])obj);
            }
            if (obj instanceof byte[]) {
                return ObjectUtils.nullSafeHashCode((byte[])obj);
            }
            if (obj instanceof char[]) {
                return ObjectUtils.nullSafeHashCode((char[])obj);
            }
            if (obj instanceof double[]) {
                return ObjectUtils.nullSafeHashCode((double[])obj);
            }
            if (obj instanceof float[]) {
                return ObjectUtils.nullSafeHashCode((float[])obj);
            }
            if (obj instanceof int[]) {
                return ObjectUtils.nullSafeHashCode((int[])obj);
            }
            if (obj instanceof long[]) {
                return ObjectUtils.nullSafeHashCode((long[])obj);
            }
            if (obj instanceof short[]) {
                return ObjectUtils.nullSafeHashCode((short[])obj);
            }
        }
        return obj.hashCode();
    }

    public static int nullSafeHashCode(Object ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        for (Object element : array) {
            hash = 31 * hash + ObjectUtils.nullSafeHashCode(element);
        }
        return hash;
    }

    public static int nullSafeHashCode(boolean ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(byte ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(char ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(double ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(float ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(int ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int nullSafeHashCode(long ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + ObjectUtils.hashCode(array[i]);
        }
        return hash;
    }

    public static int nullSafeHashCode(short ... array) {
        if (array == null) {
            return 0;
        }
        int hash = 7;
        int arraySize = array.length;
        for (int i = 0; i < arraySize; ++i) {
            hash = 31 * hash + array[i];
        }
        return hash;
    }

    public static int hashCode(boolean bool) {
        return Boolean.valueOf(bool).hashCode();
    }

    public static int hashCode(double dbl) {
        long bits = Double.doubleToLongBits(dbl);
        return ObjectUtils.hashCode(bits);
    }

    public static int hashCode(float flt) {
        return Float.floatToIntBits(flt);
    }

    public static int hashCode(long lng) {
        return (int)(lng ^ lng >>> 32);
    }
}

