/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.configuration;

import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.management.internal.cli.CliUtil;
import com.gemstone.gemfire.management.internal.configuration.domain.ConfigurationChangeResult;
import com.gemstone.gemfire.management.internal.configuration.domain.XmlEntity;
import com.gemstone.gemfire.management.internal.configuration.functions.AddJarFunction;
import com.gemstone.gemfire.management.internal.configuration.functions.AddXmlEntityFunction;
import com.gemstone.gemfire.management.internal.configuration.functions.DeleteJarFunction;
import com.gemstone.gemfire.management.internal.configuration.functions.DeleteXmlEntityFunction;
import com.gemstone.gemfire.management.internal.configuration.functions.ModifyPropertiesFunction;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.logging.log4j.Logger;

public class SharedConfigurationWriter {
    private static final Logger logger = LogService.getLogger();
    private GemFireCacheImpl cache;
    private final AddJarFunction saveJarFunction = new AddJarFunction();
    private final DeleteJarFunction deleteJarFunction = new DeleteJarFunction();
    private final AddXmlEntityFunction addXmlEntityFunction = new AddXmlEntityFunction();
    private final DeleteXmlEntityFunction deleteXmlEntityFunction = new DeleteXmlEntityFunction();
    private final ModifyPropertiesFunction modifyPropertiesFunction = new ModifyPropertiesFunction();
    private boolean isSharedConfigEnabled;

    public SharedConfigurationWriter() {
        this.cache = GemFireCacheImpl.getInstance();
        this.isSharedConfigEnabled = this.cache.getDistributionManager().isSharedConfigurationServiceEnabledForDS();
    }

    public boolean addXmlEntity(XmlEntity xmlEntity, String[] groups) {
        Object[] args = new Object[]{xmlEntity, groups};
        return this.saveConfigChanges(this.addXmlEntityFunction, args);
    }

    public boolean deleteXmlEntity(XmlEntity xmlEntity, String[] groups) {
        Object[] args = new Object[]{xmlEntity, groups};
        return this.saveConfigChanges(this.deleteXmlEntityFunction, args);
    }

    public boolean modifyPropertiesAndCacheAttributes(Properties properties, XmlEntity xmlEntity, String[] groups) {
        Object[] args = new Object[]{properties, xmlEntity, groups};
        return this.saveConfigChanges(this.modifyPropertiesFunction, args);
    }

    public boolean addJars(String[] jarNames, byte[][] jarBytes, String[] groups) {
        Object[] args = new Object[]{jarNames, jarBytes, groups};
        return this.saveConfigChangesAllLocators(this.saveJarFunction, args);
    }

    public boolean deleteJars(String[] jarNames, String[] groups) {
        Object[] args = new Object[3];
        args[0] = jarNames;
        args[1] = groups;
        return this.saveConfigChangesAllLocators(this.deleteJarFunction, args);
    }

    private boolean saveConfigChanges(Function function, Object[] args) {
        if (!this.isSharedConfigEnabled) {
            return true;
        }
        boolean success = false;
        HashSet<InternalDistributedMember> locators = new HashSet<InternalDistributedMember>(this.cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        if (!locators.isEmpty()) {
            for (DistributedMember distributedMember : locators) {
                ResultCollector<?, ?> rc = CliUtil.executeFunction(function, (Object)args, distributedMember);
                List results = (List)rc.getResult();
                if (results.isEmpty()) continue;
                ConfigurationChangeResult configChangeResult = (ConfigurationChangeResult)results.get(0);
                if (configChangeResult.isSuccessful()) {
                    logger.info("Configuration change successful");
                    success = true;
                    break;
                }
                logger.info("Failed to save the configuration change. {}", configChangeResult);
                success = false;
            }
        }
        return success;
    }

    private boolean saveConfigChangesAllLocators(Function function, Object[] args) {
        ResultCollector<?, ?> rc;
        List results;
        if (!this.isSharedConfigEnabled) {
            return true;
        }
        boolean success = true;
        HashSet<DistributedMember> locators = new HashSet<DistributedMember>(this.cache.getDistributionManager().getAllHostedLocatorsWithSharedConfiguration().keySet());
        if (!locators.isEmpty() && !(results = (List)(rc = CliUtil.executeFunction(function, (Object)args, locators)).getResult()).isEmpty()) {
            for (ConfigurationChangeResult configChangeResult : results) {
                if (configChangeResult.isSuccessful()) continue;
                success = false;
                break;
            }
        }
        return success;
    }
}

