/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.configuration.domain;

import com.gemstone.gemfire.internal.cache.xmlcache.CacheXmlParser;
import com.gemstone.gemfire.management.internal.configuration.utils.XmlUtils;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParsingException;
import nu.xom.ValidityException;
import nu.xom.XPathContext;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class CacheElement {
    static final String XSD_PREFIX = "xsd";
    private static final String XSD_ALL_CHILDREN = "xsd:element";
    private static final String XSD_COMPLEX_TYPE_CHILDREN = "xsd:group|xsd:all|xsd:choice|xsd:sequence";
    private static final String XSD_CHOICE_OR_SEQUENCE_CHILDREN = "xsd:element|xsd:group|xsd:choice|xsd:sequence|xsd:any";
    static final String CACHE_TYPE_EMBEDDED = "/xsd:schema/xsd:element[@name='cache']/xsd:complexType";
    private String name;
    private int order;
    private boolean multiple;

    public CacheElement(String name, int rank, boolean multiple) {
        this.name = name;
        this.order = rank;
        this.multiple = multiple;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    public static LinkedHashMap<String, CacheElement> buildElementMap(Document doc) throws IOException {
        try {
            Map<String, List<String>> schemaLocationMap = XmlUtils.buildSchemaLocationMap(doc.getRootElement().getAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema-instance"));
            LinkedHashMap<String, CacheElement> elementMap = new LinkedHashMap<String, CacheElement>();
            CacheElement.buildElementMapCacheType(elementMap, CacheElement.resolveSchema(schemaLocationMap, "http://schema.pivotal.io/gemfire/cache"));
            return elementMap;
        }
        catch (ParsingException | SAXException e) {
            throw new IOException(e);
        }
    }

    private static final InputSource resolveSchema(Map<String, List<String>> schemaLocationMap, String namespaceUri) throws IOException {
        CacheXmlParser entityResolver = new CacheXmlParser();
        InputSource inputSource = null;
        List<String> locations = schemaLocationMap.get(namespaceUri);
        for (String location : locations) {
            try {
                inputSource = entityResolver.resolveEntity(null, location);
                if (null == inputSource) continue;
                break;
            }
            catch (SAXException e) {
            }
        }
        if (null == inputSource) {
            inputSource = new InputSource(new URL(namespaceUri).openStream());
        }
        return inputSource;
    }

    private static final void buildElementMapCacheType(LinkedHashMap<String, CacheElement> elementMap, InputSource inputSource) throws SAXException, IOException, ValidityException, ParsingException {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setEntityResolver(new CacheXmlParser());
        Document doc = new Builder(xmlReader).build(inputSource.getByteStream());
        int rank = 0;
        XPathContext xPathContext = new XPathContext(XSD_PREFIX, "http://www.w3.org/2001/XMLSchema");
        Element cacheType = XmlUtils.querySingleElement((Node)doc.getRootElement(), CACHE_TYPE_EMBEDDED, xPathContext);
        rank = CacheElement.buildElementMapXPath(elementMap, doc, cacheType, rank, XSD_COMPLEX_TYPE_CHILDREN, xPathContext);
    }

    private static int buildElementMapXPath(LinkedHashMap<String, CacheElement> elementMap, Document schema, Element parent, int rank, String xPath, XPathContext xPathContext) {
        Nodes children = parent.query(xPath, xPathContext);
        block11: for (int i = 0; i < children.size(); ++i) {
            Element child = (Element)children.get(i);
            switch (child.getQualifiedName()) {
                case "xsd:element": {
                    String name = child.getAttributeValue("name");
                    elementMap.put(name, new CacheElement(name, rank++, CacheElement.isMultiple(child)));
                    continue block11;
                }
                case "xsd:choice": 
                case "xsd:sequence": {
                    rank = CacheElement.buildElementMapXPath(elementMap, schema, child, rank, XSD_CHOICE_OR_SEQUENCE_CHILDREN, xPathContext);
                    continue block11;
                }
                case "xsd:any": {
                    continue block11;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported child type '" + child.getQualifiedName() + "'");
                }
            }
        }
        return rank;
    }

    private static boolean isMultiple(Element element) {
        String maxOccurs = element.getAttributeValue("maxOccurs");
        return null != maxOccurs && !maxOccurs.equals("1");
    }
}

