/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.management.internal.configuration.functions;

import com.gemstone.gemfire.cache.execute.FunctionAdapter;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.distributed.Locator;
import com.gemstone.gemfire.distributed.internal.InternalLocator;
import com.gemstone.gemfire.distributed.internal.SharedConfiguration;
import com.gemstone.gemfire.internal.InternalEntity;
import com.gemstone.gemfire.management.internal.configuration.domain.Configuration;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class GetAllJarsFunction
extends FunctionAdapter
implements InternalEntity {
    private static final long serialVersionUID = 1L;

    @Override
    public void execute(FunctionContext context) {
        SharedConfiguration sharedConfig;
        InternalLocator locator = (InternalLocator)Locator.getLocator();
        if (locator != null && (sharedConfig = locator.getSharedConfiguration()) != null) {
            try {
                Map<String, Configuration> entireConfig = sharedConfig.getEntireConfiguration();
                Set<String> configNames = entireConfig.keySet();
                context.getResultSender().lastResult(sharedConfig.getAllJars(configNames));
            }
            catch (IOException e) {
                context.getResultSender().sendException(e);
            }
            catch (Exception e) {
                context.getResultSender().sendException(e);
            }
        }
        context.getResultSender().lastResult(null);
    }

    @Override
    public String getId() {
        return GetAllJarsFunction.class.getName();
    }
}

