/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class WeakConcurrentIdentityHashMap<K, V> {
    private final Map<WeakReference<K>, V> map = new ConcurrentHashMap<WeakReference<K>, V>();
    private final ReferenceQueue<K> refQueue = new ReferenceQueue();

    private WeakConcurrentIdentityHashMap() {
    }

    static <K, V> WeakConcurrentIdentityHashMap<K, V> make() {
        return new WeakConcurrentIdentityHashMap<K, V>();
    }

    public V get(K key2) {
        this.expunge();
        WeakReference<K> keyref = this.makeReference(key2);
        return this.map.get(keyref);
    }

    public V put(K key2, V value2) {
        this.expunge();
        if (key2 == null) {
            throw new IllegalArgumentException("Null key");
        }
        WeakReference<K> keyref = this.makeReference(key2, this.refQueue);
        return this.map.put(keyref, value2);
    }

    public V remove(K key2) {
        this.expunge();
        WeakReference<K> keyref = this.makeReference(key2);
        return this.map.remove(keyref);
    }

    private void expunge() {
        Reference<K> ref;
        while ((ref = this.refQueue.poll()) != null) {
            this.map.remove(ref);
        }
    }

    private WeakReference<K> makeReference(K referent) {
        return new IdentityWeakReference<K>(referent);
    }

    private WeakReference<K> makeReference(K referent, ReferenceQueue<K> q) {
        return new IdentityWeakReference<K>(referent, q);
    }

    public void clear() {
        this.expunge();
        this.map.clear();
    }

    private static class IdentityWeakReference<T>
    extends WeakReference<T> {
        private final int hashCode;

        IdentityWeakReference(T o) {
            this(o, (ReferenceQueue<T>)null);
        }

        IdentityWeakReference(T o, ReferenceQueue<T> q) {
            super(o, q);
            this.hashCode = o == null ? 0 : System.identityHashCode(o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IdentityWeakReference)) {
                return false;
            }
            IdentityWeakReference wr = (IdentityWeakReference)o;
            Object got = this.get();
            return got != null && got == wr.get();
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

