/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal;

import com.gemstone.gemfire.InternalGemFireException;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.pdx.PdxFieldDoesNotExistException;
import com.gemstone.gemfire.pdx.PdxFieldTypeMismatchException;
import com.gemstone.gemfire.pdx.WritablePdxInstance;
import com.gemstone.gemfire.pdx.internal.PdxField;
import com.gemstone.gemfire.pdx.internal.PdxInstanceImpl;
import com.gemstone.gemfire.pdx.internal.PdxOutputStream;
import com.gemstone.gemfire.pdx.internal.PdxReaderImpl;
import com.gemstone.gemfire.pdx.internal.PdxType;
import com.gemstone.gemfire.pdx.internal.PdxWriterImpl;
import com.gemstone.gemfire.pdx.internal.TypeRegistry;
import java.nio.ByteBuffer;
import java.util.Date;

public class WritablePdxInstanceImpl
extends PdxInstanceImpl
implements WritablePdxInstance {
    private static final long serialVersionUID = 7398999150097596214L;
    private static final Object NULL_TOKEN = new Object();
    private Object[] dirtyFields = null;

    public WritablePdxInstanceImpl(PdxReaderImpl original) {
        super(original);
    }

    private synchronized void dirtyField(PdxField f, Object value2) {
        if (this.dirtyFields == null) {
            this.dirtyFields = new Object[this.getPdxType().getFieldCount()];
        }
        if (value2 == null) {
            value2 = NULL_TOKEN;
        }
        this.dirtyFields[f.getFieldIndex()] = value2;
        this.clearCachedState();
    }

    @Override
    protected synchronized PdxReaderImpl getUnmodifiableReader(String fieldName) {
        PdxField f;
        if (this.dirtyFields != null && (f = this.getPdxType().getPdxField(fieldName)) != null && this.dirtyFields[f.getFieldIndex()] != null) {
            return this.getUnmodifiableReader();
        }
        return new PdxReaderImpl(this);
    }

    @Override
    public synchronized Object getCachedObject() {
        return super.getCachedObject();
    }

    @Override
    public synchronized int hashCode() {
        return super.hashCode();
    }

    @Override
    protected synchronized PdxReaderImpl getUnmodifiableReader() {
        if (this.dirtyFields != null) {
            PdxWriterImpl writer;
            PdxOutputStream os = new PdxOutputStream(this.basicSize() + 9);
            if (this.getPdxType().getHasDeletedField()) {
                PdxType pt = new PdxType(this.getPdxType().getClassName(), !this.getPdxType().getNoDomainClass());
                GemFireCacheImpl gfc = GemFireCacheImpl.getForPdx("PDX registry is unavailable because the Cache has been closed.");
                TypeRegistry tr = gfc.getPdxRegistry();
                writer = new PdxWriterImpl(pt, tr, os);
            } else {
                writer = new PdxWriterImpl(this.getPdxType(), os);
            }
            for (PdxField f : this.getPdxType().getFields()) {
                if (f.isDeleted()) continue;
                Object dv = this.dirtyFields[f.getFieldIndex()];
                if (dv != null) {
                    if (dv == NULL_TOKEN) {
                        dv = null;
                    }
                    writer.writeField(f, dv);
                    continue;
                }
                writer.writeRawField(f, this.getRaw(f));
            }
            writer.completeByteStreamGeneration();
            ByteBuffer bb = os.toByteBuffer();
            bb.position(9);
            this.basicSetBuffer(bb.slice());
            this.dirtyFields = null;
        }
        return new PdxReaderImpl(this);
    }

    @Override
    public void setField(String fieldName, Object value2) {
        PdxField f;
        block58: {
            block57: {
                f = this.getPdxType().getPdxField(fieldName);
                if (f == null) {
                    throw new PdxFieldDoesNotExistException("A field named " + fieldName + " does not exist on " + this.getPdxType());
                }
                if (value2 == null) break block57;
                switch (f.getFieldType()) {
                    case CHAR: {
                        if (!(value2 instanceof Character)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Character but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case BOOLEAN: {
                        if (!(value2 instanceof Boolean)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Boolean but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case BYTE: {
                        if (!(value2 instanceof Byte)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Byte but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case SHORT: {
                        if (!(value2 instanceof Short)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Short but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case INT: {
                        if (!(value2 instanceof Integer)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Integer but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case LONG: {
                        if (!(value2 instanceof Long)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Long but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case FLOAT: {
                        if (!(value2 instanceof Float)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Float but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case DOUBLE: {
                        if (!(value2 instanceof Double)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Double but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case STRING: {
                        if (!(value2 instanceof String)) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a String but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case BOOLEAN_ARRAY: {
                        if (!(value2 instanceof boolean[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a boolean[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case CHAR_ARRAY: {
                        if (!(value2 instanceof char[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a char[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case BYTE_ARRAY: {
                        if (!(value2 instanceof byte[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a byte[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case SHORT_ARRAY: {
                        if (!(value2 instanceof short[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a short[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case INT_ARRAY: {
                        if (!(value2 instanceof int[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a int[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case LONG_ARRAY: {
                        if (!(value2 instanceof long[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a long[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case FLOAT_ARRAY: {
                        if (!(value2 instanceof float[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a float[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case DOUBLE_ARRAY: {
                        if (!(value2 instanceof double[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a double[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case STRING_ARRAY: {
                        if (!(value2 instanceof String[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a String[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case ARRAY_OF_BYTE_ARRAYS: {
                        if (!(value2 instanceof byte[][])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a byte[][] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case OBJECT_ARRAY: {
                        if (!(value2 instanceof Object[])) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Object[] but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    case OBJECT: {
                        break block58;
                    }
                    case DATE: {
                        if (!Date.class.equals(value2.getClass())) {
                            throw new PdxFieldTypeMismatchException("Values for this field must be a Date but was a " + value2.getClass());
                        }
                        break block58;
                    }
                    default: {
                        throw new InternalGemFireException("Unhandled field type " + (Object)((Object)f.getFieldType()));
                    }
                }
            }
            switch (f.getFieldType()) {
                case CHAR: {
                    value2 = Character.valueOf('\u0000');
                    break;
                }
                case BOOLEAN: {
                    value2 = false;
                    break;
                }
                case BYTE: {
                    value2 = (byte)0;
                    break;
                }
                case SHORT: {
                    value2 = (short)0;
                    break;
                }
                case INT: {
                    value2 = 0;
                    break;
                }
                case FLOAT: {
                    value2 = Float.valueOf(0.0f);
                    break;
                }
                case DOUBLE: {
                    value2 = 0.0;
                    break;
                }
                case LONG: {
                    value2 = 0L;
                    break;
                }
                case STRING: 
                case BOOLEAN_ARRAY: 
                case CHAR_ARRAY: 
                case BYTE_ARRAY: 
                case SHORT_ARRAY: 
                case INT_ARRAY: 
                case LONG_ARRAY: 
                case FLOAT_ARRAY: 
                case DOUBLE_ARRAY: 
                case STRING_ARRAY: 
                case ARRAY_OF_BYTE_ARRAYS: 
                case OBJECT_ARRAY: 
                case OBJECT: 
                case DATE: {
                    break;
                }
                default: {
                    throw new InternalGemFireException("Unhandled field type " + (Object)((Object)f.getFieldType()));
                }
            }
        }
        this.dirtyField(f, value2);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

