/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal.json;

import com.gemstone.gemfire.cache.CacheFactory;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.logging.LogService;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.internal.PdxInstanceFactoryImpl;
import com.gemstone.gemfire.pdx.internal.json.PdxListHelper;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.logging.log4j.Logger;

public class PdxInstanceHelper {
    private static final Logger logger = LogService.getLogger();
    PdxInstanceHelper m_parent;
    PdxInstanceFactoryImpl m_pdxInstanceFactory;
    PdxInstance m_pdxInstance;
    String m_PdxName;

    public PdxInstanceHelper(String className, PdxInstanceHelper parent) {
        GemFireCacheImpl gci = (GemFireCacheImpl)CacheFactory.getAnyInstance();
        if (logger.isTraceEnabled()) {
            logger.trace("ClassName {}", className);
        }
        this.m_PdxName = className;
        this.m_parent = parent;
        this.m_pdxInstanceFactory = (PdxInstanceFactoryImpl)gci.createPdxInstanceFactory("__GEMFIRE_JSON", false);
    }

    public PdxInstanceHelper getParent() {
        return this.m_parent;
    }

    public void setPdxFieldName(String name) {
        if (logger.isTraceEnabled()) {
            logger.trace("setPdxClassName : {}", name);
        }
        this.m_PdxName = name;
    }

    public void addStringField(String fieldName, String value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addStringField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeString(fieldName, value2);
    }

    public void addByteField(String fieldName, byte value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addByteField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeByte(fieldName, value2);
    }

    public void addShortField(String fieldName, short value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addShortField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeShort(fieldName, value2);
    }

    public void addIntField(String fieldName, int value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addIntField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeInt(fieldName, value2);
    }

    public void addLongField(String fieldName, long value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addLongField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeLong(fieldName, value2);
    }

    public void addBigDecimalField(String fieldName, BigDecimal value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigDecimalField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value2);
    }

    public void addBigIntegerField(String fieldName, BigInteger value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBigIntegerField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, value2);
    }

    public void addBooleanField(String fieldName, boolean value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addBooleanField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeBoolean(fieldName, value2);
    }

    public void addFloatField(String fieldName, float value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addFloatField fieldName: {}; value: {}", fieldName, Float.valueOf(value2));
        }
        this.m_pdxInstanceFactory.writeFloat(fieldName, value2);
    }

    public void addDoubleField(String fieldName, double value2) {
        if (logger.isTraceEnabled()) {
            logger.trace("addDoubleField fieldName: {}; value: {}", fieldName, value2);
        }
        this.m_pdxInstanceFactory.writeDouble(fieldName, value2);
    }

    public void addNullField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("addNullField fieldName: {}; value: NULL", fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, null);
    }

    public void addListField(String fieldName, PdxListHelper list) {
        if (logger.isTraceEnabled()) {
            logger.trace("addListField fieldName: {}", fieldName);
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, list.getList());
    }

    public void endListField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endListField fieldName: {}", fieldName);
        }
    }

    public void addObjectField(String fieldName, PdxInstance member) {
        if (logger.isTraceEnabled()) {
            logger.trace("addObjectField fieldName: {}", fieldName);
        }
        if (fieldName == null) {
            throw new IllegalStateException("addObjectField:PdxInstance should have fieldname");
        }
        this.m_pdxInstanceFactory.writeObject(fieldName, member);
    }

    public void endObjectField(String fieldName) {
        if (logger.isTraceEnabled()) {
            logger.trace("endObjectField fieldName: {}", fieldName);
        }
        this.m_pdxInstance = this.m_pdxInstanceFactory.create();
    }

    public PdxInstance getPdxInstance() {
        return this.m_pdxInstance;
    }

    public String getPdxFieldName() {
        return this.m_PdxName;
    }
}

