/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gemfire.pdx.internal.json;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.gemstone.gemfire.internal.HeapDataOutputStream;
import com.gemstone.gemfire.internal.Version;
import com.gemstone.gemfire.pdx.JSONFormatter;
import com.gemstone.gemfire.pdx.PdxInstance;
import com.gemstone.gemfire.pdx.internal.EnumInfo;
import com.gemstone.gemfire.pdx.internal.json.JsonHelper;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class PdxToJSON {
    public static boolean PDXTOJJSON_UNQUOTEFIELDNAMES = Boolean.getBoolean("pdxToJson.unQuoteFieldNames");
    private PdxInstance m_pdxInstance;

    public PdxToJSON(PdxInstance pdx) {
        this.m_pdxInstance = pdx;
    }

    public String getJSON() {
        JsonFactory jf = new JsonFactory();
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator jg = jf.createJsonGenerator((OutputStream)hdos, JsonEncoding.UTF8);
            this.enableDisableJSONGeneratorFeature(jg);
            this.getJSONString(jg, this.m_pdxInstance);
            jg.close();
            String string = new String(hdos.toByteArray());
            return string;
        }
    }

    public byte[] getJSONByteArray() {
        JsonFactory jf = new JsonFactory();
        try (HeapDataOutputStream hdos = new HeapDataOutputStream(Version.CURRENT);){
            JsonGenerator jg = jf.createJsonGenerator((OutputStream)hdos, JsonEncoding.UTF8);
            this.enableDisableJSONGeneratorFeature(jg);
            this.getJSONString(jg, this.m_pdxInstance);
            jg.close();
            byte[] byArray = hdos.toByteArray();
            return byArray;
        }
    }

    private void enableDisableJSONGeneratorFeature(JsonGenerator jg) {
        jg.enable(JsonGenerator.Feature.ESCAPE_NON_ASCII);
        jg.disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        jg.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
        if (PDXTOJJSON_UNQUOTEFIELDNAMES) {
            jg.disable(JsonGenerator.Feature.QUOTE_FIELD_NAMES);
        }
    }

    protected String convertPdxToJson(PdxInstance pdxObj) {
        return pdxObj != null ? JSONFormatter.toJSON(pdxObj) : null;
    }

    private void writeValue(JsonGenerator jg, Object value2, String pf) throws JsonGenerationException, IOException {
        if (value2 == null) {
            jg.writeNull();
        } else if (value2.getClass().equals(Boolean.class)) {
            boolean b = (Boolean)value2;
            jg.writeBoolean(b);
        } else if (value2.getClass().equals(Byte.class)) {
            Byte b = (Byte)value2;
            jg.writeNumber((short)b.byteValue());
        } else if (value2.getClass().equals(Short.class)) {
            Short b = (Short)value2;
            jg.writeNumber(b.shortValue());
        } else if (value2.getClass().equals(Integer.class)) {
            int i = (Integer)value2;
            jg.writeNumber(i);
        } else if (value2.getClass().equals(Long.class)) {
            long i = (Long)value2;
            jg.writeNumber(i);
        } else if (value2.getClass().equals(BigInteger.class)) {
            BigInteger i = (BigInteger)value2;
            jg.writeNumber(i);
        } else if (value2.getClass().equals(Float.class)) {
            float i = ((Float)value2).floatValue();
            jg.writeNumber(i);
        } else if (value2.getClass().equals(BigDecimal.class)) {
            BigDecimal i = (BigDecimal)value2;
            jg.writeNumber(i);
        } else if (value2.getClass().equals(Double.class)) {
            double d = (Double)value2;
            jg.writeNumber(d);
        } else if (value2.getClass().equals(String.class)) {
            String s = (String)value2;
            jg.writeString(s);
        } else if (value2.getClass().isArray()) {
            this.getJSONStringFromArray(jg, value2, pf);
        } else if (value2.getClass().equals(EnumInfo.class)) {
            jg.writeString(value2.toString());
        } else if (value2.getClass().equals(EnumInfo.PdxInstanceEnumInfo.class)) {
            jg.writeString(value2.toString());
        } else if (value2 instanceof PdxInstance) {
            this.getJSONString(jg, (PdxInstance)value2);
        } else if (value2 instanceof Collection) {
            this.getJSONStringFromCollection(jg, (Collection)value2, pf);
        } else if (value2 instanceof Map) {
            this.getJSONStringFromMap(jg, (Map)value2, pf);
        } else {
            throw new IllegalStateException("PdxInstance returns unknwon pdxfield " + pf + " for type " + value2);
        }
    }

    private void getJSONStringFromMap(JsonGenerator jg, Map map, String pf) throws JsonGenerationException, IOException {
        jg.writeStartObject();
        for (Map.Entry entry : map.entrySet()) {
            jg.writeFieldName(entry.getKey().toString());
            this.writeValue(jg, entry.getValue(), pf);
        }
        jg.writeEndObject();
    }

    private String getJSONString(JsonGenerator jg, PdxInstance pdxInstance) throws JsonGenerationException, IOException {
        jg.writeStartObject();
        List<String> pdxFields = pdxInstance.getFieldNames();
        for (String pf : pdxFields) {
            Object value2 = pdxInstance.getField(pf);
            jg.writeFieldName(pf);
            this.writeValue(jg, value2, pf);
        }
        jg.writeEndObject();
        return null;
    }

    private void getJSONStringFromArray(JsonGenerator jg, Object value2, String pf) throws JsonGenerationException, IOException {
        if (value2.getClass().getName().equals("[Z")) {
            JsonHelper.getJsonFromPrimitiveBoolArray(jg, (boolean[])value2, pf);
        } else if (value2.getClass().getName().equals("[B")) {
            JsonHelper.getJsonFromPrimitiveByteArray(jg, (byte[])value2, pf);
        } else if (value2.getClass().getName().equals("[S")) {
            JsonHelper.getJsonFromPrimitiveShortArray(jg, (short[])value2, pf);
        } else if (value2.getClass().getName().equals("[I")) {
            JsonHelper.getJsonFromPrimitiveIntArray(jg, (int[])value2, pf);
        } else if (value2.getClass().getName().equals("[J")) {
            JsonHelper.getJsonFromPrimitiveLongArray(jg, (long[])value2, pf);
        } else if (value2.getClass().getName().equals("[F")) {
            JsonHelper.getJsonFromPrimitiveFloatArray(jg, (float[])value2, pf);
        } else if (value2.getClass().getName().equals("[D")) {
            JsonHelper.getJsonFromPrimitiveDoubleArray(jg, (double[])value2, pf);
        } else if (value2.getClass().equals(Boolean[].class)) {
            JsonHelper.getJsonFromWrapperBoolArray(jg, (Boolean[])value2, pf);
        } else if (value2.getClass().equals(Byte[].class)) {
            JsonHelper.getJsonFromWrapperByteArray(jg, (Byte[])value2, pf);
        } else if (value2.getClass().equals(Short[].class)) {
            JsonHelper.getJsonFromWrapperShortArray(jg, (Short[])value2, pf);
        } else if (value2.getClass().equals(Integer[].class)) {
            JsonHelper.getJsonFromWrapperIntArray(jg, (Integer[])value2, pf);
        } else if (value2.getClass().equals(Long[].class)) {
            JsonHelper.getJsonFromWrapperLongArray(jg, (Long[])value2, pf);
        } else if (value2.getClass().equals(Float[].class)) {
            JsonHelper.getJsonFromWrapperFloatArray(jg, (Float[])value2, pf);
        } else if (value2.getClass().equals(Double[].class)) {
            JsonHelper.getJsonFromWrapperDoubleArray(jg, (Double[])value2, pf);
        } else if (value2.getClass().equals(BigInteger[].class)) {
            JsonHelper.getJsonFromBigIntArray(jg, (BigInteger[])value2, pf);
        } else if (value2.getClass().equals(BigDecimal[].class)) {
            JsonHelper.getJsonFromBigDecimalArray(jg, (BigDecimal[])value2, pf);
        } else if (value2.getClass().equals(String[].class)) {
            JsonHelper.getJsonFromStringArray(jg, (String[])value2, pf);
        } else if (value2.getClass().equals(Object[].class)) {
            Object[] array;
            jg.writeStartArray();
            for (Object obj : array = (Object[])value2) {
                this.writeValue(jg, obj, pf);
            }
            jg.writeEndArray();
        } else {
            throw new IllegalStateException("PdxInstance returns unknwon pdxfield " + pf + " for type " + value2);
        }
    }

    private <T> void getJSONStringFromArray1(JsonGenerator jg, T[] array, String pf) throws JsonGenerationException, IOException {
        jg.writeStartArray();
        for (T obj : array) {
            this.writeValue(jg, obj, pf);
        }
        jg.writeEndArray();
    }

    private void getJSONStringFromCollection(JsonGenerator jg, Collection<?> coll, String pf) throws JsonGenerationException, IOException {
        jg.writeStartArray();
        for (Object obj : coll) {
            this.writeValue(jg, obj, pf);
        }
        jg.writeEndArray();
    }
}

