/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.PrimeFinder;

public abstract class THash
implements Cloneable {
    protected transient int _size;
    protected transient int _free;
    protected static final float DEFAULT_LOAD_FACTOR = 0.5f;
    protected static final int DEFAULT_INITIAL_CAPACITY = 10;
    protected float _loadFactor;
    protected int _maxSize;
    protected static final int CONDITIONAL_COMPACT_FACTOR = 2;

    public THash() {
        this(10, 0.5f);
    }

    public THash(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public THash(int initialCapacity, float loadFactor) {
        this._loadFactor = loadFactor;
        this.setUp((int)Math.ceil((float)initialCapacity / loadFactor));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    public boolean isEmpty() {
        return 0 == this._size;
    }

    public int size() {
        return this._size;
    }

    protected abstract int capacity();

    public void ensureCapacity(int desiredCapacity) {
        if (desiredCapacity > this._maxSize - this.size()) {
            this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)desiredCapacity + (float)this.size() / this._loadFactor) + 1));
            this.computeMaxSize(this.capacity());
        }
    }

    public void compact() {
        this.rehash(PrimeFinder.nextPrime((int)Math.ceil((float)this.size() / this._loadFactor) + 1));
        this.computeMaxSize(this.capacity());
    }

    public void conditionalCompact() {
        if ((float)this._size < (float)this.capacity() * (this._loadFactor / 2.0f)) {
            this.compact();
        }
    }

    public final void trimToSize() {
        this.compact();
    }

    protected void removeAt(int index2) {
        --this._size;
    }

    public void clear() {
        this._size = 0;
        this._free = this.capacity();
    }

    protected int setUp(int initialCapacity) {
        int capacity = PrimeFinder.nextPrime(initialCapacity);
        this.computeMaxSize(capacity);
        return capacity;
    }

    protected abstract void rehash(int var1);

    private final void computeMaxSize(int capacity) {
        this._maxSize = Math.min(capacity - 1, (int)Math.floor((float)capacity * this._loadFactor));
        this._free = capacity - this._size;
    }

    protected final void postInsertHook(boolean usedFreeSlot) {
        if (usedFreeSlot) {
            --this._free;
        }
        if (++this._size > this._maxSize || this._free == 0) {
            int newCapacity = this._size > this._maxSize ? PrimeFinder.nextPrime(this.capacity() << 1) : this.capacity();
            this.rehash(newCapacity);
            this.computeMaxSize(this.capacity());
        }
    }
}

