/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.SerializationProcedure;
import com.gemstone.gnu.trove.THashIterator;
import com.gemstone.gnu.trove.TObjectFunction;
import com.gemstone.gnu.trove.TObjectHash;
import com.gemstone.gnu.trove.TObjectHashIterator;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.gemstone.gnu.trove.TObjectObjectProcedure;
import com.gemstone.gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class THashMap
extends TObjectHash
implements Map,
Serializable {
    private static final long serialVersionUID = 7557893848987411935L;
    protected transient Object[] _values;

    public THashMap() {
    }

    public THashMap(TObjectHashingStrategy strategy) {
        super(strategy);
    }

    public THashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public THashMap(int initialCapacity, TObjectHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public THashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public THashMap(int initialCapacity, float loadFactor, TObjectHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public THashMap(Map map) {
        this(map.size());
        this.putAll(map);
    }

    public THashMap(Map map, TObjectHashingStrategy strategy) {
        this(map.size(), strategy);
        this.putAll(map);
    }

    @Override
    public Object clone() {
        THashMap m = (THashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(Object key2, Object value2) {
        if (null == key2) {
            throw new NullPointerException("null keys not supported");
        }
        Object previous = null;
        Object oldKey = null;
        int index2 = this.insertionIndex(key2);
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
        }
        oldKey = this._set[index2];
        this._set[index2] = key2;
        this._values[index2] = value2;
        if (null == previous) {
            this.postInsertHook(oldKey == null);
        }
        return previous;
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Map)) {
            return false;
        }
        Map that = (Map)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    @Override
    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    public boolean forEachKey(TObjectProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        Object[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TObjectObjectProcedure procedure) {
        Object[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TObjectObjectProcedure procedure) {
        boolean modified = false;
        Object[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (keys[i] == null || keys[i] == REMOVED || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TObjectFunction function) {
        Object[] values = this._values;
        Object[] set = this._set;
        int i = values.length;
        while (i-- > 0) {
            if (set[i] == null || set[i] == REMOVED) continue;
            values[i] = function.execute(values[i]);
        }
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        Object[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new Object[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldKeys[i] == null || oldKeys[i] == REMOVED) continue;
            Object o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            if (index2 < 0) {
                this.throwObjectContractViolation(this._set[-index2 - 1], o);
            }
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
        }
    }

    public Object get(Object key2) {
        int index2 = this.index(key2);
        return index2 < 0 ? null : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        Object[] keys = this._set;
        Object[] vals = this._values;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = null;
            vals[i] = null;
        }
    }

    public Object remove(Object key2) {
        Object prev = null;
        int index2 = this.index(key2);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    @Override
    protected void removeAt(int index2) {
        super.removeAt(index2);
        this._values[index2] = null;
    }

    public Collection values() {
        return new ValueView();
    }

    public Set keySet() {
        return new KeyView();
    }

    public Set entrySet() {
        return new EntryView();
    }

    @Override
    public boolean containsValue(Object val) {
        Object[] set = this._set;
        Object[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == REMOVED || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (set[i] == null || set[i] == REMOVED || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(Object key2) {
        return this.contains(key2);
    }

    public void putAll(Map map) {
        this.ensureCapacity(map.size());
        for (Map.Entry e : map.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            Object key2 = stream.readObject();
            Object val = stream.readObject();
            this.put(key2, val);
        }
    }

    final class Entry
    implements Map.Entry {
        private final Object key;
        private Object val;
        private final int index;

        Entry(Object key2, Object value2, int index2) {
            this.key = key2;
            this.val = value2;
            this.index = index2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.val;
        }

        public Object setValue(Object o) {
            if (THashMap.this._values[this.index] != this.val) {
                throw new ConcurrentModificationException();
            }
            THashMap.this._values[this.index] = o;
            this.val = o = this.val;
            return o;
        }
    }

    protected class KeyView
    implements Set {
        protected KeyView() {
        }

        @Override
        public Iterator iterator() {
            return new TObjectHashIterator(THashMap.this);
        }

        @Override
        public int hashCode() {
            int h = 0;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                h += i.next().hashCode();
            }
            return h;
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other)) {
                return true;
            }
            if (other instanceof Collection) {
                Collection that = (Collection)other;
                return this.size() == that.size() && this.containsAll(that);
            }
            return false;
        }

        @Override
        public boolean remove(Object key2) {
            return null != THashMap.this.remove(key2);
        }

        @Override
        public boolean contains(Object key2) {
            return THashMap.this.contains(key2);
        }

        @Override
        public boolean containsAll(Collection collection) {
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (this.contains(i.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean removeAll(Collection collection) {
            boolean changed = false;
            Iterator i = collection.iterator();
            while (i.hasNext()) {
                if (!this.remove(i.next())) continue;
                changed = true;
            }
            return changed;
        }

        @Override
        public void clear() {
            THashMap.this.clear();
        }

        @Override
        public boolean add(Object obj) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return THashMap.this.size();
        }

        @Override
        public Object[] toArray() {
            Object[] result = new Object[this.size()];
            Iterator e = this.iterator();
            int i = 0;
            while (e.hasNext()) {
                result[i] = e.next();
                ++i;
            }
            return result;
        }

        @Override
        public Object[] toArray(Object[] a) {
            int size2 = this.size();
            if (a.length < size2) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), size2);
            }
            Iterator it = this.iterator();
            for (int i = 0; i < size2; ++i) {
                a[i] = it.next();
            }
            if (a.length > size2) {
                a[size2] = null;
            }
            return a;
        }

        @Override
        public boolean isEmpty() {
            return THashMap.this.isEmpty();
        }

        @Override
        public boolean addAll(Collection collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection collection) {
            boolean changed = false;
            Iterator i = this.iterator();
            while (i.hasNext()) {
                if (collection.contains(i.next())) continue;
                i.remove();
                changed = true;
            }
            return changed;
        }

        protected final class EntryIterator
        extends THashIterator {
            EntryIterator(THashMap map) {
                super(map);
            }

            @Override
            public Object objectAtIndex(int index2) {
                return new Entry(THashMap.this._set[index2], THashMap.this._values[index2], index2);
            }
        }
    }

    protected class EntryView
    extends KeyView {
        protected EntryView() {
        }

        @Override
        public Iterator iterator() {
            return new KeyView.EntryIterator(THashMap.this);
        }

        @Override
        public boolean remove(Object entry) {
            Object val;
            Object key2 = this.keyForEntry(entry);
            int index2 = THashMap.this.index(key2);
            if (index2 >= 0 && ((val = this.valueForEntry(entry)) == THashMap.this._values[index2] || null != val && val.equals(THashMap.this._values[index2]))) {
                THashMap.this.removeAt(index2);
                return true;
            }
            return false;
        }

        @Override
        public boolean contains(Object entry) {
            Object val = THashMap.this.get(this.keyForEntry(entry));
            Object entryValue = ((Map.Entry)entry).getValue();
            return entryValue == val || null != val && val.equals(entryValue);
        }

        protected Object valueForEntry(Object entry) {
            return ((Map.Entry)entry).getValue();
        }

        protected Object keyForEntry(Object entry) {
            return ((Map.Entry)entry).getKey();
        }
    }

    protected class ValueView
    extends KeyView {
        protected ValueView() {
        }

        @Override
        public Iterator iterator() {
            return new THashIterator(THashMap.this){

                @Override
                protected Object objectAtIndex(int index2) {
                    return THashMap.this._values[index2];
                }
            };
        }

        @Override
        public boolean contains(Object value2) {
            return THashMap.this.containsValue(value2);
        }

        @Override
        public boolean remove(Object value2) {
            boolean changed = false;
            Object[] values = THashMap.this._values;
            Object[] set = THashMap.this._set;
            int i = values.length;
            while (i-- > 0) {
                if ((set[i] == null || set[i] == TObjectHash.REMOVED || value2 != values[i]) && (null == values[i] || !values[i].equals(value2))) continue;
                THashMap.this.removeAt(i);
                changed = true;
            }
            return changed;
        }
    }

    private static final class EqProcedure
    implements TObjectObjectProcedure {
        private final Map _otherMap;

        EqProcedure(Map otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(Object key2, Object value2) {
            Object oValue = this._otherMap.get(key2);
            return oValue == value2 || oValue != null && oValue.equals(value2);
        }
    }

    protected final class HashProcedure
    implements TObjectObjectProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(Object key2, Object value2) {
            this.h += THashMap.this._hashingStrategy.computeHashCode(key2) ^ (value2 == null ? 0 : value2.hashCode());
            return true;
        }
    }
}

