/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.SerializationProcedure;
import com.gemstone.gnu.trove.TIntHash;
import com.gemstone.gnu.trove.TIntHashingStrategy;
import com.gemstone.gnu.trove.TIntIterator;
import com.gemstone.gnu.trove.TIntProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TIntHashSet
extends TIntHash
implements Serializable {
    private static final long serialVersionUID = 3283149941061564972L;

    public TIntHashSet() {
    }

    public TIntHashSet(int initialCapacity) {
        super(initialCapacity);
    }

    public TIntHashSet(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TIntHashSet(int[] array) {
        this(array.length);
        this.addAll(array);
    }

    public TIntHashSet(TIntHashingStrategy strategy) {
        super(strategy);
    }

    public TIntHashSet(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TIntHashSet(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    public TIntHashSet(int[] array, TIntHashingStrategy strategy) {
        this(array.length, strategy);
        this.addAll(array);
    }

    public TIntIterator iterator() {
        return new TIntIterator(this);
    }

    public boolean add(int val) {
        int index2 = this.insertionIndex(val);
        if (index2 < 0) {
            return false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = val;
        this._states[index2] = 1;
        this.postInsertHook(previousState == 0);
        return true;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldSet = this._set;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldSet[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._states[index2] = 1;
        }
    }

    public int[] toArray() {
        int[] result = new int[this.size()];
        int[] set = this._set;
        byte[] states2 = this._states;
        int i = states2.length;
        int j = 0;
        while (i-- > 0) {
            if (states2[i] != 1) continue;
            result[j++] = set[i];
        }
        return result;
    }

    @Override
    public void clear() {
        super.clear();
        int[] set = this._set;
        byte[] states2 = this._states;
        int i = set.length;
        while (i-- > 0) {
            set[i] = 0;
            states2[i] = 0;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntHashSet)) {
            return false;
        }
        final TIntHashSet that = (TIntHashSet)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEach(new TIntProcedure(){

            @Override
            public final boolean execute(int value2) {
                return that.contains(value2);
            }
        });
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEach(p);
        return p.getHashCode();
    }

    public boolean remove(int val) {
        int index2 = this.index(val);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public boolean containsAll(int[] array) {
        int i = array.length;
        while (i-- > 0) {
            if (this.contains(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.add(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean removeAll(int[] array) {
        boolean changed = false;
        int i = array.length;
        while (i-- > 0) {
            if (!this.remove(array[i])) continue;
            changed = true;
        }
        return changed;
    }

    public boolean retainAll(int[] array) {
        boolean changed = false;
        Arrays.sort(array);
        int[] set = this._set;
        byte[] states2 = this._states;
        int i = set.length;
        while (i-- > 0) {
            if (states2[i] != 1 || Arrays.binarySearch(array, set[i]) >= 0) continue;
            this.remove(set[i]);
            changed = true;
        }
        return changed;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            int val = stream.readInt();
            this.add(val);
        }
    }

    protected final class HashProcedure
    implements TIntProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(int key2) {
            this.h += TIntHashSet.this._hashingStrategy.computeHashCode(key2);
            return true;
        }
    }
}

