/*
 * Decompiled with CFR 0.152.
 */
package com.gemstone.gnu.trove;

import com.gemstone.gnu.trove.HashFunctions;
import com.gemstone.gnu.trove.SerializationProcedure;
import com.gemstone.gnu.trove.TIntHash;
import com.gemstone.gnu.trove.TIntHashingStrategy;
import com.gemstone.gnu.trove.TIntObjectIterator;
import com.gemstone.gnu.trove.TIntObjectProcedure;
import com.gemstone.gnu.trove.TIntProcedure;
import com.gemstone.gnu.trove.TObjectFunction;
import com.gemstone.gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class TIntObjectHashMap
extends TIntHash
implements Serializable {
    private static final long serialVersionUID = -313496576027551184L;
    protected transient Object[] _values;

    public TIntObjectHashMap() {
    }

    public TIntObjectHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public TIntObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public TIntObjectHashMap(TIntHashingStrategy strategy) {
        super(strategy);
    }

    public TIntObjectHashMap(int initialCapacity, TIntHashingStrategy strategy) {
        super(initialCapacity, strategy);
    }

    public TIntObjectHashMap(int initialCapacity, float loadFactor, TIntHashingStrategy strategy) {
        super(initialCapacity, loadFactor, strategy);
    }

    @Override
    public Object clone() {
        TIntObjectHashMap m = (TIntObjectHashMap)super.clone();
        m._values = (Object[])this._values.clone();
        return m;
    }

    public TIntObjectIterator iterator() {
        return new TIntObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = new Object[capacity];
        return capacity;
    }

    public Object put(int key2, Object value2) {
        Object previous = null;
        int index2 = this.insertionIndex(key2);
        boolean isNewMapping = true;
        if (index2 < 0) {
            index2 = -index2 - 1;
            previous = this._values[index2];
            isNewMapping = false;
        }
        byte previousState = this._states[index2];
        this._set[index2] = key2;
        this._states[index2] = 1;
        this._values[index2] = value2;
        if (isNewMapping) {
            this.postInsertHook(previousState == 0);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this._set.length;
        int[] oldKeys = this._set;
        Object[] oldVals = this._values;
        byte[] oldStates = this._states;
        this._set = new int[newCapacity];
        this._values = new Object[newCapacity];
        this._states = new byte[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (oldStates[i] != 1) continue;
            int o = oldKeys[i];
            int index2 = this.insertionIndex(o);
            this._set[index2] = o;
            this._values[index2] = oldVals[i];
            this._states[index2] = 1;
        }
    }

    public Object get(int key2) {
        int index2 = this.index(key2);
        return index2 < 0 ? null : this._values[index2];
    }

    @Override
    public void clear() {
        super.clear();
        int[] keys = this._set;
        Object[] vals = this._values;
        byte[] states2 = this._states;
        int i = keys.length;
        while (i-- > 0) {
            keys[i] = 0;
            vals[i] = null;
            states2[i] = 0;
        }
    }

    public Object remove(int key2) {
        Object prev = null;
        int index2 = this.index(key2);
        if (index2 >= 0) {
            prev = this._values[index2];
            this.removeAt(index2);
        }
        return prev;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TIntObjectHashMap)) {
            return false;
        }
        TIntObjectHashMap that = (TIntObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index2) {
        super.removeAt(index2);
        this._values[index2] = null;
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] v = this._values;
        byte[] states2 = this._states;
        int i = v.length;
        int j = 0;
        while (i-- > 0) {
            if (states2[i] != 1) continue;
            vals[j++] = v[i];
        }
        return vals;
    }

    public int[] keys() {
        int[] keys = new int[this.size()];
        int[] k = this._set;
        byte[] states2 = this._states;
        int i = k.length;
        int j = 0;
        while (i-- > 0) {
            if (states2[i] != 1) continue;
            keys[j++] = k[i];
        }
        return keys;
    }

    public boolean containsValue(Object val) {
        byte[] states2 = this._states;
        Object[] vals = this._values;
        if (null == val) {
            int i = vals.length;
            while (i-- > 0) {
                if (states2[i] != 1 || val != vals[i]) continue;
                return true;
            }
        } else {
            int i = vals.length;
            while (i-- > 0) {
                if (states2[i] != 1 || val != vals[i] && !val.equals(vals[i])) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(int key2) {
        return this.contains(key2);
    }

    public boolean forEachKey(TIntProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure procedure) {
        byte[] states2 = this._states;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states2[i] != 1 || procedure.execute(values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TIntObjectProcedure procedure) {
        byte[] states2 = this._states;
        int[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states2[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            return false;
        }
        return true;
    }

    public boolean retainEntries(TIntObjectProcedure procedure) {
        boolean modified = false;
        byte[] states2 = this._states;
        int[] keys = this._set;
        Object[] values = this._values;
        int i = keys.length;
        while (i-- > 0) {
            if (states2[i] != 1 || procedure.execute(keys[i], values[i])) continue;
            this.removeAt(i);
            modified = true;
        }
        return modified;
    }

    public void transformValues(TObjectFunction function) {
        byte[] states2 = this._states;
        Object[] values = this._values;
        int i = values.length;
        while (i-- > 0) {
            if (states2[i] != 1) continue;
            values[i] = function.execute(values[i]);
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size2 = stream.readInt();
        this.setUp(size2);
        while (size2-- > 0) {
            int key2 = stream.readInt();
            Object val = stream.readObject();
            this.put(key2, val);
        }
    }

    private static final class EqProcedure
    implements TIntObjectProcedure {
        private final TIntObjectHashMap _otherMap;

        EqProcedure(TIntObjectHashMap otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(int key2, Object value2) {
            int index2 = this._otherMap.index(key2);
            return index2 >= 0 && this.eq(value2, this._otherMap.get(key2));
        }

        private final boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    protected final class HashProcedure
    implements TIntObjectProcedure {
        private int h = 0;

        protected HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(int key2, Object value2) {
            this.h += TIntObjectHashMap.this._hashingStrategy.computeHashCode(key2) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

